/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.entity;

import com.almasb.ents.Component;
import com.almasb.ents.Control;
import com.almasb.ents.Entity;
import com.almasb.fxgl.app.FXGL;
import com.almasb.fxgl.entity.GameEntity;
import com.almasb.fxgl.entity.animation.AnimationBuilder;
import com.almasb.fxgl.entity.component.BoundingBoxComponent;
import com.almasb.fxgl.entity.component.MainViewComponent;
import com.almasb.fxgl.entity.component.PositionComponent;
import com.almasb.fxgl.entity.component.RotationComponent;
import com.almasb.fxgl.entity.component.TypeComponent;
import com.almasb.fxgl.gameplay.GameWorld;
import com.almasb.fxgl.physics.BoundingShape;
import com.almasb.fxgl.physics.HitBox;
import com.almasb.fxgl.physics.PhysicsComponent;
import javafx.geometry.Point2D;
import javafx.scene.Node;

public class Entities {
    public static PositionComponent getPosition(Entity e) {
        return (PositionComponent)e.getComponentUnsafe(PositionComponent.class);
    }

    public static RotationComponent getRotation(Entity e) {
        return (RotationComponent)e.getComponentUnsafe(RotationComponent.class);
    }

    public static BoundingBoxComponent getBBox(Entity e) {
        return (BoundingBoxComponent)e.getComponentUnsafe(BoundingBoxComponent.class);
    }

    public static PhysicsComponent getPhysics(Entity e) {
        return (PhysicsComponent)e.getComponentUnsafe(PhysicsComponent.class);
    }

    public static MainViewComponent getMainView(Entity e) {
        return (MainViewComponent)e.getComponentUnsafe(MainViewComponent.class);
    }

    public static TypeComponent getType(Entity e) {
        return (TypeComponent)e.getComponentUnsafe(TypeComponent.class);
    }

    public static Entity makeScreenBounds(double thickness) {
        double w = FXGL.getSettings().getWidth();
        double h = FXGL.getSettings().getHeight();
        Entity bounds = new Entity();
        bounds.addComponent((Component)new PositionComponent(0.0, 0.0));
        bounds.addComponent((Component)new RotationComponent(0.0));
        bounds.addComponent((Component)new BoundingBoxComponent(new HitBox("LEFT", new Point2D(-thickness, 0.0), BoundingShape.box(thickness, h)), new HitBox("RIGHT", new Point2D(w, 0.0), BoundingShape.box(thickness, h)), new HitBox("TOP", new Point2D(0.0, -thickness), BoundingShape.box(w, thickness)), new HitBox("BOT", new Point2D(0.0, h), BoundingShape.box(w, thickness))));
        bounds.addComponent((Component)new PhysicsComponent());
        return bounds;
    }

    public static GameEntityBuilder builder() {
        return new GameEntityBuilder();
    }

    public static AnimationBuilder animationBuilder() {
        return new AnimationBuilder();
    }

    public static class GameEntityBuilder {
        private GameEntity entity = new GameEntity();

        public GameEntityBuilder type(Enum<?> type) {
            this.entity.getTypeComponent().setValue(type);
            return this;
        }

        public GameEntityBuilder at(double x, double y) {
            this.entity.getPositionComponent().setValue(x, y);
            return this;
        }

        public GameEntityBuilder at(Point2D position2) {
            return this.at(position2.getX(), position2.getY());
        }

        public GameEntityBuilder rotate(double angle) {
            this.entity.getRotationComponent().setValue(angle);
            return this;
        }

        public GameEntityBuilder bbox(HitBox box) {
            this.entity.getBoundingBoxComponent().addHitBox(box);
            return this;
        }

        public GameEntityBuilder viewFromNode(Node view) {
            this.entity.getMainViewComponent().setView(view);
            return this;
        }

        public GameEntityBuilder viewFromNodeWithBBox(Node view) {
            this.entity.getMainViewComponent().setView(view, true);
            return this;
        }

        public GameEntityBuilder viewFromTexture(String textureName) {
            this.entity.getMainViewComponent().setTexture(textureName);
            return this;
        }

        public GameEntityBuilder viewFromTextureWithBBox(String textureName) {
            this.entity.getMainViewComponent().setTexture(textureName, true);
            return this;
        }

        public GameEntityBuilder with(Component ... components) {
            for (Component c : components) {
                this.entity.addComponent(c);
            }
            return this;
        }

        public GameEntityBuilder with(Control ... controls) {
            for (Control c : controls) {
                this.entity.addControl(c);
            }
            return this;
        }

        public GameEntity build() {
            return this.entity;
        }

        public GameEntity buildAndAttach(GameWorld world) {
            world.addEntity(this.entity);
            return this.entity;
        }
    }
}

