/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.entity;

import com.almasb.fxgl.app.FXGL;
import com.almasb.fxgl.entity.EntityView;
import com.almasb.fxgl.entity.RenderLayer;
import com.almasb.fxgl.scene.Viewport;
import com.almasb.fxgl.texture.Texture;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.image.Image;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B#\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0014\u001a\u00020\u0015H\u0002J\b\u0010\u0016\u001a\u00020\u0015H\u0002J\b\u0010\u0017\u001a\u00020\u0015H\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/almasb/fxgl/entity/ScrollingBackgroundView;", "Lcom/almasb/fxgl/entity/EntityView;", "texture", "Lcom/almasb/fxgl/texture/Texture;", "orientation", "Ljavafx/geometry/Orientation;", "renderLayer", "Lcom/almasb/fxgl/entity/RenderLayer;", "(Lcom/almasb/fxgl/texture/Texture;Ljavafx/geometry/Orientation;Lcom/almasb/fxgl/entity/RenderLayer;)V", "canvas", "Ljavafx/scene/canvas/Canvas;", "g", "Ljavafx/scene/canvas/GraphicsContext;", "image", "Ljavafx/scene/image/Image;", "getOrientation", "()Ljavafx/geometry/Orientation;", "sx", "", "sy", "redraw", "", "redrawX", "redrawY", "fxgl"})
public final class ScrollingBackgroundView
extends EntityView {
    private final Canvas canvas;
    private final GraphicsContext g;
    private final Image image;
    private double sx;
    private double sy;
    @NotNull
    private final Orientation orientation;

    private final void redraw() {
        this.g.clearRect(0.0, 0.0, this.canvas.getWidth(), this.canvas.getHeight());
        if (Intrinsics.areEqual((Object)this.orientation, (Object)Orientation.HORIZONTAL)) {
            this.redrawX();
        } else {
            this.redrawY();
        }
    }

    private final void redrawX() {
        boolean overflowX;
        double w = this.canvas.getWidth();
        double h = this.canvas.getHeight();
        boolean bl = overflowX = this.sx + w > this.image.getWidth();
        if (overflowX) {
            w = this.image.getWidth() - this.sx;
        }
        this.g.drawImage(this.image, this.sx, this.sy, w, h, 0.0, 0.0, w, h);
        if (overflowX) {
            this.g.drawImage(this.image, 0.0, 0.0, this.canvas.getWidth() - w, h, w, 0.0, this.canvas.getWidth() - w, h);
        }
    }

    private final void redrawY() {
        boolean overflowY;
        double w = this.canvas.getWidth();
        double h = this.canvas.getHeight();
        boolean bl = overflowY = this.sy + h > this.image.getHeight();
        if (overflowY) {
            h = this.image.getHeight() - this.sy;
        }
        this.g.drawImage(this.image, this.sx, this.sy, w, h, 0.0, 0.0, w, h);
        if (overflowY) {
            this.g.drawImage(this.image, 0.0, 0.0, w, this.canvas.getHeight() - h, 0.0, h, w, this.canvas.getHeight() - h);
        }
    }

    @NotNull
    public final Orientation getOrientation() {
        return this.orientation;
    }

    @JvmOverloads
    public ScrollingBackgroundView(@NotNull Texture texture, @NotNull Orientation orientation, @NotNull RenderLayer renderLayer) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)texture), (String)"texture");
        Intrinsics.checkParameterIsNotNull((Object)orientation, (String)"orientation");
        Intrinsics.checkParameterIsNotNull((Object)renderLayer, (String)"renderLayer");
        super(renderLayer);
        this.orientation = orientation;
        Image image = texture.getImage();
        Intrinsics.checkExpressionValueIsNotNull((Object)image, (String)"texture.image");
        this.image = image;
        Viewport viewport = FXGL.Companion.getApp().getGameScene().getViewport();
        this.canvas = new Canvas(viewport.getWidth(), viewport.getHeight());
        GraphicsContext graphicsContext = this.canvas.getGraphicsContext2D();
        Intrinsics.checkExpressionValueIsNotNull((Object)graphicsContext, (String)"canvas.graphicsContext2D");
        this.g = graphicsContext;
        if (Intrinsics.areEqual((Object)this.orientation, (Object)Orientation.HORIZONTAL)) {
            this.translateXProperty().addListener((ChangeListener)new ChangeListener<Number>(){

                public final void changed(ObservableValue<? extends Number> obs, Number old, Number x) {
                    if (x.intValue() < 0) {
                        throw (Throwable)new IllegalStateException("Background x cannot be < 0");
                    }
                    sx = x.doubleValue() % image.getWidth();
                    this.redraw();
                }
            });
            this.translateXProperty().bind((ObservableValue)viewport.xProperty());
        } else {
            this.translateYProperty().addListener((ChangeListener)new ChangeListener<Number>(){

                public final void changed(ObservableValue<? extends Number> obs, Number old, Number y) {
                    if (y.intValue() < 0) {
                        throw (Throwable)new IllegalStateException("Background y cannot be < 0");
                    }
                    sy = y.doubleValue() % image.getHeight();
                    this.redraw();
                }
            });
            this.translateYProperty().bind((ObservableValue)viewport.yProperty());
        }
        this.addNode((Node)this.canvas);
        this.redraw();
    }

    @JvmOverloads
    public /* synthetic */ ScrollingBackgroundView(Texture texture, Orientation orientation, RenderLayer renderLayer, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            orientation = Orientation.HORIZONTAL;
        }
        if ((n & 4) != 0) {
            RenderLayer renderLayer2 = RenderLayer.BACKGROUND;
            Intrinsics.checkExpressionValueIsNotNull((Object)renderLayer2, (String)"RenderLayer.BACKGROUND");
            renderLayer = renderLayer2;
        }
        this(texture, orientation, renderLayer);
    }

    @JvmOverloads
    public ScrollingBackgroundView(@NotNull Texture texture, @NotNull Orientation orientation) {
        this(texture, orientation, null, 4, null);
    }

    @JvmOverloads
    public ScrollingBackgroundView(@NotNull Texture texture) {
        this(texture, null, null, 6, null);
    }

    public static final /* synthetic */ double access$getSx$p(ScrollingBackgroundView $this) {
        return $this.sx;
    }

    public static final /* synthetic */ double access$getSy$p(ScrollingBackgroundView $this) {
        return $this.sy;
    }
}

