/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.entity.animation;

import com.almasb.fxgl.entity.GameEntity;
import com.almasb.fxgl.entity.animation.RotationAnimationBuilder;
import com.almasb.fxgl.entity.animation.ScaleAnimationBuilder;
import com.almasb.fxgl.entity.animation.TranslationAnimationBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javafx.util.Duration;

public class AnimationBuilder {
    private Duration duration = Duration.seconds((double)1.0);
    private Duration delay = Duration.ZERO;
    private int times = 1;
    private List<GameEntity> entities = new ArrayList<GameEntity>();

    Duration getDelay() {
        return this.delay;
    }

    Duration getDuration() {
        return this.duration;
    }

    int getTimes() {
        return this.times;
    }

    List<GameEntity> getEntities() {
        return this.entities;
    }

    public AnimationBuilder duration(Duration duration) {
        this.duration = duration;
        return this;
    }

    public AnimationBuilder delay(Duration delay) {
        this.delay = delay;
        return this;
    }

    public AnimationBuilder repeat(int times) {
        this.times = times;
        return this;
    }

    public RotationAnimationBuilder rotate(GameEntity ... entities) {
        return this.rotate(Arrays.asList(entities));
    }

    public RotationAnimationBuilder rotate(List<GameEntity> entities) {
        this.entities.addAll(entities);
        return new RotationAnimationBuilder(this);
    }

    public TranslationAnimationBuilder translate(GameEntity ... entities) {
        Collections.addAll(this.entities, entities);
        return new TranslationAnimationBuilder(this);
    }

    public ScaleAnimationBuilder scale(GameEntity ... entities) {
        Collections.addAll(this.entities, entities);
        return new ScaleAnimationBuilder(this);
    }
}

