/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.entity.component;

import com.almasb.ents.component.DoubleComponent;

public abstract class RechargeableComponent
extends DoubleComponent {
    private double maxValue;

    public RechargeableComponent(double maxValue) {
        super(maxValue);
        this.maxValue = maxValue;
    }

    public double getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(double maxValue) {
        this.maxValue = maxValue;
    }

    public void damage(double value) {
        this.setValue(Math.max(0.0, this.getValue() - value));
    }

    public void damagePercentageCurrent(double value) {
        this.damage(value / 100.0 * this.getValue());
    }

    public void damagePercentageMax(double value) {
        this.damage(value / 100.0 * this.maxValue);
    }

    public void restore(double value) {
        this.setValue(Math.min(this.maxValue, this.getValue() + value));
    }

    public void restorePercentageCurrent(double value) {
        this.restore(value / 100.0 * this.getValue());
    }

    public void restorePercentageMax(double value) {
        this.restore(value / 100.0 * this.maxValue);
    }

    public boolean isZero() {
        return this.getValue() == 0.0;
    }
}

