/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.entity.component;

import com.almasb.ents.CopyableComponent;
import com.almasb.ents.Entity;
import com.almasb.ents.component.BooleanComponent;
import com.almasb.ents.component.Required;
import com.almasb.fxgl.entity.EntityView;
import com.almasb.fxgl.entity.component.MainViewComponent;
import com.almasb.fxgl.gameplay.GameWorld;

@Required(value=MainViewComponent.class)
public class SelectableComponent
extends BooleanComponent
implements CopyableComponent<SelectableComponent> {
    public SelectableComponent(boolean value) {
        super(value);
    }

    public void onAdded(Entity entity) {
        MainViewComponent view = (MainViewComponent)this.getEntity().getComponentUnsafe(MainViewComponent.class);
        this.valueProperty().addListener((o, wasSelectable, isSelectable) -> {
            if (isSelectable.booleanValue()) {
                this.attachSelectListener(view.getView());
            } else {
                this.removeSelectListener(view.getView());
            }
        });
        if (this.getValue()) {
            this.attachSelectListener(view.getView());
        }
    }

    public void onRemoved(Entity entity) {
        MainViewComponent view = (MainViewComponent)this.getEntity().getComponentUnsafe(MainViewComponent.class);
        this.removeSelectListener(view.getView());
    }

    private void attachSelectListener(EntityView view) {
        view.setOnMousePressed(e -> ((GameWorld)this.getEntity().getWorld()).selectedEntityProperty().set((Object)this.getEntity()));
    }

    private void removeSelectListener(EntityView view) {
        view.setOnMousePressed(null);
        ((GameWorld)this.getEntity().getWorld()).getSelectedEntity().ifPresent(e -> {
            if (e == this.getEntity()) {
                ((GameWorld)this.getEntity().getWorld()).selectedEntityProperty().set(null);
            }
        });
    }

    public SelectableComponent copy() {
        return new SelectableComponent(this.getValue());
    }
}

