/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.entity.control;

import com.almasb.ents.AbstractControl;
import com.almasb.ents.Entity;
import com.almasb.ents.component.Required;
import com.almasb.ents.component.RequiredComponents;
import com.almasb.fxgl.entity.Entities;
import com.almasb.fxgl.entity.component.PositionComponent;
import com.almasb.fxgl.entity.component.RotationComponent;
import javafx.geometry.Point2D;

@RequiredComponents(value={@Required(value=PositionComponent.class), @Required(value=RotationComponent.class)})
public class ProjectileControl
extends AbstractControl {
    private Point2D velocity;
    private double speed;

    public ProjectileControl(Point2D direction, double speed) {
        this.velocity = direction.normalize().multiply(speed);
        this.speed = speed;
    }

    public Point2D getVelocity() {
        return this.velocity;
    }

    public Point2D getDirection() {
        return this.velocity.normalize();
    }

    public void setDirection(Point2D direction) {
        this.velocity = direction.normalize().multiply(this.speed);
        Entities.getRotation(this.getEntity()).rotateToVector(this.velocity);
    }

    public double getSpeed() {
        return this.speed;
    }

    public void setSpeed(double speed) {
        this.speed = speed;
        this.velocity = this.velocity.normalize().multiply(speed);
        Entities.getRotation(this.getEntity()).rotateToVector(this.velocity);
    }

    public void onAdded(Entity entity) {
        Entities.getRotation(entity).rotateToVector(this.velocity);
    }

    public void onUpdate(Entity entity, double tpf) {
        Entities.getPosition(entity).translate(this.velocity.multiply(tpf));
    }
}

