/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.gameplay;

import com.almasb.fxgl.app.FXGL;
import com.almasb.fxgl.event.AchievementProgressEvent;
import com.almasb.fxgl.logging.Logger;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;

public class Achievement {
    private static final Logger log = FXGL.getLogger("FXGL.Achievement");
    private String name;
    private String description;
    private Runnable onAchieved;
    private ReadOnlyBooleanWrapper achieved = new ReadOnlyBooleanWrapper(false);
    private ChangeListener<Boolean> listener = (observable, oldValue, newValue) -> {
        if (newValue.booleanValue()) {
            this.setAchieved();
            if (this.onAchieved != null) {
                this.onAchieved.run();
            } else {
                log.warning("onAchieved was not set. Unmanaged achievement!");
            }
        }
    };
    private ChangeListener<Boolean> progressListener;

    public Achievement(String name, String description) {
        this.name = name;
        this.description = description;
        this.achieved.addListener(this.listener);
    }

    void setOnAchieved(Runnable onAchieved) {
        this.onAchieved = onAchieved;
    }

    void setAchieved() {
        this.achieved.removeListener(this.listener);
        this.achieved.unbind();
        this.achieved.set(true);
    }

    public boolean isAchieved() {
        return this.achievedProperty().get();
    }

    public ReadOnlyBooleanProperty achievedProperty() {
        return this.achieved.getReadOnlyProperty();
    }

    public void bind(BooleanBinding binding) {
        if (!this.isAchieved()) {
            this.achieved.bind((ObservableValue)binding);
        }
    }

    public void bind(IntegerProperty property, int value) {
        if (this.isAchieved()) {
            return;
        }
        this.bind(property.greaterThanOrEqualTo(value));
        BooleanBinding bb = property.greaterThanOrEqualTo(value / 2);
        this.progressListener = (o, fired, reachedHalf) -> {
            if (reachedHalf.booleanValue() && !fired.booleanValue()) {
                FXGL.getEventBus().fireEvent(new AchievementProgressEvent(this, property.get(), value));
                bb.removeListener(this.progressListener);
            }
        };
        bb.addListener(this.progressListener);
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String toString() {
        return this.name + ":achieved(" + this.isAchieved() + ")";
    }
}

