/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.gameplay;

import com.almasb.fxgl.app.FXGL;
import com.almasb.fxgl.event.NotificationEvent;
import com.almasb.fxgl.gameplay.FXGLNotificationService$WhenMappings;
import com.almasb.fxgl.gameplay.Notification;
import com.almasb.fxgl.gameplay.NotificationService;
import com.almasb.fxgl.gameplay.NotificationView;
import com.almasb.fxgl.logging.Logger;
import com.almasb.fxgl.scene.GameScene;
import com.almasb.fxgl.ui.Position;
import com.google.inject.Inject;
import java.util.ArrayDeque;
import javafx.animation.ScaleTransition;
import javafx.animation.Transition;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.paint.Color;
import javafx.util.Duration;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u000f\b\u0003\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006H\u0016J\b\u0010\u0015\u001a\u00020\u000bH\u0016J\u0016\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u0017J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u000eH\u0002J\u0010\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\u001f\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u000eH\u0002J\u0016\u0010 \u001a\u00020\u00172\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u0017R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \u0007*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/almasb/fxgl/gameplay/FXGLNotificationService;", "Lcom/almasb/fxgl/gameplay/NotificationService;", "gameScene", "Lcom/almasb/fxgl/scene/GameScene;", "(Lcom/almasb/fxgl/scene/GameScene;)V", "backgroundColor", "Ljavafx/scene/paint/Color;", "kotlin.jvm.PlatformType", "log", "Lcom/almasb/fxgl/logging/Logger;", "position", "Lcom/almasb/fxgl/ui/Position;", "queue", "Ljava/util/ArrayDeque;", "Lcom/almasb/fxgl/gameplay/NotificationView;", "showing", "", "createNotificationView", "text", "", "getBackgroundColor", "getPosition", "heightOf", "", "fontSize", "popNotification", "", "notificationView", "pushNotification", "setBackgroundColor", "setPosition", "showNotification", "widthOf", "fxgl"})
public final class FXGLNotificationService
implements NotificationService {
    private final Logger log;
    private final ArrayDeque<NotificationView> queue;
    private Position position;
    private Color backgroundColor;
    private boolean showing;
    private final GameScene gameScene;

    @Override
    @NotNull
    public Position getPosition() {
        return this.position;
    }

    @Override
    public void setPosition(@NotNull Position position2) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)position2), (String)"position");
        this.position = position2;
    }

    @Override
    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    @Override
    public void setBackgroundColor(@NotNull Color backgroundColor) {
        Intrinsics.checkParameterIsNotNull((Object)backgroundColor, (String)"backgroundColor");
        this.backgroundColor = backgroundColor;
    }

    private final void popNotification(NotificationView notificationView) {
        boolean removed = this.gameScene.removeUINode((Node)notificationView);
        if (!removed) {
            return;
        }
        if (!this.queue.isEmpty()) {
            NotificationView notificationView2 = this.queue.poll();
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)notificationView2), (String)"queue.poll()");
            this.showNotification(notificationView2);
        } else {
            this.showing = false;
        }
    }

    @Override
    public void pushNotification(@NotNull String text) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        NotificationView notificationView = this.createNotificationView(text);
        if (this.showing) {
            this.queue.add(notificationView);
        } else {
            this.showNotification(notificationView);
        }
    }

    private final void showNotification(NotificationView notificationView) {
        this.showing = true;
        this.gameScene.addUINode((Node)notificationView);
        notificationView.show();
        FXGL.Companion.getEventBus().fireEvent(new NotificationEvent(notificationView.getNotification()));
    }

    private final NotificationView createNotificationView(String text) {
        ScaleTransition in = new ScaleTransition(Duration.seconds((double)0.3));
        in.setFromX(0.0);
        in.setFromY(0.0);
        in.setToX(1.0);
        in.setToY(1.0);
        ScaleTransition out = new ScaleTransition(Duration.seconds((double)0.3));
        out.setFromX(1.0);
        out.setFromY(1.0);
        out.setToX(0.0);
        out.setToY(0.0);
        Notification notification = new Notification(text);
        Color color = this.backgroundColor;
        Intrinsics.checkExpressionValueIsNotNull((Object)color, (String)"backgroundColor");
        NotificationView notificationView = new NotificationView(notification, color, (Transition)in, (Transition)out);
        notificationView.setScaleX(0.0);
        notificationView.setScaleY(0.0);
        double x = 0.0;
        double y = 0.0;
        switch (FXGLNotificationService$WhenMappings.$EnumSwitchMapping$0[this.position.ordinal()]) {
            case 1: {
                x = 50.0;
                y = this.gameScene.getHeight() / (double)2 - (this.heightOf(text, 12.0) + (double)10) / (double)2;
                break;
            }
            case 2: {
                x = this.gameScene.getWidth() - (this.widthOf(text, 12.0) + (double)20) - 50.0;
                y = this.gameScene.getHeight() / (double)2 - (this.heightOf(text, 12.0) + (double)10) / (double)2;
                break;
            }
            case 3: {
                x = this.gameScene.getWidth() / (double)2 - (this.widthOf(text, 12.0) + (double)20) / (double)2;
                y = 50.0;
                break;
            }
            case 4: {
                x = this.gameScene.getWidth() / (double)2 - (this.widthOf(text, 12.0) + (double)20) / (double)2;
                y = this.gameScene.getHeight() - (this.heightOf(text, 12.0) + (double)10) - 50.0;
            }
        }
        notificationView.setTranslateX(x);
        notificationView.setTranslateY(y);
        in.setNode((Node)notificationView);
        out.setNode((Node)notificationView);
        out.setOnFinished((EventHandler)new EventHandler<ActionEvent>(this, notificationView){
            final /* synthetic */ FXGLNotificationService this$0;
            final /* synthetic */ NotificationView $notificationView;

            public final void handle(ActionEvent e) {
                FXGLNotificationService.access$popNotification(this.this$0, this.$notificationView);
            }
            {
                this.this$0 = fXGLNotificationService;
                this.$notificationView = notificationView;
            }
        });
        return notificationView;
    }

    public final double widthOf(@NotNull String text, double fontSize) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        return FXGL.Companion.getUIFactory().newText(text, fontSize).getLayoutBounds().getWidth();
    }

    public final double heightOf(@NotNull String text, double fontSize) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        return FXGL.Companion.getUIFactory().newText(text, fontSize).getLayoutBounds().getHeight();
    }

    @Inject
    private FXGLNotificationService(GameScene gameScene) {
        this.gameScene = gameScene;
        this.log = FXGL.Companion.getLogger(this.getClass());
        this.queue = new ArrayDeque();
        this.position = Position.TOP;
        this.backgroundColor = Color.BLACK;
        this.log.debug(1.INSTANCE);
    }

    public static final /* synthetic */ void access$popNotification(FXGLNotificationService $this, @NotNull NotificationView notificationView) {
        $this.popNotification(notificationView);
    }
}

