/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.gameplay;

import com.almasb.ents.Entity;
import com.almasb.fxgl.entity.Entities;
import com.almasb.fxgl.entity.RenderLayer;
import com.almasb.fxgl.entity.component.BoundingBoxComponent;
import com.almasb.fxgl.entity.component.MainViewComponent;
import com.almasb.fxgl.entity.component.TypeComponent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import javafx.geometry.Rectangle2D;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u0010\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0007\u001a\u00020\u0004J\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\t\u001a\u00020\nJ-\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u001a\u0010\f\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u000e0\r\"\u0006\u0012\u0002\b\u00030\u000e\u00a2\u0006\u0002\u0010\u000fJ\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00040\u0012J\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0014\u001a\u00020\u0015J1\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0007\u001a\u00020\u00042\u001a\u0010\f\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u000e0\r\"\u0006\u0012\u0002\b\u00030\u000eH\u0002\u00a2\u0006\u0002\u0010\u0018R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/almasb/fxgl/gameplay/GameWorldQuery;", "", "entities", "", "Lcom/almasb/ents/Entity;", "(Ljava/util/List;)V", "getCollidingEntities", "entity", "getEntitiesByLayer", "layer", "Lcom/almasb/fxgl/entity/RenderLayer;", "getEntitiesByType", "types", "", "", "([Ljava/lang/Enum;)Ljava/util/List;", "getEntitiesFiltered", "predicate", "Ljava/util/function/Predicate;", "getEntitiesInRange", "selection", "Ljavafx/geometry/Rectangle2D;", "isOneOfTypes", "", "(Lcom/almasb/ents/Entity;[Ljava/lang/Enum;)Z", "fxgl"})
public final class GameWorldQuery {
    private final List<Entity> entities;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Entity> getEntitiesFiltered(@NotNull Predicate<Entity> predicate) {
        void destination$iv$iv;
        void $receiver$iv$iv;
        Intrinsics.checkParameterIsNotNull(predicate, (String)"predicate");
        Iterable $receiver$iv = this.entities;
        Iterable iterable = $receiver$iv;
        Collection collection = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            Entity it = (Entity)element$iv$iv;
            if (!predicate.test(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Entity> getEntitiesByType(Enum<?> ... types) {
        void destination$iv$iv;
        void $receiver$iv$iv;
        Intrinsics.checkParameterIsNotNull(types, (String)"types");
        Object[] objectArray = types;
        if (objectArray.length == 0) {
            return new ArrayList(this.entities);
        }
        Iterable $receiver$iv = this.entities;
        Iterable iterable = $receiver$iv;
        Collection collection = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            Entity it = (Entity)element$iv$iv;
            if (!this.isOneOfTypes(it, Arrays.copyOf(types, types.length))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isOneOfTypes(Entity entity, Enum<?> ... types) {
        TypeComponent entityType = Entities.getType(entity);
        if (entityType != null) {
            boolean bl;
            block2: {
                void $receiver$iv;
                Object[] objectArray = types;
                for (int i = 0; i < ((void)$receiver$iv).length; ++i) {
                    void element$iv = $receiver$iv[i];
                    Enum it = (Enum)element$iv;
                    if (!entityType.isType(it)) continue;
                    bl = true;
                    break block2;
                }
                bl = false;
            }
            return bl;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Entity> getEntitiesInRange(@NotNull Rectangle2D selection) {
        void destination$iv$iv;
        void $receiver$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)selection, (String)"selection");
        Iterable $receiver$iv = this.entities;
        Iterable iterable = $receiver$iv;
        Collection collection = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            Entity it = (Entity)element$iv$iv;
            BoundingBoxComponent boundingBoxComponent = (BoundingBoxComponent)it.getComponentUnsafe(BoundingBoxComponent.class);
            if (!(boundingBoxComponent != null ? boundingBoxComponent.isWithin(selection) : false)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Entity> getCollidingEntities(@NotNull Entity entity) {
        void destination$iv$iv;
        void $receiver$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)entity, (String)"entity");
        BoundingBoxComponent bbox = Entities.getBBox(entity);
        Iterable $receiver$iv = this.entities;
        Iterable iterable = $receiver$iv;
        Collection collection = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            Entity it = (Entity)element$iv$iv;
            BoundingBoxComponent boundingBoxComponent = (BoundingBoxComponent)it.getComponentUnsafe(BoundingBoxComponent.class);
            if (!((boundingBoxComponent != null ? boundingBoxComponent.isCollidingWith(bbox) : false) && it != entity)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Entity> getEntitiesByLayer(@NotNull RenderLayer layer) {
        void destination$iv$iv;
        void $receiver$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)layer, (String)"layer");
        Iterable $receiver$iv = this.entities;
        Iterable iterable = $receiver$iv;
        Collection collection = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            Entity it = (Entity)element$iv$iv;
            MainViewComponent view = (MainViewComponent)it.getComponentUnsafe(MainViewComponent.class);
            boolean bl = view != null ? view.getRenderLayer().index() == layer.index() : false;
            if (!bl) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public GameWorldQuery(@NotNull List<? extends Entity> entities) {
        Intrinsics.checkParameterIsNotNull(entities, (String)"entities");
        this.entities = entities;
    }
}

