/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.logging;

import com.almasb.fxgl.logging.Logger;
import com.almasb.fxgl.logging.SystemLogger;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.function.Supplier;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.stream.Collectors;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0010\u001a\u00020\u0011H\u0002J\b\u0010\u0012\u001a\u00020\u0011H\u0016J\u0018\u0010\u0013\u001a\u00020\u00112\u000e\u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u0015H\u0016J\u0012\u0010\u0013\u001a\u00020\u00112\b\u0010\u0016\u001a\u0004\u0018\u00010\u000fH\u0016J\u000e\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u0019J\u0018\u0010\u001a\u001a\u00020\u00112\u000e\u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u0015H\u0016J\u0012\u0010\u001a\u001a\u00020\u00112\b\u0010\u0016\u001a\u0004\u0018\u00010\u000fH\u0016J\u0010\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u0004H\u0002J\u0018\u0010\u001d\u001a\u00020\u00112\u000e\u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u0015H\u0016J\u0012\u0010\u001d\u001a\u00020\u00112\b\u0010\u0016\u001a\u0004\u0018\u00010\u000fH\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0002J\b\u0010 \u001a\u00020\u0011H\u0002J\b\u0010!\u001a\u00020\u0011H\u0002J\b\u0010\"\u001a\u00020\u0011H\u0002J\u0018\u0010#\u001a\u00020\u00112\u000e\u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u0015H\u0016J\u0012\u0010#\u001a\u00020\u00112\b\u0010\u0016\u001a\u0004\u0018\u00010\u000fH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/almasb/fxgl/logging/SystemLogger;", "Lcom/almasb/fxgl/logging/Logger;", "()V", "MAX_LOGS", "", "consoleHandler", "Ljava/util/logging/ConsoleHandler;", "fileHandler", "Ljava/util/logging/FileHandler;", "logger", "Ljava/util/logging/Logger;", "kotlin.jvm.PlatformType", "threadNames", "Ljava/util/HashMap;", "", "", "cleanOldLogs", "", "close", "debug", "messageSupplier", "Ljava/util/function/Supplier;", "message", "errorTraceAsString", "e", "", "fatal", "getThreadName", "id", "info", "initFormatter", "Ljava/util/logging/Formatter;", "initLogger", "logSystemInfo", "pollThreadNames", "warning", "fxgl"})
public final class SystemLogger
implements Logger {
    private static final int MAX_LOGS = 10;
    private static final HashMap<Long, String> threadNames;
    private static final ConsoleHandler consoleHandler;
    private static final FileHandler fileHandler;
    private static final java.util.logging.Logger logger;
    public static final SystemLogger INSTANCE;

    /*
     * WARNING - void declaration
     */
    private final void cleanOldLogs() {
        int n;
        int n2;
        List logs2;
        int logSize;
        Path logDir = Paths.get("logs/", new String[0]);
        if (!Files.exists(logDir, new LinkOption[0])) {
            Files.createDirectory(logDir, new FileAttribute[0]);
            Path readmeFile = Paths.get("logs/Readme.txt", new String[0]);
            Files.write(readmeFile, (Iterable<? extends CharSequence>)StringsKt.lines((CharSequence)"This directory contains FXGL log files."), new OpenOption[0]);
        }
        if ((logSize = (logs2 = Files.walk(logDir, 1, new FileVisitOption[0]).filter(cleanOldLogs.logs.1.INSTANCE).sorted(cleanOldLogs.logs.2.INSTANCE).collect(Collectors.toList())).size()) >= MAX_LOGS && (n2 = 0) <= (n = logSize + 1 - MAX_LOGS - 1)) {
            while (true) {
                void i;
                Files.delete((Path)logs2.get((int)i));
                if (i == n) break;
                ++i;
            }
        }
    }

    private final void initLogger() {
        Formatter formatter = this.initFormatter();
        consoleHandler.setLevel(Level.CONFIG);
        consoleHandler.setFormatter(formatter);
        fileHandler.setLevel(Level.ALL);
        fileHandler.setFormatter(formatter);
        logger.setLevel(Level.ALL);
        logger.setUseParentHandlers(false);
        logger.addHandler(consoleHandler);
        logger.addHandler(fileHandler);
        logger.info("System Logger is initialized");
    }

    private final Formatter initFormatter() {
        return new Formatter(){

            @NotNull
            public String format(@NotNull LogRecord record) {
                Intrinsics.checkParameterIsNotNull((Object)record, (String)"record");
                StringBuilder sb = new StringBuilder();
                Date date = new Date(record.getMillis());
                LocalDateTime dateTime = LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault());
                sb.append(dateTime.format(DateTimeFormatter.ofPattern("dd MMM yyyy, HH:mm:ss.SSS")));
                sb.append(" ");
                StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                String string = "[%7s]";
                Object[] objectArray = new Object[]{record.getLevel().toString()};
                StringBuilder stringBuilder = sb;
                String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(format, *args)");
                String string3 = string2;
                stringBuilder.append(string3);
                sb.append(" ");
                stringCompanionObject = StringCompanionObject.INSTANCE;
                string = "[%20s]";
                objectArray = new Object[]{record.getLoggerName()};
                stringBuilder = sb;
                String string4 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"java.lang.String.format(format, *args)");
                string3 = string4;
                stringBuilder.append(string3);
                sb.append(" ");
                stringCompanionObject = StringCompanionObject.INSTANCE;
                string = "[%15s]";
                objectArray = new Object[]{SystemLogger.access$getThreadName(SystemLogger.INSTANCE, record.getThreadID())};
                stringBuilder = sb;
                String string5 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"java.lang.String.format(format, *args)");
                string3 = string5;
                stringBuilder.append(string3);
                sb.append(" ");
                sb.append(record.getMessage());
                sb.append("\n");
                String string6 = sb.toString();
                Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"sb.toString()");
                return string6;
            }
        };
    }

    @Override
    public void info(@Nullable String message) {
        logger.info(new Supplier<String>(message){
            final /* synthetic */ String $message;

            @Nullable
            public final String get() {
                return this.$message;
            }
            {
                this.$message = string;
            }
        });
    }

    @Override
    public void info(@Nullable Supplier<String> messageSupplier) {
        Supplier<String> supplier = messageSupplier;
        logger.info(supplier != null ? supplier.get() : null);
    }

    @Override
    public void debug(@Nullable String message) {
        logger.finer(new Supplier<String>(message){
            final /* synthetic */ String $message;

            @Nullable
            public final String get() {
                return this.$message;
            }
            {
                this.$message = string;
            }
        });
    }

    @Override
    public void debug(@Nullable Supplier<String> messageSupplier) {
        Supplier<String> supplier = messageSupplier;
        logger.finer(supplier != null ? supplier.get() : null);
    }

    @Override
    public void warning(@Nullable String message) {
        logger.warning(new Supplier<String>(message){
            final /* synthetic */ String $message;

            @Nullable
            public final String get() {
                return this.$message;
            }
            {
                this.$message = string;
            }
        });
    }

    @Override
    public void warning(@Nullable Supplier<String> messageSupplier) {
        Supplier<String> supplier = messageSupplier;
        logger.warning(supplier != null ? supplier.get() : null);
    }

    @Override
    public void fatal(@Nullable String message) {
        logger.severe(new Supplier<String>(message){
            final /* synthetic */ String $message;

            @Nullable
            public final String get() {
                return this.$message;
            }
            {
                this.$message = string;
            }
        });
    }

    @Override
    public void fatal(@Nullable Supplier<String> messageSupplier) {
        Supplier<String> supplier = messageSupplier;
        logger.severe(supplier != null ? supplier.get() : null);
    }

    @Override
    public void close() {
        logger.finer("Logger is closing");
        fileHandler.close();
        consoleHandler.close();
    }

    @NotNull
    public final String errorTraceAsString(@NotNull Throwable e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        StringBuilder sb = new StringBuilder();
        sb.append("\n\nException occurred: ").append(e.getClass().getCanonicalName()).append(" : ").append(e.getMessage() + "\n");
        StackTraceElement[] elements = ExceptionsKt.getStackTrace((Throwable)e);
        for (int i = 0; i < elements.length; ++i) {
            StackTraceElement el = elements[i];
            sb.append("E: ").append(el.toString()).append('\n');
        }
        String string = sb.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sb.toString()");
        return string;
    }

    private final void logSystemInfo() {
        logger.finer("Logging System Info");
        Runtime rt = Runtime.getRuntime();
        double MB = 0x100000;
        logger.finer("CPU cores: " + rt.availableProcessors());
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        String string = "Free Memory: %.0fMB";
        Object[] objectArray = new Object[]{(double)rt.freeMemory() / MB};
        java.util.logging.Logger logger = SystemLogger.logger;
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(format, *args)");
        String string3 = string2;
        logger.finer(string3);
        stringCompanionObject = StringCompanionObject.INSTANCE;
        string = "Max Memory: %.0fMB";
        objectArray = new Object[]{(double)rt.maxMemory() / MB};
        logger = SystemLogger.logger;
        String string4 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"java.lang.String.format(format, *args)");
        string3 = string4;
        logger.finer(string3);
        stringCompanionObject = StringCompanionObject.INSTANCE;
        string = "Total Memory: %.0fMB";
        objectArray = new Object[]{(double)rt.totalMemory() / MB};
        logger = SystemLogger.logger;
        String string5 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"java.lang.String.format(format, *args)");
        string3 = string5;
        logger.finer(string3);
        SystemLogger.logger.finer("System Properties:");
        System.getProperties().forEach(logSystemInfo.1.INSTANCE);
    }

    private final void pollThreadNames() {
        Thread[] threads = new Thread[Thread.activeCount()];
        Thread.enumerate(threads);
        for (int i = 0; i < threads.length; ++i) {
            Thread t;
            Thread thread = t = threads[i];
            if (thread == null) {
                Intrinsics.throwNpe();
            }
            threadNames.put(thread.getId(), StringsKt.padStart$default((String)t.getName(), (int)25, (char)'\u0000', (int)2, null));
        }
    }

    private final String getThreadName(int id) {
        String name = threadNames.getOrDefault(id, "");
        CharSequence charSequence = name;
        if (charSequence.length() == 0) {
            this.pollThreadNames();
        }
        String string = threadNames.getOrDefault(id, "Unknown");
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"threadNames.getOrDefault(id.toLong(), \"Unknown\")");
        return string;
    }

    private SystemLogger() {
        INSTANCE = this;
        MAX_LOGS = 10;
        threadNames = new HashMap();
        consoleHandler = new ConsoleHandler();
        logger = java.util.logging.Logger.getLogger("FXGL.SystemLogger");
        this.cleanOldLogs();
        fileHandler = new FileHandler("logs/FXGL-" + LocalDateTime.now().format(DateTimeFormatter.ofPattern("dd MMM yyyy HH-mm-ss-SSS")) + ".log", 0x100000, 1);
        this.initLogger();
        this.logSystemInfo();
    }

    static {
        new SystemLogger();
    }

    @NotNull
    public static final /* synthetic */ String access$getThreadName(SystemLogger $this, int id) {
        return $this.getThreadName(id);
    }

    public static final /* synthetic */ java.util.logging.Logger access$getLogger$p(SystemLogger $this) {
        SystemLogger systemLogger = $this;
        return logger;
    }
}

