/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.net;

import com.almasb.fxgl.app.FXGL;
import com.almasb.fxgl.logging.Logger;
import com.almasb.fxgl.net.ConnectionMessage;
import com.almasb.fxgl.net.NetworkConnection;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class MultiServer
extends NetworkConnection {
    private static final Logger log = FXGL.getLogger("FXGL.MultiServer");
    private TCPConnectionThread tcpThread = new TCPConnectionThread();
    private UDPConnectionThread udpThread = new UDPConnectionThread();
    private final List<TCPThread> tcpThreads = Collections.synchronizedList(new ArrayList());
    private final List<FullInetAddress> addresses = Collections.synchronizedList(new ArrayList());
    private int tcpPort;
    private int udpPort;

    public MultiServer() {
        this(55555, 55556);
    }

    public MultiServer(int tcpPort, int udpPort) {
        this.tcpPort = tcpPort;
        this.udpPort = udpPort;
        this.tcpThread.setDaemon(true);
        this.udpThread.setDaemon(true);
    }

    public void start() {
        this.tcpThread.start();
        this.udpThread.start();
    }

    public void stop() {
        this.sendClosingMessage();
        this.tcpThread.running = false;
        try {
            this.tcpThread.server.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.tcpThreads.forEach(t -> ((TCPThread)t).running = false);
        this.udpThread.running = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void sendUDP(Serializable data) throws Exception {
        if (this.udpThread.running) {
            byte[] buf = MultiServer.toByteArray(data);
            List<FullInetAddress> list = this.addresses;
            synchronized (list) {
                for (FullInetAddress addr : this.addresses) {
                    try {
                        this.udpThread.outSocket.send(new DatagramPacket(buf, buf.length, addr.address, addr.port));
                    }
                    catch (Exception e) {
                        log.warning("Failed to send UDP message: " + e.getMessage());
                    }
                }
            }
        } else {
            throw new IllegalStateException("UDP connection not active");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void sendTCP(Serializable data) throws Exception {
        List<TCPThread> list = this.tcpThreads;
        synchronized (list) {
            this.tcpThreads.stream().filter(tcpThread -> ((TCPThread)tcpThread).running).forEach(tcpThread -> {
                try {
                    ((TCPThread)tcpThread).outputStream.writeObject(data);
                }
                catch (Exception e) {
                    log.warning("Failed to send TCP message: " + e.getMessage());
                }
            });
        }
    }

    private static class FullInetAddress {
        private InetAddress address;
        private int port;

        public FullInetAddress(InetAddress address, int port) {
            this.address = address;
            this.port = port;
        }

        public boolean equals(Object obj) {
            if (obj instanceof FullInetAddress) {
                FullInetAddress other = (FullInetAddress)obj;
                return this.address.getHostAddress().equals(other.address.getHostAddress()) && this.port == other.port;
            }
            return false;
        }
    }

    private class UDPConnectionThread
    extends Thread {
        private DatagramSocket outSocket;
        private boolean running = false;

        private UDPConnectionThread() {
        }

        @Override
        public void run() {
            try (DatagramSocket socket = new DatagramSocket(MultiServer.this.udpPort);){
                this.outSocket = socket;
                this.running = true;
                while (this.running) {
                    try {
                        byte[] buf = new byte[16384];
                        DatagramPacket datagramPacket = new DatagramPacket(buf, buf.length);
                        socket.receive(datagramPacket);
                        ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(datagramPacket.getData()));
                        Throwable throwable = null;
                        try {
                            Object data = in.readObject();
                            FullInetAddress addr = new FullInetAddress(datagramPacket.getAddress(), datagramPacket.getPort());
                            if (data == ConnectionMessage.OPEN && !MultiServer.this.addresses.contains(addr)) {
                                MultiServer.this.addresses.add(addr);
                            }
                            if (data == ConnectionMessage.CLOSE) {
                                MultiServer.this.addresses.remove(addr);
                                continue;
                            }
                            if (data == ConnectionMessage.CLOSING) {
                                byte[] sendBuf = NetworkConnection.toByteArray((Serializable)((Object)ConnectionMessage.CLOSE));
                                ((MultiServer)MultiServer.this).udpThread.outSocket.send(new DatagramPacket(sendBuf, sendBuf.length, addr.address, addr.port));
                                continue;
                            }
                            MultiServer.this.parsers.getOrDefault(data.getClass(), d -> {}).parse((Serializable)data);
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (in == null) continue;
                            if (throwable != null) {
                                try {
                                    in.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                continue;
                            }
                            in.close();
                        }
                    }
                    catch (Exception e) {
                        log.warning("Exception during UDP connection execution: " + e.getMessage());
                    }
                }
            }
            catch (Exception e) {
                log.warning("Exception during UDP connection execution: " + e.getMessage());
                this.running = false;
                return;
            }
            log.info("UDP connection closed normally");
        }
    }

    private class TCPThread
    extends Thread {
        private boolean running = false;
        private ObjectOutputStream outputStream;
        private Socket socket;

        public TCPThread(Socket socket) {
            this.socket = socket;
        }

        @Override
        public void run() {
            try (ObjectOutputStream out = new ObjectOutputStream(this.socket.getOutputStream());
                 ObjectInputStream in = new ObjectInputStream(this.socket.getInputStream());){
                this.outputStream = out;
                this.socket.setTcpNoDelay(true);
                this.running = true;
                while (this.running) {
                    Object data = in.readObject();
                    if (data == ConnectionMessage.CLOSE) {
                        this.running = false;
                        break;
                    }
                    if (data == ConnectionMessage.CLOSING) {
                        this.outputStream.writeObject((Object)ConnectionMessage.CLOSE);
                        this.running = false;
                        break;
                    }
                    MultiServer.this.parsers.getOrDefault(data.getClass(), d -> {}).parse((Serializable)data);
                }
            }
            catch (Exception e) {
                log.warning("Exception during TCP connection execution: " + e.getMessage());
                this.running = false;
                MultiServer.this.tcpThreads.remove(this);
                try {
                    this.socket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return;
            }
            MultiServer.this.tcpThreads.remove(this);
            try {
                this.socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            log.info("TCP connection closed normally");
        }
    }

    private class TCPConnectionThread
    extends Thread {
        private boolean running = true;
        private ServerSocket server;

        private TCPConnectionThread() {
        }

        @Override
        public void run() {
            try {
                this.server = new ServerSocket(MultiServer.this.tcpPort);
            }
            catch (Exception e) {
                log.warning("Exception during TCP connection creation: " + e.getMessage());
                this.running = false;
                return;
            }
            while (this.running) {
                try {
                    Socket socket = this.server.accept();
                    socket.setTcpNoDelay(true);
                    TCPThread t = new TCPThread(socket);
                    t.setDaemon(true);
                    MultiServer.this.tcpThreads.add(t);
                    t.start();
                }
                catch (Exception e) {
                    log.warning("Exception during TCP connection execution: " + e.getMessage());
                }
            }
            try {
                this.server.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            log.info("TCP connection closed normally");
        }
    }
}

