/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.net;

import com.almasb.fxgl.app.FXGL;
import com.almasb.fxgl.logging.Logger;
import com.almasb.fxgl.net.ConnectionMessage;
import com.almasb.fxgl.net.DataParser;
import com.almasb.fxgl.net.NetworkProtocol;
import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

abstract class NetworkConnection {
    private static final Logger log = FXGL.getLogger("FXGL.NetworkConnection");
    protected Map<Class<?>, DataParser<? super Serializable>> parsers = new HashMap();

    NetworkConnection() {
    }

    protected void sendClosingMessage() {
        try {
            this.send((Serializable)((Object)ConnectionMessage.CLOSING), NetworkProtocol.TCP);
        }
        catch (Exception e) {
            log.warning("TCP already disconnected or error: " + e.getMessage());
        }
        try {
            this.send((Serializable)((Object)ConnectionMessage.CLOSING), NetworkProtocol.UDP);
        }
        catch (Exception e) {
            log.warning("UDP already disconnected or error: " + e.getMessage());
        }
    }

    public <T extends Serializable> void addParser(Class<T> cl, DataParser<T> parser) {
        this.parsers.put(cl, parser);
    }

    public void send(Serializable data) throws Exception {
        this.send(data, NetworkProtocol.UDP);
    }

    public void send(Serializable data, NetworkProtocol protocol) throws Exception {
        if (protocol == NetworkProtocol.TCP) {
            this.sendTCP(data);
        } else {
            this.sendUDP(data);
        }
    }

    protected abstract void sendUDP(Serializable var1) throws Exception;

    protected abstract void sendTCP(Serializable var1) throws Exception;

    protected static byte[] toByteArray(Serializable data) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (ObjectOutputStream oo = new ObjectOutputStream(baos);){
            oo.writeObject(data);
        }
        return baos.toByteArray();
    }
}

