/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.net;

import com.almasb.fxgl.app.FXGL;
import com.almasb.fxgl.logging.Logger;
import com.almasb.fxgl.net.ConnectionMessage;
import com.almasb.fxgl.net.NetworkConnection;
import java.io.ByteArrayInputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;

public final class Server
extends NetworkConnection {
    private static final Logger log = FXGL.getLogger("FXGL.Server");
    private TCPConnectionThread tcpThread = new TCPConnectionThread();
    private UDPConnectionThread udpThread = new UDPConnectionThread();
    private InetAddress clientAddress;
    private int clientPort;
    private int tcpPort;
    private int udpPort;

    public Server() {
        this(55555, 55556);
    }

    public Server(int tcpPort, int udpPort) {
        this.tcpPort = tcpPort;
        this.udpPort = udpPort;
        this.tcpThread.setDaemon(true);
        this.udpThread.setDaemon(true);
    }

    public void start() {
        this.tcpThread.start();
        this.udpThread.start();
    }

    public void stop() {
        this.sendClosingMessage();
        this.tcpThread.running = false;
        this.udpThread.running = false;
    }

    @Override
    protected void sendUDP(Serializable data) throws Exception {
        if (!this.udpThread.running) {
            throw new IllegalStateException("UDP connection not active");
        }
        byte[] buf = Server.toByteArray(data);
        this.udpThread.outSocket.send(new DatagramPacket(buf, buf.length, this.clientAddress, this.clientPort));
    }

    @Override
    protected void sendTCP(Serializable data) throws Exception {
        if (!this.tcpThread.running) {
            throw new IllegalStateException("Client TCP is not connected");
        }
        this.tcpThread.outputStream.writeObject(data);
    }

    private class UDPConnectionThread
    extends Thread {
        private DatagramSocket outSocket;
        private boolean running = false;

        private UDPConnectionThread() {
        }

        @Override
        public void run() {
            try (DatagramSocket socket = new DatagramSocket(Server.this.udpPort);){
                this.outSocket = socket;
                this.running = true;
                while (this.running) {
                    byte[] buf = new byte[16384];
                    DatagramPacket datagramPacket = new DatagramPacket(buf, buf.length);
                    socket.receive(datagramPacket);
                    ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(datagramPacket.getData()));
                    Throwable throwable = null;
                    try {
                        Object data = in.readObject();
                        if (data == ConnectionMessage.OPEN) {
                            Server.this.clientAddress = datagramPacket.getAddress();
                            Server.this.clientPort = datagramPacket.getPort();
                        }
                        if (data == ConnectionMessage.CLOSE) {
                            this.running = false;
                            break;
                        }
                        if (data == ConnectionMessage.CLOSING) {
                            Server.this.sendUDP((Serializable)((Object)ConnectionMessage.CLOSE));
                            this.running = false;
                            break;
                        }
                        Server.this.parsers.getOrDefault(data.getClass(), d -> {}).parse((Serializable)data);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (in == null) continue;
                        if (throwable != null) {
                            try {
                                in.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        in.close();
                    }
                }
            }
            catch (Exception e) {
                log.warning("Exception during UDP connection execution: " + e.getMessage());
                this.running = false;
                return;
            }
            log.info("UDP connection closed normally");
        }
    }

    private class TCPConnectionThread
    extends Thread {
        private boolean running = false;
        private ObjectOutputStream outputStream;

        private TCPConnectionThread() {
        }

        @Override
        public void run() {
            try (ServerSocket server = new ServerSocket(Server.this.tcpPort);
                 Socket socket = server.accept();
                 ObjectOutputStream out = new ObjectOutputStream(socket.getOutputStream());
                 ObjectInputStream in = new ObjectInputStream(socket.getInputStream());){
                this.outputStream = out;
                socket.setTcpNoDelay(true);
                this.running = true;
                while (this.running) {
                    Object data = in.readObject();
                    if (data == ConnectionMessage.CLOSE) {
                        this.running = false;
                        break;
                    }
                    if (data == ConnectionMessage.CLOSING) {
                        Server.this.sendTCP((Serializable)((Object)ConnectionMessage.CLOSE));
                        this.running = false;
                        break;
                    }
                    Server.this.parsers.getOrDefault(data.getClass(), d -> {}).parse((Serializable)data);
                }
            }
            catch (Exception e) {
                log.warning("Exception during TCP connection execution: " + e.getMessage());
                this.running = false;
                return;
            }
            log.info("TCP connection closed normally");
        }
    }
}

