/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.parser;

import com.almasb.fxgl.app.FXGL;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;

public final class JavaScriptParser {
    private ScriptEngineManager manager = new ScriptEngineManager();
    private ScriptEngine engine = this.manager.getEngineByName("nashorn");
    private Invocable invocableEngine;

    public JavaScriptParser(String scriptFileName) {
        this.engine.getContext().getBindings(200).put("HOME_DIR", (Object)this.getClass().getResource("/assets/scripts/"));
        this.engine.getContext().getBindings(200).put("FXGL", (Object)FXGL.Companion);
        this.engine.getContext().getBindings(200).put("APP", (Object)FXGL.getApp());
        try {
            if (scriptFileName.endsWith(".js")) {
                this.engine.eval(FXGL.getAssetLoader().loadScript(scriptFileName));
            } else {
                this.engine.eval(scriptFileName);
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Script cannot parsed: " + e);
        }
        this.invocableEngine = (Invocable)((Object)this.engine);
    }

    public <T> T callFunction(String name, Object ... args) {
        try {
            return (T)this.invocableEngine.invokeFunction(name, args);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Function call failed: " + e);
        }
    }
}

