/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.parser;

import com.almasb.ents.Entity;
import com.almasb.fxgl.app.FXGL;
import com.almasb.fxgl.asset.AssetLoader;
import com.almasb.fxgl.gameplay.Level;
import com.almasb.fxgl.logging.Logger;
import com.almasb.fxgl.parser.EntityFactory;
import com.almasb.fxgl.parser.EntityProducer;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J(\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00072\u0018\u0010\u0016\u001a\u0014\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u0010J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aR\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR,\u0010\u000e\u001a \u0012\u0004\u0012\u00020\u0007\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/almasb/fxgl/parser/TextLevelParser;", "", "()V", "entityFactory", "Lcom/almasb/fxgl/parser/EntityFactory;", "(Lcom/almasb/fxgl/parser/EntityFactory;)V", "emptyChar", "", "getEmptyChar", "()C", "setEmptyChar", "(C)V", "getEntityFactory", "()Lcom/almasb/fxgl/parser/EntityFactory;", "producers", "Ljava/util/HashMap;", "Lkotlin/Function2;", "", "Lcom/almasb/ents/Entity;", "addEntityProducer", "", "character", "producer", "parse", "Lcom/almasb/fxgl/gameplay/Level;", "levelFileName", "", "Companion", "fxgl"})
public final class TextLevelParser {
    private final HashMap<Character, Function2<Integer, Integer, Entity>> producers;
    private char emptyChar;
    @NotNull
    private final EntityFactory entityFactory;
    private static final Logger log;
    public static final Companion Companion;

    public final char getEmptyChar() {
        return this.emptyChar;
    }

    public final void setEmptyChar(char c) {
        this.emptyChar = c;
    }

    public final void addEntityProducer(char character, @NotNull Function2<? super Integer, ? super Integer, ? extends Entity> producer) {
        Intrinsics.checkParameterIsNotNull(producer, (String)"producer");
        this.producers.put(Character.valueOf(character), producer);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Level parse(@NotNull String levelFileName) {
        Intrinsics.checkParameterIsNotNull((Object)levelFileName, (String)"levelFileName");
        AssetLoader assetLoader = FXGL.Companion.getAssetLoader();
        List<String> lines = assetLoader.loadText(levelFileName);
        ArrayList<Entity> entities = new ArrayList<Entity>();
        int maxWidth = 0;
        int n = 0;
        int n2 = ((Collection)lines).size() - 1;
        if (n <= n2) {
            while (true) {
                int n3;
                void i;
                String line;
                if ((line = lines.get((int)i)).length() > maxWidth) {
                    maxWidth = line.length();
                }
                IntRange intRange = RangesKt.until((int)0, (int)line.length());
                int n4 = intRange.getFirst();
                if (n4 <= (n3 = intRange.getLast())) {
                    while (true) {
                        void j;
                        char c;
                        Function2<Integer, Integer, Entity> producer;
                        if ((producer = this.producers.get(Character.valueOf(c = line.charAt((int)j)))) != null) {
                            Entity e = (Entity)producer.invoke((Object)((int)j), (Object)((int)i));
                            entities.add(e);
                        } else if (c != this.emptyChar) {
                            TextLevelParser.Companion.getLog().warning("No producer found for character: " + c);
                        }
                        if (j == n3) break;
                        ++j;
                    }
                }
                if (i == n2) break;
                ++i;
            }
        }
        return new Level(maxWidth, lines.size(), (List<? extends Entity>)entities);
    }

    @NotNull
    public final EntityFactory getEntityFactory() {
        return this.entityFactory;
    }

    public TextLevelParser(@NotNull EntityFactory entityFactory) {
        Intrinsics.checkParameterIsNotNull((Object)entityFactory, (String)"entityFactory");
        this.entityFactory = entityFactory;
        this.producers = new HashMap();
        this.emptyChar = (char)32;
        this.emptyChar = this.entityFactory.getEmptyChar();
        Method[] methodArray = this.entityFactory.getClass().getDeclaredMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            final Method method = methodArray[i];
            EntityProducer producer = method.getDeclaredAnnotation(EntityProducer.class);
            if (producer == null) continue;
            Map map = this.producers;
            Character c = Character.valueOf(producer.value());
            Function2<Integer, Integer, Entity> function2 = new Function2<Integer, Integer, Entity>(){

                @NotNull
                public final Entity invoke(int x, int y) {
                    Object object = method.invoke((Object)this.getEntityFactory(), x, y);
                    if (object == null) {
                        throw new TypeCastException("null cannot be cast to non-null type com.almasb.ents.Entity");
                    }
                    return (Entity)object;
                }
            };
            map.put(c, function2);
        }
    }

    public TextLevelParser() {
        this(new EntityFactory(' '){});
    }

    static {
        Companion = new Companion(null);
        log = FXGL.Companion.getLogger("FXGL.TextLevelParser");
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/almasb/fxgl/parser/TextLevelParser$Companion;", "", "()V", "log", "Lcom/almasb/fxgl/logging/Logger;", "kotlin.jvm.PlatformType", "getLog", "()Lcom/almasb/fxgl/logging/Logger;", "fxgl"})
    public static final class Companion {
        private final Logger getLog() {
            return log;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

