/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.physics;

import java.util.stream.Stream;
import javafx.geometry.Dimension2D;
import javafx.geometry.Point2D;
import org.jbox2d.collision.shapes.ShapeType;

public final class BoundingShape {
    final ShapeType type;
    final Object data;
    final Dimension2D size;

    private BoundingShape(ShapeType type, Object data, Dimension2D size) {
        this.type = type;
        this.data = data;
        this.size = size;
    }

    Dimension2D getSize() {
        return this.size;
    }

    public boolean isCircle() {
        return this.type == ShapeType.CIRCLE;
    }

    public boolean isRectangle() {
        return this.type == ShapeType.POLYGON;
    }

    public static BoundingShape circle(double radius) {
        return new BoundingShape(ShapeType.CIRCLE, new Dimension2D(radius * 2.0, radius * 2.0), new Dimension2D(radius * 2.0, radius * 2.0));
    }

    public static BoundingShape box(double width, double height) {
        return new BoundingShape(ShapeType.POLYGON, new Dimension2D(width, height), new Dimension2D(width, height));
    }

    public static BoundingShape chain(Point2D ... points) {
        if (points.length < 2) {
            throw new IllegalArgumentException("Chain shape requires at least 2 points. Given points: " + points.length);
        }
        double maxX = Stream.of(points).mapToDouble(Point2D::getX).max().getAsDouble();
        double maxY = Stream.of(points).mapToDouble(Point2D::getY).max().getAsDouble();
        return new BoundingShape(ShapeType.CHAIN, points, new Dimension2D(maxX, maxY));
    }
}

