/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.physics;

import com.almasb.fxgl.physics.BoundingShape;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.ObservableValue;
import javafx.geometry.BoundingBox;
import javafx.geometry.Bounds;
import javafx.geometry.Dimension2D;
import javafx.geometry.Point2D;
import org.jbox2d.collision.shapes.ShapeType;

public final class HitBox
implements Serializable {
    private String name;
    private BoundingShape shape;
    private Bounds bounds;
    private transient DoubleProperty minXWorld = new SimpleDoubleProperty();
    private transient DoubleProperty maxXWorld = new SimpleDoubleProperty();
    private transient DoubleProperty minYWorld = new SimpleDoubleProperty();
    private transient DoubleProperty maxYWorld = new SimpleDoubleProperty();

    public HitBox(String name, BoundingShape shape) {
        this(name, Point2D.ZERO, shape);
    }

    public HitBox(String name, Point2D localOrigin, BoundingShape shape) {
        this.name = name;
        this.shape = shape;
        this.bounds = new BoundingBox(localOrigin.getX(), localOrigin.getY(), shape.getSize().getWidth(), shape.getSize().getHeight());
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.name);
        out.writeDouble(this.bounds.getMinX());
        out.writeDouble(this.bounds.getMinY());
        out.writeDouble(this.bounds.getWidth());
        out.writeDouble(this.bounds.getHeight());
        out.writeDouble(this.shape.size.getWidth());
        out.writeDouble(this.shape.size.getHeight());
        out.writeObject(this.shape.type);
        if (this.shape.type == ShapeType.CHAIN) {
            Point2D[] points = (Point2D[])this.shape.data;
            out.writeInt(points.length);
            for (Point2D p : points) {
                out.writeDouble(p.getX());
                out.writeDouble(p.getY());
            }
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.name = (String)in.readObject();
        this.bounds = new BoundingBox(in.readDouble(), in.readDouble(), in.readDouble(), in.readDouble());
        Dimension2D size = new Dimension2D(in.readDouble(), in.readDouble());
        ShapeType type = (ShapeType)in.readObject();
        switch (type) {
            case CIRCLE: {
                this.shape = BoundingShape.circle(size.getWidth() / 2.0);
                break;
            }
            case POLYGON: {
                this.shape = BoundingShape.box(size.getWidth(), size.getHeight());
                break;
            }
            case CHAIN: {
                int length = in.readInt();
                Point2D[] points = new Point2D[length];
                for (int i = 0; i < length; ++i) {
                    points[i] = new Point2D(in.readDouble(), in.readDouble());
                }
                this.shape = BoundingShape.chain(points);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown shape type");
            }
        }
    }

    public Bounds translate(double x, double y) {
        return new BoundingBox(x + this.bounds.getMinX(), y + this.bounds.getMinY(), this.bounds.getWidth(), this.bounds.getHeight());
    }

    public Bounds translateXFlipped(double x, double y, double entityWidth) {
        return new BoundingBox(x + entityWidth - this.bounds.getMinX() - this.bounds.getWidth(), y + this.bounds.getMinY(), this.bounds.getWidth(), this.bounds.getHeight());
    }

    public Bounds getBounds() {
        return this.bounds;
    }

    public BoundingShape getShape() {
        return this.shape;
    }

    public double getMinX() {
        return this.bounds.getMinX();
    }

    public double getMinY() {
        return this.bounds.getMinY();
    }

    public double getMaxX() {
        return this.bounds.getMaxX();
    }

    public double getMaxY() {
        return this.bounds.getMaxY();
    }

    public double getWidth() {
        return this.bounds.getWidth();
    }

    public double getHeight() {
        return this.bounds.getHeight();
    }

    public String getName() {
        return this.name;
    }

    public void bindX(DoubleProperty xProperty) {
        this.minXWorld.bind((ObservableValue)xProperty.add(this.getMinX()));
        this.maxXWorld.bind((ObservableValue)this.minXWorld.add(this.getWidth()));
    }

    public void bindY(DoubleProperty yProperty) {
        this.minYWorld.bind((ObservableValue)yProperty.add(this.getMinY()));
        this.maxYWorld.bind((ObservableValue)this.minYWorld.add(this.getHeight()));
    }

    public void unbind() {
        this.minXWorld.unbind();
        this.maxXWorld.unbind();
        this.minYWorld.unbind();
        this.maxYWorld.unbind();
    }

    public double getMinXWorld() {
        return this.minXWorld.get();
    }

    public double getMaxXWorld() {
        return this.maxXWorld.get();
    }

    public double getMinYWorld() {
        return this.minYWorld.get();
    }

    public double getMaxYWorld() {
        return this.maxYWorld.get();
    }

    public Point2D centerLocal() {
        return new Point2D((this.bounds.getMinX() + this.bounds.getMaxX()) / 2.0, (this.bounds.getMinY() + this.bounds.getMaxY()) / 2.0);
    }

    public Point2D centerWorld(double x, double y) {
        return this.centerLocal().add(x, y);
    }
}

