/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.scene;

import com.almasb.fxgl.app.FXGL;
import com.almasb.fxgl.scene.Display;
import com.almasb.fxgl.scene.FXGLScene;
import com.almasb.fxgl.ui.FXGLButton;
import com.sun.javafx.scene.traversal.Algorithm;
import com.sun.javafx.scene.traversal.Direction;
import com.sun.javafx.scene.traversal.ParentTraversalEngine;
import com.sun.javafx.scene.traversal.TraversalContext;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.geometry.Point2D;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Button;
import javafx.scene.control.TextField;
import javafx.scene.effect.BoxBlur;
import javafx.scene.effect.Effect;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Text;
import jfxtras.scene.control.window.Window;

public class DialogPane
extends Pane {
    public static final Predicate<String> ALPHANUM = input -> input.matches("^[\\pL\\pN]+$");
    private Window window = new Window();
    private Display display;
    private Runnable onShown = null;
    private Runnable onClosed = null;
    private Deque<DialogData> states = new ArrayDeque<DialogData>();
    private Effect bgBlur = new BoxBlur(5.0, 5.0, 3);
    private Effect savedEffect = null;

    DialogPane(Display display) {
        this.display = display;
        display.currentSceneProperty().addListener((o, oldScene, newScene) -> {
            if (this.isShowing()) {
                this.closeInScene((FXGLScene)oldScene);
                this.openInScene((FXGLScene)newScene);
            }
        });
        double width = FXGL.getSettings().getWidth();
        double height = FXGL.getSettings().getHeight();
        this.setPrefSize(width, height);
        this.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.rgb((int)127, (int)127, (int)123, (double)0.5), null, null)}));
        this.window.setResizableWindow(false);
        this.window.setMovable(false);
        this.window.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.BLACK, null, null)}));
        this.window.layoutXProperty().bind((ObservableValue)this.window.widthProperty().divide(2).negate().add(width / 2.0));
        this.window.layoutYProperty().bind((ObservableValue)this.window.heightProperty().divide(2).negate().add(height / 2.0));
        this.getChildren().add((Object)this.window);
        this.initTraversalPolicy();
    }

    private void initTraversalPolicy() {
        this.setImpl_traversalEngine(new ParentTraversalEngine((Parent)this, new Algorithm(){

            public Node select(Node owner, Direction dir, TraversalContext context) {
                return DialogPane.this.window;
            }

            public Node selectFirst(TraversalContext context) {
                return DialogPane.this.window;
            }

            public Node selectLast(TraversalContext context) {
                return DialogPane.this.window;
            }
        }));
    }

    public boolean isShowing() {
        return this.getParent() != null;
    }

    void showMessageBox(String message) {
        this.showMessageBox(message, () -> {});
    }

    void showMessageBox(String message, Runnable callback) {
        Text text = this.createMessage(message);
        FXGLButton btnOK = new FXGLButton("OK");
        btnOK.setOnAction(e -> {
            this.close();
            callback.run();
        });
        VBox vbox = new VBox(50.0, new Node[]{text, btnOK});
        vbox.setAlignment(Pos.CENTER);
        vbox.setUserData((Object)new Point2D(Math.max(text.getLayoutBounds().getWidth(), 200.0), text.getLayoutBounds().getHeight() * 2.0 + 50.0));
        this.setContent("Message", (Node)vbox);
        this.show();
    }

    void showErrorBox(String errorMessage) {
        this.showErrorBox(new RuntimeException(errorMessage));
    }

    void showErrorBox(String errorMessage, Runnable callback) {
        this.showErrorBox(new RuntimeException(errorMessage), callback);
    }

    void showErrorBox(Throwable error) {
        this.showErrorBox(error, () -> {});
    }

    void showErrorBox(Throwable error, Runnable callback) {
        Text text = this.createMessage(error.toString());
        FXGLButton btnOK = new FXGLButton("OK");
        btnOK.setOnAction(e -> {
            this.close();
            callback.run();
        });
        FXGLButton btnLog = new FXGLButton("LOG");
        btnLog.setOnAction(e -> {
            this.close();
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            error.printStackTrace(pw);
            pw.close();
            try {
                Files.write(Paths.get("LastException.log", new String[0]), Arrays.asList(sw.toString().split("\n")), new OpenOption[0]);
                this.showMessageBox("Log has been saved as LastException.log");
            }
            catch (Exception ex) {
                this.showMessageBox("Failed to save log file");
            }
            callback.run();
        });
        HBox hbox = new HBox(new Node[]{btnOK, btnLog});
        hbox.setAlignment(Pos.CENTER);
        VBox vbox = new VBox(50.0, new Node[]{text, hbox});
        vbox.setAlignment(Pos.CENTER);
        vbox.setUserData((Object)new Point2D(Math.max(text.getLayoutBounds().getWidth(), 400.0), text.getLayoutBounds().getHeight() * 2.0 + 50.0));
        this.setContent("Error", (Node)vbox);
        this.show();
    }

    void showConfirmationBox(String message, Consumer<Boolean> resultCallback) {
        Text text = this.createMessage(message);
        FXGLButton btnYes = new FXGLButton("YES");
        btnYes.setOnAction(e -> {
            this.close();
            resultCallback.accept(true);
        });
        FXGLButton btnNo = new FXGLButton("NO");
        btnNo.setOnAction(e -> {
            this.close();
            resultCallback.accept(false);
        });
        HBox hbox = new HBox(new Node[]{btnYes, btnNo});
        hbox.setAlignment(Pos.CENTER);
        VBox vbox = new VBox(50.0, new Node[]{text, hbox});
        vbox.setAlignment(Pos.CENTER);
        vbox.setUserData((Object)new Point2D(Math.max(text.getLayoutBounds().getWidth(), 400.0), text.getLayoutBounds().getHeight() * 2.0 + 50.0));
        this.setContent("Confirmation", (Node)vbox);
        this.show();
    }

    void showInputBox(String message, Consumer<String> resultCallback) {
        this.showInputBox(message, input -> true, resultCallback);
    }

    void showInputBox(String message, Predicate<String> filter, Consumer<String> resultCallback) {
        Text text = this.createMessage(message);
        TextField field = new TextField();
        field.setMaxWidth(Math.max(text.getLayoutBounds().getWidth(), 200.0));
        field.setFont(FXGL.getUIFactory().newFont(18.0));
        FXGLButton btnOK = new FXGLButton("OK");
        field.textProperty().addListener((observable, oldValue, newInput) -> btnOK.setDisable(newInput.isEmpty() || !filter.test((String)newInput)));
        btnOK.setDisable(true);
        btnOK.setOnAction(e -> {
            this.close();
            resultCallback.accept(field.getText());
        });
        VBox vbox = new VBox(50.0, new Node[]{text, field, btnOK});
        vbox.setAlignment(Pos.CENTER);
        vbox.setUserData((Object)new Point2D(Math.max(text.getLayoutBounds().getWidth(), 200.0), text.getLayoutBounds().getHeight() * 3.0 + 100.0));
        this.setContent("Input", (Node)vbox);
        this.show();
    }

    void showInputBoxWithCancel(String message, Predicate<String> filter, Consumer<String> resultCallback) {
        Text text = this.createMessage(message);
        TextField field = new TextField();
        field.setMaxWidth(Math.max(text.getLayoutBounds().getWidth(), 200.0));
        field.setFont(FXGL.getUIFactory().newFont(18.0));
        Button btnOK = FXGL.getUIFactory().newButton("OK");
        field.textProperty().addListener((observable, oldValue, newInput) -> btnOK.setDisable(newInput.isEmpty() || !filter.test((String)newInput)));
        btnOK.setDisable(true);
        btnOK.setOnAction(e -> {
            this.close();
            resultCallback.accept(field.getText());
        });
        Button btnCancel = FXGL.getUIFactory().newButton("CANCEL");
        btnCancel.setOnAction(e -> {
            this.close();
            resultCallback.accept("");
        });
        HBox hBox = new HBox(new Node[]{btnOK, btnCancel});
        hBox.setAlignment(Pos.CENTER);
        VBox vbox = new VBox(50.0, new Node[]{text, field, hBox});
        vbox.setAlignment(Pos.CENTER);
        vbox.setUserData((Object)new Point2D(Math.max(text.getLayoutBounds().getWidth(), 200.0), text.getLayoutBounds().getHeight() * 3.0 + 100.0));
        this.setContent("Input", (Node)vbox);
        this.show();
    }

    void showBox(String message, Node content, Button ... buttons) {
        for (Button btn : buttons) {
            EventHandler handler = btn.getOnAction();
            btn.setOnAction(e -> {
                this.close();
                if (handler != null) {
                    handler.handle(e);
                }
            });
        }
        Text text = this.createMessage(message);
        HBox hbox = new HBox((Node[])buttons);
        hbox.setAlignment(Pos.CENTER);
        VBox vbox = new VBox(50.0, new Node[]{text, content, hbox});
        vbox.setAlignment(Pos.CENTER);
        vbox.setUserData((Object)new Point2D(Math.max(text.getLayoutBounds().getWidth(), 200.0), text.getLayoutBounds().getHeight() * 3.0 + 100.0 + content.getLayoutBounds().getHeight()));
        this.setContent("Dialog", (Node)vbox);
        this.show();
    }

    private Text createMessage(String message) {
        return FXGL.getUIFactory().newText(message);
    }

    private void setContent(String title, Node n) {
        if (this.isShowing()) {
            this.states.push(new DialogData(this.window.getTitle(), this.window.getContentPane()));
        }
        Point2D size = (Point2D)n.getUserData();
        Rectangle box = new Rectangle();
        box.widthProperty().bind((ObservableValue)Bindings.max((double)(size.getX() + 200.0), (ObservableNumberValue)this.window.widthProperty()));
        box.setHeight(size.getY() + 100.0);
        box.setTranslateY(3.0);
        box.setStroke((Paint)Color.AZURE);
        StackPane root = new StackPane();
        root.getChildren().setAll((Object[])new Node[]{box, n});
        this.window.setTitle(title);
        this.window.setContentPane((Pane)root);
    }

    void setOnClosed(Runnable onClosed) {
        this.onClosed = onClosed;
    }

    void setOnShown(Runnable onShown) {
        this.onShown = onShown;
    }

    void show() {
        if (!this.isShowing()) {
            this.openInScene(this.display.getCurrentScene());
            this.requestFocus();
            if (this.onShown != null) {
                this.onShown.run();
            }
        }
    }

    void close() {
        if (this.states.isEmpty()) {
            this.closeInScene(this.display.getCurrentScene());
            if (this.onClosed != null) {
                this.onClosed.run();
            }
        } else {
            DialogData data = this.states.pop();
            this.window.setTitle(data.title);
            this.window.setContentPane(data.contentPane);
        }
    }

    private void openInScene(FXGLScene scene) {
        this.savedEffect = scene.getEffect();
        scene.setEffect(this.bgBlur);
        scene.getRoot().getChildren().add((Object)this);
    }

    private void closeInScene(FXGLScene scene) {
        scene.getRoot().getChildren().remove((Object)this);
        scene.setEffect(this.savedEffect);
    }

    private static class DialogData {
        String title;
        Pane contentPane;

        DialogData(String title, Pane contentPane) {
            this.title = title;
            this.contentPane = contentPane;
        }
    }
}

