/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.scene;

import com.almasb.ents.Component;
import com.almasb.ents.ComponentListener;
import com.almasb.ents.Control;
import com.almasb.ents.ControlListener;
import com.almasb.ents.Entity;
import com.almasb.ents.EntityWorldListener;
import com.almasb.fxgl.app.FXGL;
import com.almasb.fxgl.effect.ParticleControl;
import com.almasb.fxgl.entity.EntityView;
import com.almasb.fxgl.entity.RenderLayer;
import com.almasb.fxgl.entity.component.DrawableComponent;
import com.almasb.fxgl.entity.component.MainViewComponent;
import com.almasb.fxgl.logging.Logger;
import com.almasb.fxgl.physics.PhysicsWorld;
import com.almasb.fxgl.scene.FXGLScene;
import com.almasb.fxgl.scene.Viewport;
import com.almasb.fxgl.scene.lighting.LightingSystem;
import com.almasb.fxgl.ui.UI;
import com.almasb.gameutils.collection.Array;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import java.util.ArrayList;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.geometry.Point2D;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.effect.BlendMode;
import javafx.scene.transform.Scale;

@Singleton
public final class GameScene
extends FXGLScene
implements EntityWorldListener,
ComponentListener,
ControlListener {
    private static final Logger log = FXGL.getLogger("FXGL.GameScene");
    private Group gameRoot = new Group();
    private Canvas particlesCanvas = new Canvas();
    private GraphicsContext particlesGC = this.particlesCanvas.getGraphicsContext2D();
    private Array<ParticleControl> particles = new Array(false, 16);
    private Array<Entity> drawables = new Array(false, 128);
    private Group uiRoot = new Group();
    private Viewport viewport;
    private LightingSystem lightingSystem = null;

    @Inject
    protected GameScene(@Named(value="appWidth") double width, @Named(value="appHeight") double height) {
        this.getContentRoot().getChildren().addAll((Object[])new Node[]{this.gameRoot, this.particlesCanvas, this.uiRoot});
        this.initParticlesCanvas(width, height);
        this.initViewport(width, height);
        log.debug("Game scene initialized: " + width + "x" + height);
    }

    private void initParticlesCanvas(double w, double h) {
        this.particlesCanvas.setWidth(w);
        this.particlesCanvas.setHeight(h);
        this.particlesCanvas.setMouseTransparent(true);
    }

    public Viewport getViewport() {
        return this.viewport;
    }

    private void initViewport(double w, double h) {
        this.viewport = new Viewport(w, h);
        this.gameRoot.layoutXProperty().bind((ObservableValue)this.viewport.xProperty().negate());
        this.gameRoot.layoutYProperty().bind((ObservableValue)this.viewport.yProperty().negate());
        Scale scale = new Scale();
        scale.pivotXProperty().bind((ObservableValue)this.viewport.xProperty());
        scale.pivotYProperty().bind((ObservableValue)this.viewport.yProperty());
        scale.xProperty().bind((ObservableValue)this.viewport.zoomProperty());
        scale.yProperty().bind((ObservableValue)this.viewport.zoomProperty());
        this.gameRoot.getTransforms().add((Object)scale);
    }

    public Point2D screenToGame(Point2D screenPoint) {
        return screenPoint.multiply(1.0 / FXGL.getDisplay().getScaleRatio()).add(this.viewport.getOrigin());
    }

    public Point2D gameToScreen(Point2D gamePoint) {
        return gamePoint.subtract(this.viewport.getOrigin()).multiply(FXGL.getDisplay().getScaleRatio());
    }

    public ObservableList<Node> getUINodes() {
        return this.uiRoot.getChildrenUnmodifiable();
    }

    public void addUINode(Node node) {
        log.debug("Adding UI node: " + node);
        this.uiRoot.getChildren().add((Object)node);
    }

    public void addUINodes(Node ... nodes) {
        for (Node node : nodes) {
            this.addUINode(node);
        }
    }

    public boolean removeUINode(Node n) {
        log.debug("Removing UI node: " + n);
        return this.uiRoot.getChildren().remove((Object)n);
    }

    public void removeUINodes(Node ... nodes) {
        for (Node node : nodes) {
            this.removeUINode(node);
        }
    }

    public void addUI(UI ui) {
        this.addUINode((Node)ui.getRoot());
    }

    public void removeUI(UI ui) {
        this.removeUINode((Node)ui.getRoot());
    }

    public void addGameView(EntityView view) {
        this.getRenderGroup(view.getRenderLayer()).getChildren().add((Object)view);
    }

    public void removeGameView(EntityView view) {
        this.getRenderGroup(view.getRenderLayer()).getChildren().remove((Object)view);
        view.removeFromScene();
    }

    public void setUIMouseTransparent(boolean b) {
        this.uiRoot.setMouseTransparent(b);
    }

    public GraphicsContext getGraphicsContext() {
        return this.particlesGC;
    }

    private Group getRenderGroup(RenderLayer layer) {
        Integer renderLayer = layer.index();
        Group group = this.gameRoot.getChildren().stream().filter(n -> ((Integer)n.getUserData()).intValue() == renderLayer.intValue()).findAny().map(n -> (Group)n).orElse(new Group());
        if (group.getUserData() == null) {
            log.debug("Creating render group for layer: " + layer.asString());
            group.setUserData((Object)renderLayer);
            this.gameRoot.getChildren().add((Object)group);
        }
        ArrayList tmpGroups = new ArrayList(this.gameRoot.getChildren());
        tmpGroups.sort((g1, g2) -> (Integer)g1.getUserData() - (Integer)g2.getUserData());
        this.gameRoot.getChildren().setAll(tmpGroups);
        return group;
    }

    public void onWorldUpdate(double tpf) {
        this.particlesGC.setGlobalAlpha(1.0);
        this.particlesGC.setGlobalBlendMode(BlendMode.SRC_OVER);
        this.particlesGC.clearRect(0.0, 0.0, this.getWidth(), this.getHeight());
        for (Entity e : this.drawables) {
            DrawableComponent drawable = (DrawableComponent)e.getComponentUnsafe(DrawableComponent.class);
            if (drawable == null) continue;
            drawable.draw(this.particlesGC);
        }
        for (ParticleControl particle : this.particles) {
            particle.renderParticles(this.particlesGC, this.getViewport().getOrigin());
        }
        if (this.lightingSystem != null) {
            this.lightingSystem.update();
        }
    }

    public void onWorldReset() {
        log.debug("Resetting game scene");
        this.getViewport().unbind();
        this.drawables.clear();
        this.particles.clear();
        this.gameRoot.getChildren().clear();
        this.uiRoot.getChildren().clear();
    }

    public void onEntityAdded(Entity entity) {
        log.debug("Entity added to scene");
        entity.getComponent(MainViewComponent.class).ifPresent(viewComponent -> this.onComponentAdded((Component)viewComponent));
        entity.getComponent(DrawableComponent.class).ifPresent(c -> this.drawables.add((Object)entity));
        entity.addComponentListener((ComponentListener)this);
        entity.addControlListener((ControlListener)this);
        entity.getControl(ParticleControl.class).ifPresent(arg_0 -> this.particles.add(arg_0));
        entity.getControl(PhysicsWorld.PhysicsParticleControl.class).ifPresent(arg_0 -> this.particles.add(arg_0));
        if (this.lightingSystem != null) {
            this.lightingSystem.onAddEntity(entity);
        }
    }

    public void onEntityRemoved(Entity entity) {
        log.debug("Entity removed from scene");
        entity.getComponent(MainViewComponent.class).ifPresent(viewComponent -> this.onComponentRemoved((Component)viewComponent));
        entity.getComponent(DrawableComponent.class).ifPresent(c -> this.drawables.removeValue((Object)entity, true));
        entity.removeComponentListener((ComponentListener)this);
        entity.removeControlListener((ControlListener)this);
        entity.getControl(ParticleControl.class).ifPresent(p -> this.particles.removeValue((Object)p, true));
        entity.getControl(PhysicsWorld.PhysicsParticleControl.class).ifPresent(p -> this.particles.removeValue((Object)p, true));
    }

    public void onComponentAdded(Component component) {
        if (component instanceof MainViewComponent) {
            log.debug("Added MainViewComponent");
            MainViewComponent viewComponent = (MainViewComponent)component;
            EntityView view = viewComponent.getView();
            this.addGameView(view);
            viewComponent.renderLayerProperty().addListener((o, oldLayer, newLayer) -> {
                this.getRenderGroup((RenderLayer)oldLayer).getChildren().remove((Object)view);
                this.getRenderGroup((RenderLayer)newLayer).getChildren().add((Object)view);
            });
        }
    }

    public void onComponentRemoved(Component component) {
        if (component instanceof MainViewComponent) {
            log.debug("Removed MainViewComponent");
            MainViewComponent viewComponent = (MainViewComponent)component;
            EntityView view = viewComponent.getView();
            this.removeGameView(view);
        }
    }

    public void onControlAdded(Control control) {
        if (control instanceof PhysicsWorld.PhysicsParticleControl) {
            PhysicsWorld.PhysicsParticleControl particleControl = (PhysicsWorld.PhysicsParticleControl)control;
            this.particles.add((Object)particleControl);
        }
    }

    public void onControlRemoved(Control control) {
        if (control instanceof PhysicsWorld.PhysicsParticleControl) {
            this.particles.removeValue((Object)((PhysicsWorld.PhysicsParticleControl)control), true);
        }
    }
}

