/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.scene.menu;

import com.almasb.fxgl.app.FXGL;
import com.almasb.fxgl.app.GameApplication;
import com.almasb.fxgl.event.ProfileSelectedEvent;
import com.almasb.fxgl.scene.FXGLMenu;
import com.almasb.fxgl.scene.menu.MenuType;
import com.almasb.fxgl.ui.FXGLButton;
import java.util.function.Supplier;
import javafx.animation.FadeTransition;
import javafx.event.ActionEvent;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Line;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Text;
import javafx.util.Duration;

public class FXGLDefaultMenu
extends FXGLMenu {
    public FXGLDefaultMenu(GameApplication app, MenuType type) {
        super(app, type);
        MenuBox menu = type == MenuType.MAIN_MENU ? this.createMenuBodyMainMenu() : this.createMenuBodyGameMenu();
        double menuX = 50.0;
        double menuY = app.getHeight() / 2.0 - menu.getLayoutHeight() / 2.0;
        this.menuRoot.setTranslateX(menuX);
        this.menuRoot.setTranslateY(menuY);
        this.contentRoot.setTranslateX(menuX * 2.0 + 200.0);
        this.contentRoot.setTranslateY(menuY);
        this.menuRoot.getChildren().add((Object)menu);
        this.contentRoot.getChildren().add((Object)this.EMPTY);
        this.activeProperty().addListener((observable, wasActive, isActive) -> {
            if (!isActive.booleanValue()) {
                this.switchMenuTo((Node)menu);
                this.switchMenuContentTo((Node)this.EMPTY);
            }
        });
    }

    @Override
    protected Node createBackground(double width, double height) {
        Rectangle bg = new Rectangle(width, height);
        bg.setFill((Paint)Color.rgb((int)10, (int)1, (int)1));
        return bg;
    }

    @Override
    protected Node createTitleView(String title) {
        Text text = FXGL.getUIFactory().newText(title, 50.0);
        Rectangle bg = new Rectangle(text.getLayoutBounds().getWidth() + 20.0, 60.0, null);
        bg.setStroke((Paint)Color.WHITE);
        bg.setStrokeWidth(2.0);
        StackPane titleRoot = new StackPane();
        titleRoot.getChildren().addAll((Object[])new Node[]{bg, text});
        titleRoot.setTranslateX(this.app.getWidth() / 2.0 - (text.getLayoutBounds().getWidth() + 20.0) / 2.0);
        titleRoot.setTranslateY(50.0);
        return titleRoot;
    }

    @Override
    protected Node createVersionView(String version) {
        Text view = FXGL.getUIFactory().newText(version);
        view.setTranslateY(this.app.getHeight() - 2.0);
        return view;
    }

    @Override
    protected Node createProfileView(String profileName) {
        Text view = FXGL.getUIFactory().newText(profileName);
        view.setTranslateY(this.app.getHeight() - 2.0);
        view.setTranslateX(this.app.getWidth() - view.getLayoutBounds().getWidth());
        return view;
    }

    protected MenuBox createMenuBodyMainMenu() {
        log.debug("createMenuBodyMainMenu()");
        MenuItem itemContinue2 = new MenuItem("CONTINUE");
        itemContinue2.setOnAction(e -> this.fireContinue());
        MenuItem itemNewGame2 = new MenuItem("NEW GAME");
        itemNewGame2.setOnAction(e -> this.fireNewGame());
        MenuItem itemLoad = new MenuItem("LOAD");
        itemLoad.setMenuContent(this::createContentLoad);
        MenuItem itemOptions = new MenuItem("OPTIONS");
        itemOptions.setChild(this.createOptionsMenu());
        MenuItem itemExtra = new MenuItem("EXTRA");
        itemExtra.setChild(this.createExtraMenu());
        MenuItem itemMultiplayer = new MenuItem("ONLINE");
        itemMultiplayer.setOnAction(e -> this.fireMultiplayer());
        MenuItem itemLogout = new MenuItem("LOGOUT");
        itemLogout.setOnAction(e -> this.fireLogout());
        MenuItem itemExit2 = new MenuItem("EXIT");
        itemExit2.setOnAction(e -> this.fireExit());
        this.app.getEventBus().addEventHandler(ProfileSelectedEvent.ANY, event -> itemContinue2.setDisable(!event.hasSaves()));
        return new MenuBox(200, itemContinue2, itemNewGame2, itemLoad, itemOptions, itemExtra, itemMultiplayer, itemLogout, itemExit2);
    }

    protected MenuBox createMenuBodyGameMenu() {
        log.debug("createMenuBodyGameMenu()");
        MenuItem itemResume = new MenuItem("RESUME");
        itemResume.setOnAction(e -> this.fireResume());
        MenuItem itemSave = new MenuItem("SAVE");
        itemSave.setOnAction(e -> this.fireSave());
        MenuItem itemLoad = new MenuItem("LOAD");
        itemLoad.setMenuContent(this::createContentLoad);
        MenuItem itemOptions = new MenuItem("OPTIONS");
        itemOptions.setChild(this.createOptionsMenu());
        MenuItem itemExtra = new MenuItem("EXTRA");
        itemExtra.setChild(this.createExtraMenu());
        MenuItem itemExit2 = new MenuItem("MAIN MENU");
        itemExit2.setOnAction(e -> this.fireExitToMainMenu());
        return new MenuBox(200, itemResume, itemSave, itemLoad, itemOptions, itemExtra, itemExit2);
    }

    protected MenuBox createOptionsMenu() {
        log.debug("createOptionsMenu()");
        MenuItem itemGameplay = new MenuItem("GAMEPLAY");
        itemGameplay.setMenuContent(this::createContentGameplay);
        MenuItem itemControls = new MenuItem("CONTROLS");
        itemControls.setMenuContent(this::createContentControls);
        MenuItem itemVideo = new MenuItem("VIDEO");
        itemVideo.setMenuContent(this::createContentVideo);
        MenuItem itemAudio = new MenuItem("AUDIO");
        itemAudio.setMenuContent(this::createContentAudio);
        MenuItem btnRestore = new MenuItem("RESTORE");
        btnRestore.setOnAction(e -> this.app.getDisplay().showConfirmationBox("Settings will be restored to default", yes -> {
            if (yes.booleanValue()) {
                this.listener.restoreDefaultSettings();
            }
        }));
        return new MenuBox(200, itemGameplay, itemControls, itemVideo, itemAudio, btnRestore);
    }

    protected MenuBox createExtraMenu() {
        log.debug("createExtraMenu()");
        MenuItem itemAchievements = new MenuItem("TROPHIES");
        itemAchievements.setMenuContent(this::createContentAchievements);
        MenuItem itemCredits = new MenuItem("CREDITS");
        itemCredits.setMenuContent(this::createContentCredits);
        MenuItem itemFeedback = new MenuItem("FEEDBACK");
        itemFeedback.setMenuContent(this::createContentFeedback);
        return new MenuBox(200, itemAchievements, itemCredits, itemFeedback);
    }

    @Override
    protected void switchMenuTo(Node menu) {
        Node oldMenu = (Node)this.menuRoot.getChildren().get(0);
        FadeTransition ft = new FadeTransition(Duration.seconds((double)0.33), oldMenu);
        ft.setToValue(0.0);
        ft.setOnFinished(e -> {
            menu.setOpacity(0.0);
            this.menuRoot.getChildren().set(0, (Object)menu);
            oldMenu.setOpacity(1.0);
            FadeTransition ft2 = new FadeTransition(Duration.seconds((double)0.33), menu);
            ft2.setToValue(1.0);
            ft2.play();
        });
        ft.play();
    }

    @Override
    protected void switchMenuContentTo(Node content) {
        this.contentRoot.getChildren().set(0, (Object)content);
    }

    @Override
    protected Button createActionButton(String name, Runnable action2) {
        MenuItem btn = new MenuItem(name);
        btn.addEventHandler(ActionEvent.ACTION, event -> action2.run());
        return btn;
    }

    private class MenuItem
    extends FXGLButton {
        private MenuBox parent;
        private FXGLMenu.MenuContent cachedContent;

        MenuItem(String name) {
            super(name);
            this.cachedContent = null;
        }

        public void setParent(MenuBox menu) {
            this.parent = menu;
        }

        public void setMenuContent(Supplier<FXGLMenu.MenuContent> contentSupplier) {
            this.addEventHandler(ActionEvent.ACTION, event -> {
                if (this.cachedContent == null) {
                    this.cachedContent = (FXGLMenu.MenuContent)((Object)((Object)contentSupplier.get()));
                }
                FXGLDefaultMenu.this.switchMenuContentTo((Node)this.cachedContent);
            });
        }

        public void setChild(MenuBox menu) {
            MenuItem back = new MenuItem("BACK");
            menu.getChildren().add(0, (Object)back);
            back.addEventHandler(ActionEvent.ACTION, event -> FXGLDefaultMenu.this.switchMenuTo((Node)this.parent));
            this.addEventHandler(ActionEvent.ACTION, event -> FXGLDefaultMenu.this.switchMenuTo((Node)menu));
        }
    }

    private static class MenuBox
    extends VBox {
        MenuBox(int width, MenuItem ... items) {
            this.getChildren().add((Object)this.createSeparator(width));
            for (MenuItem item : items) {
                item.setParent(this);
                this.getChildren().addAll((Object[])new Node[]{item, this.createSeparator(width)});
            }
        }

        private Line createSeparator(int width) {
            Line sep = new Line();
            sep.setEndX((double)width);
            sep.setStroke((Paint)Color.DARKGREY);
            return sep;
        }

        double getLayoutHeight() {
            return 10 * this.getChildren().size();
        }
    }
}

