/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.ui;

import com.almasb.fxgl.app.FXGL;
import java.util.concurrent.CopyOnWriteArrayList;
import javafx.beans.value.ChangeListener;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.paint.Paint;
import jfxtras.scene.control.window.CloseIcon;
import jfxtras.scene.control.window.MinimizeIcon;
import jfxtras.scene.control.window.Window;
import jfxtras.scene.control.window.WindowIcon;

public class InGameWindow
extends Window {
    private static final int SNAP_SIZE = 10;
    private static final CopyOnWriteArrayList<InGameWindow> windows = new CopyOnWriteArrayList();
    private final int appW;
    private final int appH;
    private boolean canGoOffscreen = false;
    private boolean snapToScreen = true;
    private boolean snapToWindows = true;

    public InGameWindow(String title) {
        this(title, WindowDecor.ALL);
    }

    public InGameWindow(String title, WindowDecor decor) {
        super(title);
        switch (decor) {
            case MINIMIZE: {
                this.getRightIcons().addAll((Object[])new WindowIcon[]{new MinimizeIcon((Window)this)});
                break;
            }
            case CLOSE: {
                this.getRightIcons().addAll((Object[])new WindowIcon[]{new CloseIcon((Window)this)});
                break;
            }
            case ALL: {
                this.getRightIcons().addAll((Object[])new WindowIcon[]{new MinimizeIcon((Window)this), new CloseIcon((Window)this)});
                break;
            }
        }
        this.appW = FXGL.getSettings().getWidth();
        this.appH = FXGL.getSettings().getHeight();
        this.layoutXProperty().addListener(this.makeListenerX());
        this.layoutYProperty().addListener(this.makeListenerY());
        windows.add(this);
    }

    private ChangeListener<Number> makeListenerX() {
        return (observable, oldValue, newValue) -> {
            int newX = newValue.intValue();
            int width = (int)this.getWidth();
            int newMaxX = newX + width;
            if (this.snapToWindows) {
                this.snapToWindowsX(newX);
            }
            if (this.snapToScreen) {
                if (newX > 0 && newX <= 10) {
                    this.relocateX(0.0);
                } else if (newMaxX < this.appW && newMaxX >= this.appW - 10) {
                    this.relocateX(this.appW - width);
                }
            }
            if (!this.canGoOffscreen) {
                this.keepOnScreenX(newX);
            }
        };
    }

    private ChangeListener<Number> makeListenerY() {
        return (observable, oldValue, newValue) -> {
            int newY = newValue.intValue();
            int height = (int)this.getHeight();
            int newMaxY = newY + height;
            if (this.snapToWindows) {
                this.snapToWindowsY(newY);
            }
            if (this.snapToScreen) {
                if (newY > 0 && newY <= 10) {
                    this.relocateY(0.0);
                } else if (newMaxY < this.appH && newMaxY >= this.appH - 10) {
                    this.relocateY(this.appH - (int)this.getHeight());
                }
            }
            if (!this.canGoOffscreen) {
                this.keepOnScreenY(newY);
            }
        };
    }

    private void snapToWindowsX(int newX) {
        int width = (int)this.getWidth();
        int newMaxX = newX + width;
        for (InGameWindow window : windows) {
            if (window == this) continue;
            int nodeMinX = (int)window.getLayoutX();
            int nodeMaxX = (int)(window.getLayoutX() + window.getWidth());
            if (InGameWindow.between(newX, nodeMaxX - 10, nodeMaxX + 10)) {
                this.relocateX(nodeMaxX);
                break;
            }
            if (!InGameWindow.between(newMaxX, nodeMinX - 10, nodeMinX + 10)) continue;
            this.relocateX(nodeMinX - width);
            break;
        }
    }

    private void snapToWindowsY(int newY) {
        int height = (int)this.getHeight();
        int newMaxY = newY + height;
        for (InGameWindow window : windows) {
            if (window == this) continue;
            int nodeMinY = (int)window.getLayoutY();
            int nodeMaxY = (int)(window.getLayoutY() + window.getHeight());
            if (InGameWindow.between(newY, nodeMaxY - 10, nodeMaxY + 10)) {
                this.relocateY(nodeMaxY);
                break;
            }
            if (!InGameWindow.between(newMaxY, nodeMinY - 10, nodeMinY + 10)) continue;
            this.relocateY(nodeMinY - height);
            break;
        }
    }

    private void keepOnScreenX(int newX) {
        int width = (int)this.getWidth();
        int newMaxX = newX + width;
        if (newX < 0) {
            this.relocateX(0.0);
        } else if (newMaxX > this.appW) {
            this.relocateX(this.appW - width);
        }
    }

    private void keepOnScreenY(int newY) {
        int height = (int)this.getHeight();
        int newMaxY = newY + height;
        if (newY < 0) {
            this.relocateY(0.0);
        } else if (newMaxY > this.appH) {
            this.relocateY(this.appH - height);
        }
    }

    public final void setBackgroundColor(Paint color) {
        this.setBackground(new Background(new BackgroundFill[]{new BackgroundFill(color, null, null)}));
    }

    public final void setCanGoOffscreen(boolean value) {
        this.canGoOffscreen = value;
    }

    public final boolean canGoOffscreen() {
        return this.canGoOffscreen;
    }

    public final void setSnapToScreen(boolean value) {
        this.snapToScreen = value;
    }

    public final boolean isSnapToScreen() {
        return this.snapToScreen;
    }

    public final void setSnapToWindows(boolean value) {
        this.snapToWindows = value;
    }

    public final boolean isSnapToWindows() {
        return this.snapToWindows;
    }

    public final void relocateX(double x) {
        this.setLayoutX(x - this.getLayoutBounds().getMinX());
    }

    public final void relocateY(double y) {
        this.setLayoutY(y - this.getLayoutBounds().getMinY());
    }

    public final void setPosition(double x, double y) {
        this.relocate(x, y);
    }

    private static boolean between(int value, int min, int max) {
        return value > min && value < max;
    }

    public void close() {
        super.close();
        windows.remove((Object)this);
    }

    public static enum WindowDecor {
        NONE,
        MINIMIZE,
        CLOSE,
        ALL;

    }
}

