/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.ai;

import com.almasb.fxgl.ai.AIBubble;
import com.almasb.fxgl.app.ApplicationMode;
import com.almasb.fxgl.app.FXGL;
import com.almasb.fxgl.ecs.AbstractControl;
import com.almasb.fxgl.ecs.Entity;
import com.almasb.fxgl.entity.GameEntity;
import com.badlogic.gdx.ai.btree.BehaviorTree;
import com.badlogic.gdx.ai.btree.Task;
import java.util.HashMap;
import java.util.Map;
import javafx.scene.Node;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0004\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0015\b\u0016\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005B\u000f\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB\u0007\b\u0002\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u000e\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u0007R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082.\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0018"}, d2={"Lcom/almasb/fxgl/ai/AIControl;", "Lcom/almasb/fxgl/ecs/AbstractControl;", "behaviorTree", "Lcom/badlogic/gdx/ai/btree/BehaviorTree;", "Lcom/almasb/fxgl/entity/GameEntity;", "(Lcom/badlogic/gdx/ai/btree/BehaviorTree;)V", "treeName", "", "(Ljava/lang/String;)V", "()V", "bubble", "Lcom/almasb/fxgl/ai/AIBubble;", "getBubble", "()Lcom/almasb/fxgl/ai/AIBubble;", "onAdded", "", "entity", "Lcom/almasb/fxgl/ecs/Entity;", "onUpdate", "tpf", "", "setBubbleMessage", "message", "Companion", "fxgl"})
public final class AIControl
extends AbstractControl {
    private BehaviorTree<GameEntity> behaviorTree;
    @NotNull
    private final AIBubble bubble;
    private static final HashMap<String, BehaviorTree<GameEntity>> parsedTreesCache;
    public static final Companion Companion;

    @NotNull
    public final AIBubble getBubble() {
        return this.bubble;
    }

    public final void setBubbleMessage(@NotNull String message) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        this.bubble.setMessage(message);
    }

    public void onAdded(@NotNull Entity entity) {
        Intrinsics.checkParameterIsNotNull((Object)entity, (String)"entity");
        if (entity instanceof GameEntity) {
            BehaviorTree<GameEntity> behaviorTree = this.behaviorTree;
            if (behaviorTree == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"behaviorTree");
            }
            behaviorTree.setObject((Object)entity);
            if (Intrinsics.areEqual((Object)((Object)FXGL.Companion.getSettings().getApplicationMode()), (Object)((Object)ApplicationMode.RELEASE)) ^ true) {
                ((GameEntity)entity).getViewComponent().getView().addNode((Node)this.bubble);
            }
        } else {
            throw (Throwable)new IllegalArgumentException("Entity " + entity + " is not GameEntity");
        }
    }

    public void onUpdate(@NotNull Entity entity, double tpf) {
        Intrinsics.checkParameterIsNotNull((Object)entity, (String)"entity");
        BehaviorTree<GameEntity> behaviorTree = this.behaviorTree;
        if (behaviorTree == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"behaviorTree");
        }
        behaviorTree.step();
    }

    private AIControl() {
        this.bubble = new AIBubble();
    }

    public AIControl(@NotNull BehaviorTree<GameEntity> behaviorTree) {
        Intrinsics.checkParameterIsNotNull(behaviorTree, (String)"behaviorTree");
        this();
        this.behaviorTree = behaviorTree;
    }

    public AIControl(@NotNull String treeName) {
        Intrinsics.checkParameterIsNotNull((Object)treeName, (String)"treeName");
        this();
        BehaviorTree tree = (BehaviorTree)AIControl.Companion.getParsedTreesCache().get(treeName);
        if (tree == null) {
            tree = FXGL.Companion.getAssetLoader().loadBehaviorTree(treeName);
            Map map = AIControl.Companion.getParsedTreesCache();
            BehaviorTree behaviorTree = tree;
            Intrinsics.checkExpressionValueIsNotNull(behaviorTree, (String)"tree");
            BehaviorTree behaviorTree2 = behaviorTree;
            map.put(treeName, behaviorTree2);
        }
        BehaviorTree behaviorTree = tree;
        if (behaviorTree == null) {
            Intrinsics.throwNpe();
        }
        Task task = behaviorTree.cloneTask();
        if (task == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.badlogic.gdx.ai.btree.BehaviorTree<com.almasb.fxgl.entity.GameEntity>");
        }
        this.behaviorTree = (BehaviorTree)task;
    }

    static {
        Companion = new Companion(null);
        parsedTreesCache = new HashMap();
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R&\u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lcom/almasb/fxgl/ai/AIControl$Companion;", "", "()V", "parsedTreesCache", "Ljava/util/HashMap;", "", "Lcom/badlogic/gdx/ai/btree/BehaviorTree;", "Lcom/almasb/fxgl/entity/GameEntity;", "getParsedTreesCache", "()Ljava/util/HashMap;", "fxgl"})
    public static final class Companion {
        private final HashMap<String, BehaviorTree<GameEntity>> getParsedTreesCache() {
            return parsedTreesCache;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

