/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.app;

import com.almasb.fxgl.app.ApplicationModule;
import com.almasb.fxgl.app.FXGL;
import com.almasb.fxgl.app.FXGLEvent;
import com.almasb.fxgl.app.GameApplication;
import com.almasb.fxgl.app.UpdaterTask;
import com.almasb.fxgl.gameplay.AchievementManager;
import com.almasb.fxgl.logging.Logger;
import com.almasb.fxgl.logging.SystemLogger;
import com.almasb.fxgl.scene.PreloadingScene;
import com.almasb.fxgl.service.AssetLoader;
import com.almasb.fxgl.service.AudioPlayer;
import com.almasb.fxgl.service.Display;
import com.almasb.fxgl.service.EventBus;
import com.almasb.fxgl.service.ExceptionHandler;
import com.almasb.fxgl.service.Input;
import com.almasb.fxgl.service.MasterTimer;
import com.almasb.fxgl.service.Net;
import com.almasb.fxgl.service.NotificationService;
import com.almasb.fxgl.service.QTE;
import com.almasb.fxgl.service.QuestService;
import com.almasb.fxgl.service.UIFactory;
import com.almasb.fxgl.service.listener.FXGLListener;
import com.almasb.fxgl.settings.GameSettings;
import com.almasb.fxgl.settings.ReadOnlyGameSettings;
import com.almasb.fxgl.util.Version;
import com.google.inject.Module;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.geometry.Rectangle2D;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.layout.Pane;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;

public abstract class FXGLApplication
extends Application {
    private static final Logger log = SystemLogger.INSTANCE;
    private Stage primaryStage;
    private ReadOnlyGameSettings settings;
    private List<FXGLListener> systemListeners = new ArrayList<FXGLListener>();

    void injectStage(Stage stage) {
        this.primaryStage = stage;
    }

    public Stage getPrimaryStage() {
        return this.primaryStage;
    }

    void injectSettings(ReadOnlyGameSettings settings) {
        this.settings = settings;
    }

    public final ReadOnlyGameSettings getSettings() {
        return this.settings;
    }

    public void addFXGLListener(FXGLListener listener2) {
        this.systemListeners.add(listener2);
    }

    public void removeFXGLListener(FXGLListener listener2) {
        this.systemListeners.remove(listener2);
    }

    void runTask(Class<? extends Runnable> type) {
        log.debug("Running task: " + type.getSimpleName());
        FXGL.getInstance(type).run();
    }

    public final void init() throws Exception {
        log.debug("Initializing FXGL");
    }

    public void start(Stage primaryStage) throws Exception {
        log.debug("Starting FXGL");
        this.primaryStage = primaryStage;
        this.showPreloadingStage();
        primaryStage.setScene(new Scene((Parent)new Pane()));
        new Thread(() -> {
            try {
                this.configureFXGL();
                CountDownLatch latch = new CountDownLatch(1);
                Platform.runLater(() -> {
                    this.runTask(UpdaterTask.class);
                    latch.countDown();
                });
                latch.await();
                this.configureApp();
            }
            catch (Exception e) {
                log.fatal("Exception during system configuration:");
                log.fatal(SystemLogger.INSTANCE.errorTraceAsString(e));
                log.fatal("System will now exit");
                log.close();
                System.exit(-1);
            }
            Platform.runLater(() -> ((Stage)primaryStage).show());
        }, "FXGL Launcher Thread").start();
    }

    public final void stop() {
        log.debug("Exiting FXGL");
    }

    private void showPreloadingStage() {
        Stage preloadingStage = new Stage(StageStyle.UNDECORATED);
        preloadingStage.initOwner((Window)this.primaryStage);
        preloadingStage.setScene((Scene)new PreloadingScene());
        preloadingStage.show();
        this.primaryStage.setOnShowing(e -> {
            preloadingStage.close();
            this.primaryStage.setOnShowing(null);
        });
    }

    private void configureFXGL() {
        log.debug("Configuring FXGL");
        long start2 = System.nanoTime();
        this.initSystemProperties();
        this.initUserProperties();
        this.initAppSettings();
        FXGL.configure(new ApplicationModule((GameApplication)this), new Module[0]);
        log.debug("FXGL configuration complete");
        log.infof("FXGL configuration took:  %.3f sec", (double)(System.nanoTime() - start2) / 1.0E9);
    }

    abstract void configureApp();

    protected void pause() {
        log.debug("Pausing main loop");
        this.systemListeners.forEach(FXGLListener::onPause);
        this.getEventBus().fireEvent(FXGLEvent.pause());
    }

    protected void resume() {
        log.debug("Resuming main loop");
        this.systemListeners.forEach(FXGLListener::onResume);
        this.getEventBus().fireEvent(FXGLEvent.resume());
    }

    protected void reset() {
        log.debug("Resetting FXGL application");
        this.systemListeners.forEach(FXGLListener::onReset);
        this.getEventBus().fireEvent(FXGLEvent.reset());
        System.gc();
    }

    protected void exit() {
        log.debug("Exiting Normally");
        this.systemListeners.forEach(FXGLListener::onExit);
        this.getEventBus().fireEvent(FXGLEvent.exit());
        FXGL.destroy();
        this.stop();
        log.close();
        Platform.exit();
    }

    private void initSystemProperties() {
        log.debug("Initializing system properties");
        ResourceBundle props = ResourceBundle.getBundle("com.almasb.fxgl.app.system");
        props.keySet().forEach(key -> {
            Object value = props.getObject((String)key);
            FXGL.setProperty(key, value);
            log.debug(key + " = " + value);
        });
    }

    private void initUserProperties() {
        log.debug("Initializing user properties");
        try (InputStream is = ((Object)((Object)this)).getClass().getResource("/assets/properties/system.properties").openStream();){
            PropertyResourceBundle props = new PropertyResourceBundle(is);
            props.keySet().forEach(key -> {
                Object value = props.getObject((String)key);
                FXGL.setProperty(key, value);
                log.debug(key + " = " + value);
            });
        }
        catch (NullPointerException npe) {
            log.info("User properties not found. Using system");
        }
        catch (IOException e) {
            log.warning("Loading user properties failed: " + e);
        }
    }

    private void initAppSettings() {
        log.debug("Initializing app settings");
        GameSettings localSettings = new GameSettings();
        this.initSettings(localSettings);
        this.settings = localSettings.toReadOnly();
        log.debug("Logging settings\n" + this.settings.toString());
    }

    protected abstract void initSettings(GameSettings var1);

    public final double getWidth() {
        return this.getSettings().getWidth();
    }

    public final double getHeight() {
        return this.getSettings().getHeight();
    }

    public final Rectangle2D getScreenBounds() {
        return new Rectangle2D(0.0, 0.0, this.getWidth(), this.getHeight());
    }

    public final long getTick() {
        return this.getMasterTimer().getTick();
    }

    public final long getNow() {
        return this.getMasterTimer().getNow();
    }

    public final EventBus getEventBus() {
        return FXGL.getEventBus();
    }

    public final Display getDisplay() {
        return FXGL.getDisplay();
    }

    public final Input getInput() {
        return FXGL.getInput();
    }

    public final AudioPlayer getAudioPlayer() {
        return FXGL.getAudioPlayer();
    }

    public final AssetLoader getAssetLoader() {
        return FXGL.getAssetLoader();
    }

    public final MasterTimer getMasterTimer() {
        return FXGL.getMasterTimer();
    }

    public final Executor getExecutor() {
        return FXGL.getExecutor();
    }

    public final NotificationService getNotificationService() {
        return FXGL.getNotificationService();
    }

    public final AchievementManager getAchievementManager() {
        return FXGL.getAchievementManager();
    }

    public final QTE getQTE() {
        return FXGL.getQTE();
    }

    public final Net getNet() {
        return FXGL.getNet();
    }

    public final ExceptionHandler getExceptionHandler() {
        return FXGL.getExceptionHandler();
    }

    public final UIFactory getUIFactory() {
        return FXGL.getUIFactory();
    }

    public final QuestService getQuestService() {
        return FXGL.getQuestManager();
    }

    static {
        Version.print();
    }
}

