/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.app;

import com.almasb.fxgl.annotation.AddCollisionHandler;
import com.almasb.fxgl.annotation.SetEntityFactory;
import com.almasb.fxgl.app.FXGL;
import com.almasb.fxgl.app.GameApplication;
import com.almasb.fxgl.entity.EntityFactory;
import com.almasb.fxgl.gameplay.GameState;
import com.almasb.fxgl.logging.Logger;
import com.almasb.fxgl.logging.SystemLogger;
import com.almasb.fxgl.physics.CollisionHandler;
import com.almasb.fxgl.saving.DataFile;
import io.github.lukehutch.fastclasspathscanner.FastClasspathScanner;
import io.github.lukehutch.fastclasspathscanner.matchprocessor.ClassAnnotationMatchProcessor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import javafx.concurrent.Task;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u0000 \u001a2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001aB\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\n\u0010\r\u001a\u0004\u0018\u00010\u0002H\u0014J\b\u0010\u000e\u001a\u00020\u000fH\u0014J\"\u0010\u0010\u001a\u001c\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0012\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00120\u00130\u0011H\u0002J\b\u0010\u0014\u001a\u00020\u000fH\u0014J\u0018\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001b"}, d2={"Lcom/almasb/fxgl/app/InitAppTask;", "Ljavafx/concurrent/Task;", "Ljava/lang/Void;", "app", "Lcom/almasb/fxgl/app/GameApplication;", "(Lcom/almasb/fxgl/app/GameApplication;)V", "dataFile", "Lcom/almasb/fxgl/saving/DataFile;", "(Lcom/almasb/fxgl/app/GameApplication;Lcom/almasb/fxgl/saving/DataFile;)V", "getApp", "()Lcom/almasb/fxgl/app/GameApplication;", "getDataFile", "()Lcom/almasb/fxgl/saving/DataFile;", "call", "failed", "", "scanForAnnotations", "", "Ljava/lang/Class;", "", "succeeded", "update", "message", "", "step", "", "Companion", "fxgl"})
public final class InitAppTask
extends Task<Void> {
    @NotNull
    private final GameApplication app;
    @NotNull
    private final DataFile dataFile;
    private static final Logger log;
    public static final Companion Companion;

    /*
     * WARNING - void declaration
     */
    @Nullable
    protected Void call() {
        Iterable iterable;
        List<Class<?>> it;
        List<Class<?>> list;
        long start2 = System.nanoTime();
        this.update("Initializing Assets", 0);
        this.app.initAssets();
        this.update("Initializing Game", 1);
        if (this.app.gameState != null) {
            InitAppTask.Companion.getLog().debug("Clearing previous gameState");
            this.app.gameState.clear();
        }
        InitAppTask.Companion.getLog().debug("Injecting gameState");
        this.app.gameState = new GameState();
        HashMap vars = MapsKt.hashMapOf((Pair[])new Pair[0]);
        this.app.initGameVars(vars);
        vars.forEach((BiConsumer)new BiConsumer<String, Object>(this){
            final /* synthetic */ InitAppTask this$0;

            public final void accept(String name, Object value) {
                GameState gameState = this.this$0.getApp().gameState;
                String string = name;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"name");
                Object object = value;
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"value");
                gameState.put(string, object);
            }
            {
                this.this$0 = initAppTask;
            }
        });
        Map<Class<?>, List<Class<?>>> annotationMap = this.scanForAnnotations();
        List<Class<?>> list2 = annotationMap.get(SetEntityFactory.class);
        if (list2 != null) {
            list = list2;
            it = list;
            iterable = it;
            if (!iterable.isEmpty()) {
                Object obj = FXGL.Companion.getInstance(it.get(0));
                if (obj == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.almasb.fxgl.entity.EntityFactory");
                }
                this.app.gameWorld.setEntityFactory((EntityFactory)obj);
            }
        }
        if (this.dataFile == DataFile.Companion.getEMPTY()) {
            this.app.initGame();
        } else {
            this.app.loadState(this.dataFile);
        }
        this.update("Initializing Physics", 2);
        this.app.initPhysics();
        List<Class<?>> list3 = annotationMap.get(AddCollisionHandler.class);
        if (list3 != null) {
            void $receiver$iv;
            list = list3;
            it = list;
            iterable = it;
            for (Object element$iv : $receiver$iv) {
                Class it2 = (Class)element$iv;
                Object t = FXGL.Companion.getInstance(it2);
                if (t == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.almasb.fxgl.physics.CollisionHandler");
                }
                this.app.physicsWorld.addCollisionHandler((CollisionHandler)t);
            }
        }
        this.update("Initializing UI", 3);
        this.app.initUI();
        this.update("Initialization Complete", 4);
        SystemLogger.INSTANCE.infof("Game initialization took: %.3f sec", (double)(System.nanoTime() - start2) / 1.0E9);
        return null;
    }

    private final void update(String message, int step) {
        InitAppTask.Companion.getLog().debug(message);
        this.updateMessage(message);
        this.updateProgress(step, 4L);
    }

    protected void succeeded() {
        this.app.resume();
    }

    protected void failed() {
        Thread.UncaughtExceptionHandler uncaughtExceptionHandler = Thread.getDefaultUncaughtExceptionHandler();
        Thread thread = Thread.currentThread();
        Throwable throwable = this.getException();
        if (throwable == null) {
            throwable = new RuntimeException("Initialization failed");
        }
        uncaughtExceptionHandler.uncaughtException(thread, throwable);
    }

    private final Map<Class<?>, List<Class<?>>> scanForAnnotations() {
        HashMap map = MapsKt.hashMapOf((Pair[])new Pair[0]);
        FastClasspathScanner scanner = new FastClasspathScanner(new String[]{((Object)((Object)this.app)).getClass().getPackage().getName()});
        Map map2 = map;
        Class clazz = SetEntityFactory.class;
        ArrayList arrayList = CollectionsKt.arrayListOf((Object[])new Class[0]);
        map2.put(clazz, arrayList);
        scanner.matchClassesWithAnnotation(SetEntityFactory.class, new ClassAnnotationMatchProcessor(map){
            final /* synthetic */ HashMap $map;

            public final void processMatch(Class<?> it) {
                com.almasb.fxgl.app.InitAppTask$Companion.access$getLog$p(InitAppTask.Companion).debug("@SetEntityFactory: " + it);
                V v = this.$map.get(SetEntityFactory.class);
                if (v == null) {
                    Intrinsics.throwNpe();
                }
                ((ArrayList)v).add(it);
            }
            {
                this.$map = hashMap;
            }
        });
        map2 = map;
        clazz = AddCollisionHandler.class;
        arrayList = CollectionsKt.arrayListOf((Object[])new Class[0]);
        map2.put(clazz, arrayList);
        scanner.matchClassesWithAnnotation(AddCollisionHandler.class, new ClassAnnotationMatchProcessor(map){
            final /* synthetic */ HashMap $map;

            public final void processMatch(Class<?> it) {
                com.almasb.fxgl.app.InitAppTask$Companion.access$getLog$p(InitAppTask.Companion).debug("@AddCollisionHandler: " + it);
                V v = this.$map.get(AddCollisionHandler.class);
                if (v == null) {
                    Intrinsics.throwNpe();
                }
                ((ArrayList)v).add(it);
            }
            {
                this.$map = hashMap;
            }
        });
        scanner.scan();
        return map;
    }

    @NotNull
    public final GameApplication getApp() {
        return this.app;
    }

    @NotNull
    public final DataFile getDataFile() {
        return this.dataFile;
    }

    public InitAppTask(@NotNull GameApplication app, @NotNull DataFile dataFile) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)app), (String)"app");
        Intrinsics.checkParameterIsNotNull((Object)dataFile, (String)"dataFile");
        this.app = app;
        this.dataFile = dataFile;
    }

    public InitAppTask(@NotNull GameApplication app) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)app), (String)"app");
        this(app, DataFile.Companion.getEMPTY());
    }

    static {
        Companion = new Companion(null);
        log = FXGL.Companion.getLogger(InitAppTask.class);
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/almasb/fxgl/app/InitAppTask$Companion;", "", "()V", "log", "Lcom/almasb/fxgl/logging/Logger;", "kotlin.jvm.PlatformType", "getLog", "()Lcom/almasb/fxgl/logging/Logger;", "fxgl"})
    public static final class Companion {
        private final Logger getLog() {
            return log;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

