/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.app;

import com.almasb.fxgl.app.FXGL;
import com.almasb.fxgl.app.GameApplication;
import com.almasb.fxgl.app.MenuEventHandler;
import com.almasb.fxgl.logging.Logger;
import com.almasb.fxgl.scene.FXGLMenu;
import com.almasb.fxgl.scene.GameScene;
import com.almasb.fxgl.scene.IntroScene;
import com.almasb.fxgl.scene.LoadingScene;
import com.almasb.fxgl.scene.SceneFactory;
import com.almasb.fxgl.scene.menu.MenuEventListener;
import com.google.inject.Inject;
import javafx.event.EventHandler;
import javafx.scene.input.KeyEvent;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/almasb/fxgl/app/InitScenesTask;", "Ljava/lang/Runnable;", "app", "Lcom/almasb/fxgl/app/GameApplication;", "(Lcom/almasb/fxgl/app/GameApplication;)V", "log", "Lcom/almasb/fxgl/logging/Logger;", "kotlin.jvm.PlatformType", "run", "", "fxgl"})
public final class InitScenesTask
implements Runnable {
    private final Logger log;
    private final GameApplication app;

    @Override
    public void run() {
        SceneFactory sceneFactory = this.app.initSceneFactory();
        GameScene gameScene = sceneFactory.newGameScene();
        LoadingScene loadingScene = sceneFactory.newLoadingScene();
        if (this.app.getSettings().isIntroEnabled()) {
            IntroScene introScene = sceneFactory.newIntro();
            this.app.getDisplay().registerScene(introScene);
            this.log.debug("Injecting introScene");
            this.app.introScene = introScene;
        }
        if (this.app.getSettings().isMenuEnabled()) {
            MenuEventListener menuHandler = this.app.getMenuListener();
            FXGLMenu mainMenuScene = sceneFactory.newMainMenu(this.app);
            FXGLMenu gameMenuScene = sceneFactory.newGameMenu(this.app);
            MenuEventListener menuEventListener = menuHandler;
            if (menuEventListener == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.almasb.fxgl.app.MenuEventHandler");
            }
            gameScene.addEventHandler(KeyEvent.ANY, (MenuEventHandler)menuEventListener);
            gameMenuScene.addEventHandler(KeyEvent.ANY, (EventHandler)menuHandler);
            this.app.getDisplay().registerScene(mainMenuScene);
            this.app.getDisplay().registerScene(gameMenuScene);
            this.log.debug("Injecting mainMenuScene & gameMenuScene");
            this.app.mainMenuScene = mainMenuScene;
            this.app.gameMenuScene = gameMenuScene;
        }
        this.app.getDisplay().registerScene(loadingScene);
        this.app.getDisplay().registerScene(gameScene);
        this.log.debug("Injecting loadingScene & gameScene");
        this.app.loadingScene = loadingScene;
        this.app.gameScene = gameScene;
    }

    @Inject
    public InitScenesTask(@NotNull GameApplication app) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)app), (String)"app");
        this.app = app;
        this.log = FXGL.Companion.getLogger(this.getClass());
    }
}

