/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.app;

import com.almasb.fxgl.app.ApplicationMode;
import com.almasb.fxgl.app.FXGL;
import com.almasb.fxgl.app.UpdaterTask$checkForUpdates$;
import com.almasb.fxgl.io.IOTask;
import com.almasb.fxgl.logging.Logger;
import com.almasb.fxgl.time.LocalTimer;
import com.almasb.fxgl.util.Version;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.util.Duration;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\b\u001a\u00020\tH\u0002J\b\u0010\n\u001a\u00020\tH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/almasb/fxgl/app/UpdaterTask;", "Ljava/lang/Runnable;", "()V", "log", "Lcom/almasb/fxgl/logging/Logger;", "kotlin.jvm.PlatformType", "updateCheckTimer", "Lcom/almasb/fxgl/time/LocalTimer;", "checkForUpdates", "", "run", "shouldCheckForUpdate", "", "fxgl"})
public final class UpdaterTask
implements Runnable {
    private final Logger log = FXGL.Companion.getLogger(this.getClass());
    private LocalTimer updateCheckTimer;

    @Override
    public void run() {
        if (this.shouldCheckForUpdate()) {
            this.checkForUpdates();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean shouldCheckForUpdate() {
        if (FXGL.Companion.getSettings().getApplicationMode() == ApplicationMode.RELEASE) {
            return false;
        }
        this.updateCheckTimer = FXGL.Companion.newOfflineTimer("version.check");
        Duration days = Duration.hours((double)(24.0 * (double)FXGL.Companion.getInt("version.check.days")));
        if (FXGL.Companion.isFirstRun()) return true;
        LocalTimer localTimer = this.updateCheckTimer;
        if (localTimer == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"updateCheckTimer");
        }
        if (!localTimer.elapsed(days)) return false;
        return true;
    }

    private final void checkForUpdates() {
        this.log.debug("Checking for updates");
        Dialog dialog = new Dialog();
        Dialog $receiver = dialog;
        $receiver.setTitle("FXGL Update");
        $receiver.getDialogPane().setContentText("Checking for updates...\n \n ");
        $receiver.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.OK, ButtonType.CANCEL});
        Node node = dialog.getDialogPane().lookupButton(ButtonType.OK);
        if (node == null) {
            throw new TypeCastException("null cannot be cast to non-null type javafx.scene.control.Button");
        }
        Button button = (Button)node;
        Button $receiver2 = button;
        $receiver2.setDisable(true);
        $receiver2.setText("Open GitHub");
        $receiver2.setOnAction((EventHandler)new EventHandler<ActionEvent>(this){
            final /* synthetic */ UpdaterTask this$0;

            public final void handle(ActionEvent e) {
                FXGL.Companion.getNet().openBrowserTask(FXGL.Companion.getString("url.github")).onFailure((Consumer)new Consumer<Throwable>(this){
                    final /* synthetic */ checkForUpdates$$inlined$with$lambda$1 this$0;

                    public final void accept(Throwable error) {
                        UpdaterTask.access$getLog$p(this.this$0.this$0).warning("Error opening browser: " + error);
                    }
                    {
                        this.this$0 = var1_1;
                    }
                }).execute();
            }
            {
                this.this$0 = updaterTask;
            }
        });
        IOTask iOTask = FXGL.Companion.getNet().getLatestVersionTask().onSuccess((Consumer)new Consumer<String>(this, dialog, button){
            final /* synthetic */ UpdaterTask this$0;
            final /* synthetic */ Dialog $dialog;
            final /* synthetic */ Button $button;

            public final void accept(String version) {
                UpdaterTask.access$getUpdateCheckTimer$p(this.this$0).capture();
                this.$dialog.getDialogPane().setContentText("Just so you know\nYour version:   " + Version.getAsString() + "\n" + "Latest version: " + version);
                this.$button.setDisable(false);
            }
            {
                this.this$0 = updaterTask;
                this.$dialog = dialog;
                this.$button = button;
            }
        }).onFailure((Consumer)new Consumer<Throwable>(this, dialog, button){
            final /* synthetic */ UpdaterTask this$0;
            final /* synthetic */ Dialog $dialog;
            final /* synthetic */ Button $button;

            public final void accept(Throwable error) {
                UpdaterTask.access$getLog$p(this.this$0).warning("Failed to find updates: " + error);
                this.$dialog.getDialogPane().setContentText("Failed to find updates: " + error);
                this.$button.setDisable(false);
            }
            {
                this.this$0 = updaterTask;
                this.$dialog = dialog;
                this.$button = button;
            }
        });
        Executor executor = FXGL.Companion.getExecutor();
        Intrinsics.checkExpressionValueIsNotNull((Object)executor, (String)"FXGL.getExecutor()");
        IOTask.executeAsyncWithDialogFX$default((IOTask)iOTask, (Executor)executor, null, (int)2, null);
        dialog.showAndWait();
    }

    public static final /* synthetic */ Logger access$getLog$p(UpdaterTask $this) {
        return $this.log;
    }

    @NotNull
    public static final /* synthetic */ LocalTimer access$getUpdateCheckTimer$p(UpdaterTask $this) {
        LocalTimer localTimer = $this.updateCheckTimer;
        if (localTimer == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"updateCheckTimer");
        }
        return localTimer;
    }

    public static final /* synthetic */ void access$setUpdateCheckTimer$p(UpdaterTask $this, @NotNull LocalTimer localTimer) {
        $this.updateCheckTimer = localTimer;
    }
}

