/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.devtools.profiling;

import com.almasb.fxgl.app.FXGL;
import com.almasb.fxgl.core.math.FXGLMath;
import com.almasb.fxgl.logging.SystemLogger;
import com.almasb.fxgl.service.MasterTimer;
import com.almasb.fxgl.time.UpdateEvent;
import com.almasb.fxgl.time.UpdateEventListener;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.LongCompanionObject;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 ,2\u00020\u0001:\u0001,B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0015\u001a\u00020\u0004J\u0006\u0010\u0016\u001a\u00020\u0006J\u0006\u0010\u0017\u001a\u00020\u0018J\u0006\u0010\u0019\u001a\u00020\u0006J\u0006\u0010\u001a\u001a\u00020\u0004J\u0006\u0010\u001b\u001a\u00020\u0006J\u0006\u0010\u001c\u001a\u00020\u0018J\u0006\u0010\u001d\u001a\u00020\u0006J\u0006\u0010\u001e\u001a\u00020\u001fJ\u0006\u0010 \u001a\u00020\u0018J\u0006\u0010!\u001a\u00020\u0006J\u0006\u0010\"\u001a\u00020\u0018J\u0006\u0010#\u001a\u00020\u0006J\u0010\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0016J\u0006\u0010(\u001a\u00020%J\u0006\u0010)\u001a\u00020%J\u0006\u0010*\u001a\u00020%J\u0006\u0010+\u001a\u00020%R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcom/almasb/fxgl/devtools/profiling/Profiler;", "Lcom/almasb/fxgl/time/UpdateEventListener;", "()V", "fps", "", "<set-?>", "", "frames", "getFrames", "()I", "setFrames", "(I)V", "gcRuns", "memoryUsage", "", "memoryUsageCurrent", "memoryUsageMax", "memoryUsageMin", "performance", "sb", "Ljava/lang/StringBuilder;", "getAvgFPS", "getAvgFPSRounded", "getAvgMemoryUsage", "", "getAvgMemoryUsageRounded", "getAvgPerformance", "getAvgPerformanceRounded", "getCurrentMemoryUsage", "getCurrentMemoryUsageRounded", "getInfo", "", "getMaxMemoryUsage", "getMaxMemoryUsageRounded", "getMinMemoryUsage", "getMinMemoryUsageRounded", "onUpdateEvent", "", "event", "Lcom/almasb/fxgl/time/UpdateEvent;", "print", "reset", "start", "stop", "Companion", "fxgl"})
public final class Profiler
implements UpdateEventListener {
    private int frames = 1;
    private double fps;
    private double performance;
    private long memoryUsage;
    private long memoryUsageMin = LongCompanionObject.MAX_VALUE;
    private long memoryUsageMax;
    private long memoryUsageCurrent;
    private int gcRuns;
    private final StringBuilder sb = new StringBuilder(128);
    private static final MasterTimer masterTimer;
    private static final Runtime runtime;
    private static final float MB = 1048576.0f;
    public static final Companion Companion;

    public final int getFrames() {
        return this.frames;
    }

    private final void setFrames(int n) {
        this.frames = n;
    }

    public final double getAvgFPS() {
        return this.fps / (double)this.frames;
    }

    public final int getAvgFPSRounded() {
        return (int)this.getAvgFPS();
    }

    public final double getAvgPerformance() {
        return this.performance / (double)this.frames;
    }

    public final int getAvgPerformanceRounded() {
        return (int)this.getAvgPerformance();
    }

    public final float getAvgMemoryUsage() {
        return (float)(this.memoryUsage / (long)this.frames) / Profiler.Companion.getMB();
    }

    public final int getAvgMemoryUsageRounded() {
        return FXGLMath.roundPositive((float)this.getAvgMemoryUsage());
    }

    public final float getMaxMemoryUsage() {
        return (float)this.memoryUsageMax / Profiler.Companion.getMB();
    }

    public final int getMaxMemoryUsageRounded() {
        return FXGLMath.roundPositive((float)this.getMaxMemoryUsage());
    }

    public final float getMinMemoryUsage() {
        return (float)this.memoryUsageMin / Profiler.Companion.getMB();
    }

    public final int getMinMemoryUsageRounded() {
        return FXGLMath.roundPositive((float)this.getMinMemoryUsage());
    }

    public final float getCurrentMemoryUsage() {
        return (float)this.memoryUsageCurrent / Profiler.Companion.getMB();
    }

    public final int getCurrentMemoryUsageRounded() {
        return FXGLMath.roundPositive((float)this.getCurrentMemoryUsage());
    }

    @Override
    public void onUpdateEvent(@NotNull UpdateEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)event), (String)"event");
        int n = this.frames;
        this.frames = n + 1;
        this.fps += (double)Profiler.Companion.getMasterTimer().getFPS();
        this.performance += (double)Profiler.Companion.getMasterTimer().getPerformanceFPS();
        long used = Profiler.Companion.getRuntime().totalMemory() - Profiler.Companion.getRuntime().freeMemory();
        if (used < this.memoryUsageCurrent) {
            int n2 = this.gcRuns;
            this.gcRuns = n2 + 1;
        }
        this.memoryUsageCurrent = used;
        this.memoryUsage += this.memoryUsageCurrent;
        if (this.memoryUsageCurrent > this.memoryUsageMax) {
            this.memoryUsageMax = this.memoryUsageCurrent;
        }
        if (this.memoryUsageCurrent < this.memoryUsageMin) {
            this.memoryUsageMin = this.memoryUsageCurrent;
        }
    }

    public final void start() {
        Profiler.Companion.getMasterTimer().addUpdateListener(this);
    }

    public final void stop() {
        Profiler.Companion.getMasterTimer().removeUpdateListener(this);
    }

    public final void reset() {
        this.frames = 1;
        this.fps = 0.0;
        this.performance = 0.0;
        this.memoryUsage = 0L;
        this.memoryUsageMin = LongCompanionObject.MAX_VALUE;
        this.memoryUsageMax = 0L;
        this.memoryUsageCurrent = 0L;
        this.gcRuns = 0;
    }

    public final void print() {
        SystemLogger.INSTANCE.info("Processed Frames: " + this.frames);
        SystemLogger.INSTANCE.info("Average FPS: " + this.getAvgFPSRounded());
        SystemLogger.INSTANCE.info("Avg Performance: " + this.getAvgPerformanceRounded());
        SystemLogger.INSTANCE.info("Avg Memory Usage: " + this.getAvgMemoryUsageRounded() + " MB");
        SystemLogger.INSTANCE.info("Min Memory Usage: " + this.getMinMemoryUsageRounded() + " MB");
        SystemLogger.INSTANCE.info("Max Memory Usage: " + this.getMaxMemoryUsageRounded() + " MB");
        SystemLogger.INSTANCE.info("Estimated GC runs: " + this.gcRuns);
    }

    @NotNull
    public final String getInfo() {
        this.sb.setLength(0);
        this.sb.append("FPS: ").append(Profiler.Companion.getMasterTimer().getFPS()).append("\nPerformance: ").append(Profiler.Companion.getMasterTimer().getPerformanceFPS()).append("\nNow Mem (MB): ").append(this.getCurrentMemoryUsageRounded()).append("\nAvg Mem (MB): ").append(this.getAvgMemoryUsageRounded()).append("\nMin Mem (MB): ").append(this.getMinMemoryUsageRounded()).append("\nMax Mem (MB): ").append(this.getMaxMemoryUsageRounded());
        String string = this.sb.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sb.toString()");
        return string;
    }

    static {
        Companion = new Companion(null);
        MB = 1048576.0f;
        MasterTimer masterTimer = FXGL.Companion.getMasterTimer();
        Intrinsics.checkExpressionValueIsNotNull((Object)masterTimer, (String)"FXGL.getMasterTimer()");
        Profiler.masterTimer = masterTimer;
        Runtime runtime = Runtime.getRuntime();
        Intrinsics.checkExpressionValueIsNotNull((Object)runtime, (String)"Runtime.getRuntime()");
        Profiler.runtime = runtime;
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lcom/almasb/fxgl/devtools/profiling/Profiler$Companion;", "", "()V", "MB", "", "getMB", "()F", "masterTimer", "Lcom/almasb/fxgl/service/MasterTimer;", "getMasterTimer", "()Lcom/almasb/fxgl/service/MasterTimer;", "runtime", "Ljava/lang/Runtime;", "getRuntime", "()Ljava/lang/Runtime;", "fxgl"})
    public static final class Companion {
        private final MasterTimer getMasterTimer() {
            return masterTimer;
        }

        private final Runtime getRuntime() {
            return runtime;
        }

        private final float getMB() {
            return MB;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

