/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.effect;

import com.almasb.fxgl.core.pool.Poolable;
import java.util.function.Consumer;
import javafx.geometry.Point2D;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.effect.BlendMode;
import javafx.scene.image.Image;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.util.Duration;

public class Particle
implements Poolable {
    private double x;
    private double y;
    private double velX;
    private double velY;
    private Point2D gravity;
    private double radiusX;
    private double radiusY;
    private Point2D scale;
    private double life;
    private Paint color;
    private BlendMode blendMode;
    private Image image = null;
    private Consumer<Particle> control = null;

    public Particle(Point2D position2, Point2D vel, Point2D gravity, double radius, Point2D scale, Duration expireTime, Paint color, BlendMode blendMode) {
        this(null, position2, vel, gravity, radius, scale, expireTime, color, blendMode);
    }

    public Particle(Image image, Point2D position2, Point2D vel, Point2D gravity, double radius, Point2D scale, Duration expireTime, Paint color, BlendMode blendMode) {
        this.init(image, position2, vel, gravity, radius, scale, expireTime, color, blendMode);
    }

    public Particle() {
        this.reset();
    }

    public final void init(Image image, Point2D position2, Point2D vel, Point2D gravity, double radius, Point2D scale, Duration expireTime, Paint color, BlendMode blendMode) {
        this.image = image;
        this.x = position2.getX();
        this.y = position2.getY();
        this.radiusX = radius;
        this.radiusY = radius;
        this.scale = scale;
        this.velX = vel.getX();
        this.velY = vel.getY();
        this.gravity = gravity;
        this.color = color;
        this.blendMode = blendMode;
        this.life = expireTime.toSeconds();
    }

    public void reset() {
        this.image = null;
        this.x = 0.0;
        this.y = 0.0;
        this.radiusX = 0.0;
        this.radiusY = 0.0;
        this.scale = Point2D.ZERO;
        this.velX = 0.0;
        this.velY = 0.0;
        this.gravity = Point2D.ZERO;
        this.color = Color.BLACK;
        this.blendMode = BlendMode.SRC_OVER;
        this.life = 0.0;
        this.control = null;
    }

    public void setControl(Consumer<Particle> control) {
        this.control = control;
    }

    boolean update(double tpf) {
        this.x += this.velX;
        this.y += this.velY;
        this.velX += this.gravity.getX();
        this.velY += this.gravity.getY();
        this.radiusX += this.scale.getX();
        this.radiusY += this.scale.getY();
        this.life -= tpf;
        if (this.control != null) {
            this.control.accept(this);
        }
        return this.life <= 0.0 || this.radiusX <= 0.0 || this.radiusY <= 0.0;
    }

    void render(GraphicsContext g, Point2D viewportOrigin) {
        g.setGlobalAlpha(this.life);
        g.setGlobalBlendMode(this.blendMode);
        if (this.image != null) {
            g.save();
            g.translate(this.x - viewportOrigin.getX(), this.y - viewportOrigin.getY());
            g.scale(this.radiusX * 2.0 / this.image.getWidth(), this.radiusY * 2.0 / this.image.getHeight());
            g.drawImage(this.image, 0.0, 0.0);
            g.restore();
        } else {
            g.setFill(this.color);
            g.fillOval(this.x - viewportOrigin.getX(), this.y - viewportOrigin.getY(), this.radiusX * 2.0, this.radiusY * 2.0);
        }
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getVelX() {
        return this.velX;
    }

    public void setVelX(double velX) {
        this.velX = velX;
    }

    public double getVelY() {
        return this.velY;
    }

    public void setVelY(double velY) {
        this.velY = velY;
    }

    public Point2D getGravity() {
        return this.gravity;
    }

    public void setGravity(Point2D gravity) {
        this.gravity = gravity;
    }

    public double getRadiusX() {
        return this.radiusX;
    }

    public void setRadiusX(double radiusX) {
        this.radiusX = radiusX;
    }

    public double getRadiusY() {
        return this.radiusY;
    }

    public void setRadiusY(double radiusY) {
        this.radiusY = radiusY;
    }

    public Point2D getScale() {
        return this.scale;
    }

    public void setScale(Point2D scale) {
        this.scale = scale;
    }

    public Paint getColor() {
        return this.color;
    }

    public void setColor(Paint color) {
        this.color = color;
    }

    public BlendMode getBlendMode() {
        return this.blendMode;
    }

    public void setBlendMode(BlendMode blendMode) {
        this.blendMode = blendMode;
    }

    public double getLife() {
        return this.life;
    }
}

