/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.entity;

import com.almasb.fxgl.app.FXGL;
import com.almasb.fxgl.entity.RenderLayer;
import com.almasb.fxgl.logging.Logger;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.ObservableList;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.shape.Circle;

public class EntityView
extends Parent {
    protected static final Logger log = FXGL.getLogger("FXGL.EntityView");
    private boolean removedFromScene = false;
    private ObjectProperty<RenderLayer> renderLayer = new SimpleObjectProperty((Object)RenderLayer.TOP);

    public EntityView() {
    }

    public EntityView(Node graphics) {
        this.addNode(graphics);
    }

    public EntityView(RenderLayer layer) {
        this.setRenderLayer(layer);
    }

    public EntityView(Node graphics, RenderLayer layer) {
        this.addNode(graphics);
        this.setRenderLayer(layer);
    }

    public final ObservableList<Node> getNodes() {
        return this.getChildren();
    }

    public final void addNode(Node node) {
        if (node instanceof Circle) {
            Circle c = (Circle)node;
            c.setCenterX(c.getRadius());
            c.setCenterY(c.getRadius());
        }
        this.getChildren().add((Object)node);
    }

    public final void removeNode(Node node) {
        this.getChildren().remove((Object)node);
    }

    public final void removeFromScene() {
        if (this.removedFromScene) {
            return;
        }
        this.getChildren().clear();
        try {
            if (this.getParent() == null) {
                this.removedFromScene = true;
                return;
            }
            if (this.getParent() instanceof EntityView) {
                ((EntityView)this.getParent()).removeFromScene();
            } else if (this.getParent() instanceof Group) {
                ((Group)this.getParent()).getChildren().remove((Object)this);
            } else {
                throw new IllegalStateException("View parent is of unknown type: " + this.getParent().getClass());
            }
            this.removedFromScene = true;
        }
        catch (Exception e) {
            log.warning("View wasn't removed from scene: " + e);
        }
    }

    public void setRenderLayer(RenderLayer renderLayer) {
        this.renderLayer.set((Object)renderLayer);
    }

    public RenderLayer getRenderLayer() {
        return (RenderLayer)this.renderLayer.get();
    }

    public ObjectProperty<RenderLayer> renderLayerProperty() {
        return this.renderLayer;
    }
}

