/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.entity.animation;

import com.almasb.fxgl.app.FXGL;
import com.almasb.fxgl.app.FXGLEvent;
import com.almasb.fxgl.entity.animation.AnimationBuilder;
import com.almasb.fxgl.entity.animation.AnimationState;
import com.almasb.fxgl.eventbus.Subscriber;
import com.almasb.fxgl.logging.Logger;
import javafx.animation.Animation;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\b&\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000f\u001a\u00020\u0010H&J\b\u0010\u0011\u001a\u00020\u0006H&J\u0006\u0010\u0012\u001a\u00020\u0010J\b\u0010\u0013\u001a\u00020\u0010H\u0004J\u0006\u0010\u0014\u001a\u00020\u0010J\u0006\u0010\u0015\u001a\u00020\u0010J\b\u0010\u0016\u001a\u00020\u0010H&R\u001a\u0010\u0005\u001a\u00020\u0006X\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/almasb/fxgl/entity/animation/EntityAnimation;", "", "animationBuilder", "Lcom/almasb/fxgl/entity/animation/AnimationBuilder;", "(Lcom/almasb/fxgl/entity/animation/AnimationBuilder;)V", "animation", "Ljavafx/animation/Animation;", "getAnimation", "()Ljavafx/animation/Animation;", "setAnimation", "(Ljavafx/animation/Animation;)V", "getAnimationBuilder", "()Lcom/almasb/fxgl/entity/animation/AnimationBuilder;", "state", "Lcom/almasb/fxgl/entity/animation/AnimationState;", "bindProperties", "", "buildAnimation", "finish", "initAnimation", "pause", "play", "unbindProperties", "Companion", "fxgl"})
public abstract class EntityAnimation {
    @NotNull
    protected Animation animation;
    private AnimationState state;
    @NotNull
    private final AnimationBuilder animationBuilder;
    private static final Logger log;
    public static final Companion Companion;

    @NotNull
    protected final Animation getAnimation() {
        Animation animation = this.animation;
        if (animation == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"animation");
        }
        return animation;
    }

    protected final void setAnimation(@NotNull Animation animation) {
        Intrinsics.checkParameterIsNotNull((Object)animation, (String)"<set-?>");
        this.animation = animation;
    }

    protected final void initAnimation() {
        Animation animation = this.animation = this.buildAnimation();
        if (animation == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"animation");
        }
        animation.setCycleCount(this.animationBuilder.getTimes());
        Animation animation2 = this.animation;
        if (animation2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"animation");
        }
        animation2.setDelay(this.animationBuilder.getDelay());
        Subscriber subscriberPause2 = FXGL.Companion.getEventBus().addEventHandler(FXGLEvent.PAUSE, (EventHandler)new EventHandler<FXGLEvent>(this){
            final /* synthetic */ EntityAnimation this$0;

            public final void handle(FXGLEvent e) {
                if (Intrinsics.areEqual((Object)((Object)EntityAnimation.access$getState$p(this.this$0)), (Object)((Object)AnimationState.PLAYING))) {
                    this.this$0.pause();
                }
            }
            {
                this.this$0 = entityAnimation;
            }
        });
        Subscriber subscriberResume2 = FXGL.Companion.getEventBus().addEventHandler(FXGLEvent.RESUME, (EventHandler)new EventHandler<FXGLEvent>(this){
            final /* synthetic */ EntityAnimation this$0;

            public final void handle(FXGLEvent e) {
                if (Intrinsics.areEqual((Object)((Object)EntityAnimation.access$getState$p(this.this$0)), (Object)((Object)AnimationState.PAUSED))) {
                    this.this$0.play();
                }
            }
            {
                this.this$0 = entityAnimation;
            }
        });
        this.bindProperties();
        Animation animation3 = this.animation;
        if (animation3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"animation");
        }
        animation3.setOnFinished((EventHandler)new EventHandler<ActionEvent>(this, subscriberPause2, subscriberResume2){
            final /* synthetic */ EntityAnimation this$0;
            final /* synthetic */ Subscriber $subscriberPause;
            final /* synthetic */ Subscriber $subscriberResume;

            public final void handle(ActionEvent it) {
                EntityAnimation.access$setState$p(this.this$0, AnimationState.FINISHED);
                this.$subscriberPause.unsubscribe();
                this.$subscriberResume.unsubscribe();
                this.this$0.unbindProperties();
            }
            {
                this.this$0 = entityAnimation;
                this.$subscriberPause = subscriber;
                this.$subscriberResume = subscriber2;
            }
        });
    }

    @NotNull
    public abstract Animation buildAnimation();

    public abstract void bindProperties();

    public abstract void unbindProperties();

    public final void play() {
        if (Intrinsics.areEqual((Object)((Object)this.state), (Object)((Object)AnimationState.FINISHED))) {
            EntityAnimation.Companion.getLog().warning("Attempted to play finished animation");
            return;
        }
        Animation animation = this.animation;
        if (animation == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"animation");
        }
        animation.play();
        this.state = AnimationState.PLAYING;
    }

    public final void pause() {
        if (Intrinsics.areEqual((Object)((Object)this.state), (Object)((Object)AnimationState.FINISHED)) || Intrinsics.areEqual((Object)((Object)this.state), (Object)((Object)AnimationState.INIT))) {
            EntityAnimation.Companion.getLog().warning("Attempted to pause finished or initializing animation");
            return;
        }
        Animation animation = this.animation;
        if (animation == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"animation");
        }
        animation.pause();
        this.state = AnimationState.PAUSED;
    }

    public final void finish() {
        if (Intrinsics.areEqual((Object)((Object)this.state), (Object)((Object)AnimationState.FINISHED))) {
            EntityAnimation.Companion.getLog().warning("Attempted to finish already finished animation");
            return;
        }
        Animation animation = this.animation;
        if (animation == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"animation");
        }
        animation.stop();
        this.state = AnimationState.FINISHED;
    }

    @NotNull
    protected final AnimationBuilder getAnimationBuilder() {
        return this.animationBuilder;
    }

    public EntityAnimation(@NotNull AnimationBuilder animationBuilder) {
        Intrinsics.checkParameterIsNotNull((Object)animationBuilder, (String)"animationBuilder");
        this.animationBuilder = animationBuilder;
        this.state = AnimationState.INIT;
    }

    static {
        Companion = new Companion(null);
        log = FXGL.Companion.getLogger(EntityAnimation.class);
    }

    @NotNull
    public static final /* synthetic */ AnimationState access$getState$p(EntityAnimation $this) {
        return $this.state;
    }

    public static final /* synthetic */ void access$setState$p(EntityAnimation $this, @NotNull AnimationState animationState) {
        $this.state = animationState;
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/almasb/fxgl/entity/animation/EntityAnimation$Companion;", "", "()V", "log", "Lcom/almasb/fxgl/logging/Logger;", "kotlin.jvm.PlatformType", "getLog", "()Lcom/almasb/fxgl/logging/Logger;", "fxgl"})
    public static final class Companion {
        private final Logger getLog() {
            return log;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

