/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.entity.component;

import com.almasb.fxgl.ecs.CopyableComponent;
import com.almasb.fxgl.ecs.Entity;
import com.almasb.fxgl.ecs.component.BooleanComponent;
import com.almasb.fxgl.ecs.component.Required;
import com.almasb.fxgl.entity.EntityView;
import com.almasb.fxgl.entity.GameWorld;
import com.almasb.fxgl.entity.component.ViewComponent;

@Required(value=ViewComponent.class)
public class SelectableComponent
extends BooleanComponent
implements CopyableComponent<SelectableComponent> {
    public SelectableComponent(boolean value) {
        super(value);
    }

    public void onAdded(Entity entity) {
        ViewComponent view = (ViewComponent)this.getEntity().getComponentUnsafe(ViewComponent.class);
        this.valueProperty().addListener((o, wasSelectable, isSelectable) -> {
            if (isSelectable.booleanValue()) {
                this.attachSelectListener(view.getView());
            } else {
                this.removeSelectListener(view.getView());
            }
        });
        if (this.getValue()) {
            this.attachSelectListener(view.getView());
        }
    }

    public void onRemoved(Entity entity) {
        ViewComponent view = (ViewComponent)this.getEntity().getComponentUnsafe(ViewComponent.class);
        this.removeSelectListener(view.getView());
    }

    private void attachSelectListener(EntityView view) {
        view.setOnMousePressed(e -> ((GameWorld)this.getEntity().getWorld()).selectedEntityProperty().set((Object)this.getEntity()));
    }

    private void removeSelectListener(EntityView view) {
        view.setOnMousePressed(null);
        ((GameWorld)this.getEntity().getWorld()).getSelectedEntity().ifPresent(e -> {
            if (e == this.getEntity()) {
                ((GameWorld)this.getEntity().getWorld()).selectedEntityProperty().set(null);
            }
        });
    }

    public SelectableComponent copy() {
        return new SelectableComponent(this.getValue());
    }
}

