/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.logging;

import com.almasb.fxgl.logging.Logger;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.logging.log4j.LogManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0013\b\u0016\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\u0002\u0010\u0004B\r\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\r2\u000e\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0010H\u0016J\u0012\u0010\u000e\u001a\u00020\r2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0006H\u0016J\u0018\u0010\u0012\u001a\u00020\r2\u000e\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0010H\u0016J\u0012\u0010\u0012\u001a\u00020\r2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0006H\u0016J\u0018\u0010\u0013\u001a\u00020\r2\u000e\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0010H\u0016J\u0012\u0010\u0013\u001a\u00020\r2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0006H\u0016J\u0018\u0010\u0014\u001a\u00020\r2\u000e\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0010H\u0016J\u0012\u0010\u0014\u001a\u00020\r2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0006H\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lcom/almasb/fxgl/logging/FXGLLogger;", "Lcom/almasb/fxgl/logging/Logger;", "caller", "Ljava/lang/Class;", "(Ljava/lang/Class;)V", "name", "", "(Ljava/lang/String;)V", "log", "Lorg/apache/logging/log4j/Logger;", "getName", "()Ljava/lang/String;", "close", "", "debug", "messageSupplier", "Ljava/util/function/Supplier;", "message", "fatal", "info", "warning", "fxgl"})
public final class FXGLLogger
implements Logger {
    private final org.apache.logging.log4j.Logger log;
    @NotNull
    private final String name;

    @Override
    public void info(@Nullable String message) {
        this.log.info(message);
    }

    @Override
    public void info(@Nullable Supplier<String> messageSupplier) {
        Supplier<String> supplier = messageSupplier;
        this.log.info(supplier != null ? supplier.get() : null);
    }

    @Override
    public void debug(@Nullable String message) {
        this.log.debug(message);
    }

    @Override
    public void debug(@Nullable Supplier<String> messageSupplier) {
        Supplier<String> supplier = messageSupplier;
        this.log.debug(supplier != null ? supplier.get() : null);
    }

    @Override
    public void warning(@Nullable String message) {
        this.log.warn(message);
    }

    @Override
    public void warning(@Nullable Supplier<String> messageSupplier) {
        Supplier<String> supplier = messageSupplier;
        this.log.warn(supplier != null ? supplier.get() : null);
    }

    @Override
    public void fatal(@Nullable String message) {
        this.log.fatal(message);
    }

    @Override
    public void fatal(@Nullable Supplier<String> messageSupplier) {
        Supplier<String> supplier = messageSupplier;
        this.log.fatal(supplier != null ? supplier.get() : null);
    }

    @Override
    public void close() {
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    public FXGLLogger(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        this.name = name;
        org.apache.logging.log4j.Logger logger = LogManager.getLogger((String)this.name);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"LogManager.getLogger(name)");
        this.log = logger;
    }

    public FXGLLogger(@NotNull Class<?> caller) {
        Intrinsics.checkParameterIsNotNull(caller, (String)"caller");
        String string = caller.getSimpleName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"caller.simpleName");
        this(string);
    }
}

