/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.parser;

import com.almasb.fxgl.app.FXGL;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;

public final class JavaScriptParser {
    private static final ScriptEngineManager manager = new ScriptEngineManager();
    private ScriptEngine engine = manager.getEngineByName("nashorn");
    private Invocable invocableEngine;

    public JavaScriptParser(String scriptFileName) {
        try {
            this.engine.eval(FXGL.getAssetLoader().loadScript("FXGL.js"));
            if (scriptFileName.endsWith(".js")) {
                this.engine.eval(FXGL.getAssetLoader().loadScript(scriptFileName));
            } else {
                this.engine.eval(scriptFileName);
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Script cannot parsed: " + e);
        }
        this.invocableEngine = (Invocable)((Object)this.engine);
    }

    public <T> T callFunction(String name, Object ... args) {
        try {
            return (T)this.invocableEngine.invokeFunction(name, args);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Function call failed: " + e);
        }
    }

    static {
        manager.put("HOME_DIR", JavaScriptParser.class.getResource("/assets/scripts/"));
        manager.put("FXGL", FXGL.Companion);
        manager.put("APP", (Object)FXGL.getApp());
    }
}

