/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.scene.menu;

import com.almasb.fxgl.app.FXGL;
import com.almasb.fxgl.app.GameApplication;
import com.almasb.fxgl.scene.FXGLMenu;
import com.almasb.fxgl.scene.menu.MenuType;
import com.almasb.fxgl.scene.menu.ProfileSelectedEvent;
import com.almasb.fxgl.settings.MenuItem;
import com.almasb.fxgl.ui.FXGLButton;
import java.util.EnumSet;
import java.util.function.Supplier;
import javafx.animation.FadeTransition;
import javafx.event.ActionEvent;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Line;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Text;
import javafx.util.Duration;

public class FXGLDefaultMenu
extends FXGLMenu {
    public FXGLDefaultMenu(GameApplication app, MenuType type) {
        super(app, type);
        MenuBox menu = type == MenuType.MAIN_MENU ? this.createMenuBodyMainMenu() : this.createMenuBodyGameMenu();
        double menuX = 50.0;
        double menuY = app.getHeight() / 2.0 - menu.getLayoutHeight() / 2.0;
        this.menuRoot.setTranslateX(menuX);
        this.menuRoot.setTranslateY(menuY);
        this.contentRoot.setTranslateX(menuX * 2.0 + 200.0);
        this.contentRoot.setTranslateY(menuY);
        this.menuRoot.getChildren().add((Object)menu);
        this.contentRoot.getChildren().add((Object)this.EMPTY);
        this.activeProperty().addListener((observable, wasActive, isActive) -> {
            if (!isActive.booleanValue()) {
                this.switchMenuTo((Node)menu);
                this.switchMenuContentTo((Node)this.EMPTY);
            }
        });
    }

    @Override
    protected Node createBackground(double width, double height) {
        Rectangle bg = new Rectangle(width, height);
        bg.setFill((Paint)Color.rgb((int)10, (int)1, (int)1));
        return bg;
    }

    @Override
    protected Node createTitleView(String title) {
        Text text = FXGL.getUIFactory().newText(title, 50.0);
        Rectangle bg = new Rectangle(text.getLayoutBounds().getWidth() + 20.0, 60.0, null);
        bg.setStroke((Paint)Color.WHITE);
        bg.setStrokeWidth(2.0);
        StackPane titleRoot = new StackPane();
        titleRoot.getChildren().addAll((Object[])new Node[]{bg, text});
        titleRoot.setTranslateX(this.app.getWidth() / 2.0 - (text.getLayoutBounds().getWidth() + 20.0) / 2.0);
        titleRoot.setTranslateY(50.0);
        return titleRoot;
    }

    @Override
    protected Node createVersionView(String version) {
        Text view = FXGL.getUIFactory().newText(version);
        view.setTranslateY(this.app.getHeight() - 2.0);
        return view;
    }

    @Override
    protected Node createProfileView(String profileName) {
        Text view = FXGL.getUIFactory().newText(profileName);
        view.setTranslateY(this.app.getHeight() - 2.0);
        view.setTranslateX(this.app.getWidth() - view.getLayoutBounds().getWidth());
        return view;
    }

    protected MenuBox createMenuBodyMainMenu() {
        log.debug("createMenuBodyMainMenu()");
        MenuBox box = new MenuBox(200, new MenuButton[0]);
        EnumSet<MenuItem> enabledItems = this.app.getSettings().getEnabledMenuItems();
        if (enabledItems.contains((Object)MenuItem.SAVE_LOAD)) {
            MenuButton itemContinue2 = new MenuButton("CONTINUE");
            itemContinue2.setOnAction(e -> this.fireContinue());
            box.add(itemContinue2);
            this.app.getEventBus().addEventHandler(ProfileSelectedEvent.ANY, event -> itemContinue2.setDisable(!event.hasSaves()));
        }
        MenuButton itemNewGame2 = new MenuButton("NEW GAME");
        itemNewGame2.setOnAction(e -> this.fireNewGame());
        box.add(itemNewGame2);
        if (enabledItems.contains((Object)MenuItem.SAVE_LOAD)) {
            MenuButton itemLoad = new MenuButton("LOAD");
            itemLoad.setMenuContent(this::createContentLoad);
            box.add(itemLoad);
        }
        MenuButton itemOptions = new MenuButton("OPTIONS");
        itemOptions.setChild(this.createOptionsMenu());
        box.add(itemOptions);
        if (enabledItems.contains((Object)MenuItem.EXTRA)) {
            MenuButton itemExtra = new MenuButton("EXTRA");
            itemExtra.setChild(this.createExtraMenu());
            box.add(itemExtra);
        }
        if (enabledItems.contains((Object)MenuItem.ONLINE)) {
            MenuButton itemMultiplayer = new MenuButton("ONLINE");
            itemMultiplayer.setOnAction(e -> this.fireMultiplayer());
            box.add(itemMultiplayer);
        }
        MenuButton itemLogout = new MenuButton("LOGOUT");
        itemLogout.setOnAction(e -> this.fireLogout());
        box.add(itemLogout);
        MenuButton itemExit2 = new MenuButton("EXIT");
        itemExit2.setOnAction(e -> this.fireExit());
        box.add(itemExit2);
        return box;
    }

    protected MenuBox createMenuBodyGameMenu() {
        log.debug("createMenuBodyGameMenu()");
        MenuBox box = new MenuBox(200, new MenuButton[0]);
        EnumSet<MenuItem> enabledItems = this.app.getSettings().getEnabledMenuItems();
        MenuButton itemResume = new MenuButton("RESUME");
        itemResume.setOnAction(e -> this.fireResume());
        box.add(itemResume);
        if (enabledItems.contains((Object)MenuItem.SAVE_LOAD)) {
            MenuButton itemSave = new MenuButton("SAVE");
            itemSave.setOnAction(e -> this.fireSave());
            MenuButton itemLoad = new MenuButton("LOAD");
            itemLoad.setMenuContent(this::createContentLoad);
            box.add(itemSave);
            box.add(itemLoad);
        }
        MenuButton itemOptions = new MenuButton("OPTIONS");
        itemOptions.setChild(this.createOptionsMenu());
        box.add(itemOptions);
        if (enabledItems.contains((Object)MenuItem.EXTRA)) {
            MenuButton itemExtra = new MenuButton("EXTRA");
            itemExtra.setChild(this.createExtraMenu());
            box.add(itemExtra);
        }
        MenuButton itemExit2 = new MenuButton("MAIN MENU");
        itemExit2.setOnAction(e -> this.fireExitToMainMenu());
        box.add(itemExit2);
        return box;
    }

    protected MenuBox createOptionsMenu() {
        log.debug("createOptionsMenu()");
        MenuButton itemGameplay = new MenuButton("GAMEPLAY");
        itemGameplay.setMenuContent(this::createContentGameplay);
        MenuButton itemControls = new MenuButton("CONTROLS");
        itemControls.setMenuContent(this::createContentControls);
        MenuButton itemVideo = new MenuButton("VIDEO");
        itemVideo.setMenuContent(this::createContentVideo);
        MenuButton itemAudio = new MenuButton("AUDIO");
        itemAudio.setMenuContent(this::createContentAudio);
        MenuButton btnRestore = new MenuButton("RESTORE");
        btnRestore.setOnAction(e -> this.app.getDisplay().showConfirmationBox("Settings will be restored to default", yes -> {
            if (yes.booleanValue()) {
                this.switchMenuContentTo((Node)this.EMPTY);
                this.listener.restoreDefaultSettings();
            }
        }));
        return new MenuBox(200, itemGameplay, itemControls, itemVideo, itemAudio, btnRestore);
    }

    protected MenuBox createExtraMenu() {
        log.debug("createExtraMenu()");
        MenuButton itemAchievements = new MenuButton("TROPHIES");
        itemAchievements.setMenuContent(this::createContentAchievements);
        MenuButton itemCredits = new MenuButton("CREDITS");
        itemCredits.setMenuContent(this::createContentCredits);
        MenuButton itemFeedback = new MenuButton("FEEDBACK");
        itemFeedback.setMenuContent(this::createContentFeedback);
        return new MenuBox(200, itemAchievements, itemCredits, itemFeedback);
    }

    @Override
    protected void switchMenuTo(Node menu) {
        Node oldMenu = (Node)this.menuRoot.getChildren().get(0);
        FadeTransition ft = new FadeTransition(Duration.seconds((double)0.33), oldMenu);
        ft.setToValue(0.0);
        ft.setOnFinished(e -> {
            menu.setOpacity(0.0);
            this.menuRoot.getChildren().set(0, (Object)menu);
            oldMenu.setOpacity(1.0);
            FadeTransition ft2 = new FadeTransition(Duration.seconds((double)0.33), menu);
            ft2.setToValue(1.0);
            ft2.play();
        });
        ft.play();
    }

    @Override
    protected void switchMenuContentTo(Node content) {
        this.contentRoot.getChildren().set(0, (Object)content);
    }

    @Override
    protected Button createActionButton(String name, Runnable action2) {
        MenuButton btn = new MenuButton(name);
        btn.addEventHandler(ActionEvent.ACTION, event -> action2.run());
        return btn;
    }

    private class MenuButton
    extends FXGLButton {
        private MenuBox parent;
        private FXGLMenu.MenuContent cachedContent;

        MenuButton(String name) {
            super(name);
            this.cachedContent = null;
        }

        public void setParent(MenuBox menu) {
            this.parent = menu;
        }

        public void setMenuContent(Supplier<FXGLMenu.MenuContent> contentSupplier) {
            this.addEventHandler(ActionEvent.ACTION, event -> {
                if (this.cachedContent == null) {
                    this.cachedContent = (FXGLMenu.MenuContent)((Object)((Object)contentSupplier.get()));
                }
                FXGLDefaultMenu.this.switchMenuContentTo((Node)this.cachedContent);
            });
        }

        public void setChild(MenuBox menu) {
            MenuButton back = new MenuButton("BACK");
            menu.getChildren().add(0, (Object)back);
            back.addEventHandler(ActionEvent.ACTION, event -> FXGLDefaultMenu.this.switchMenuTo((Node)this.parent));
            this.addEventHandler(ActionEvent.ACTION, event -> FXGLDefaultMenu.this.switchMenuTo((Node)menu));
        }
    }

    private static class MenuBox
    extends VBox {
        private int width;

        MenuBox(int width, MenuButton ... items) {
            this.width = width;
            this.getChildren().add((Object)this.createSeparator(width));
            for (MenuButton item : items) {
                this.add(item);
            }
        }

        void add(MenuButton item) {
            item.setParent(this);
            this.getChildren().addAll((Object[])new Node[]{item, this.createSeparator(this.width)});
        }

        private Line createSeparator(int width) {
            Line sep = new Line();
            sep.setEndX((double)width);
            sep.setStroke((Paint)Color.DARKGREY);
            return sep;
        }

        double getLayoutHeight() {
            return 10 * this.getChildren().size();
        }
    }
}

