/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.service.impl.timer;

import com.almasb.fxgl.app.FXGL;
import com.almasb.fxgl.io.serialization.Bundle;
import com.almasb.fxgl.logging.Logger;
import com.almasb.fxgl.service.MasterTimer;
import com.almasb.fxgl.service.impl.timer.FXGLMasterTimer;
import com.almasb.fxgl.settings.UserProfile;
import com.almasb.fxgl.time.FPSCounter;
import com.almasb.fxgl.time.TimerAction;
import com.almasb.fxgl.time.TimerActionImpl;
import com.almasb.fxgl.time.UpdateEvent;
import com.almasb.fxgl.time.UpdateEventListener;
import com.google.inject.Inject;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.CopyOnWriteArrayList;
import javafx.animation.AnimationTimer;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyLongProperty;
import javafx.beans.property.ReadOnlyLongWrapper;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.util.Duration;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u0000 C2\u00020\u00012\u00020\u0002:\u0001CB\u0007\b\u0003\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u000bH\u0016J\b\u0010\"\u001a\u00020\u0005H\u0016J\b\u0010#\u001a\u00020\u0010H\u0016J\u0010\u0010$\u001a\u00020 2\u0006\u0010%\u001a\u00020\u0010H\u0016J\u0010\u0010&\u001a\u00020 2\u0006\u0010'\u001a\u00020(H\u0016J\b\u0010)\u001a\u00020 H\u0016J\b\u0010*\u001a\u00020 H\u0016J\b\u0010+\u001a\u00020 H\u0016J\b\u0010,\u001a\u00020 H\u0016J\b\u0010-\u001a\u00020\u0005H\u0016J\u0010\u0010.\u001a\n \u000e*\u0004\u0018\u00010/0/H\u0016J\u0010\u00100\u001a\u00020 2\u0006\u0010!\u001a\u00020\u000bH\u0016J\b\u00101\u001a\u00020 H\u0016J\u0018\u00102\u001a\u0002032\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u000207H\u0016J \u00108\u001a\u0002032\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u0002072\u0006\u00109\u001a\u00020:H\u0016J\u0018\u0010;\u001a\u0002032\u0006\u00104\u001a\u0002052\u0006\u0010<\u001a\u000207H\u0016J\u0010\u0010=\u001a\u00020 2\u0006\u0010'\u001a\u00020(H\u0016J\b\u0010>\u001a\u00020 H\u0016J\b\u0010?\u001a\u00020 H\u0016J\b\u0010@\u001a\u00020 H\u0002J\u0010\u0010A\u001a\n \u000e*\u0004\u0018\u00010/0/H\u0016J\u0010\u0010B\u001a\u00020 2\u0006\u0010%\u001a\u00020\u0010H\u0002J\b\u0010\u001b\u001a\u00020\u001cH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006D"}, d2={"Lcom/almasb/fxgl/service/impl/timer/FXGLMasterTimer;", "Ljavafx/animation/AnimationTimer;", "Lcom/almasb/fxgl/service/MasterTimer;", "()V", "fps", "Ljavafx/beans/property/SimpleIntegerProperty;", "fpsCounter", "Lcom/almasb/fxgl/time/FPSCounter;", "fpsPerformanceCounter", "listeners", "Ljava/util/ArrayList;", "Lcom/almasb/fxgl/time/UpdateEventListener;", "log", "Lcom/almasb/fxgl/logging/Logger;", "kotlin.jvm.PlatformType", "now", "", "performanceFPS", "playtime", "Ljavafx/beans/property/ReadOnlyLongWrapper;", "previousInternalTime", "realTPF", "startNanos", "tick", "timerActions", "Ljava/util/concurrent/CopyOnWriteArrayList;", "Lcom/almasb/fxgl/time/TimerActionImpl;", "tpf", "", "updateEvent", "Lcom/almasb/fxgl/time/UpdateEvent;", "addUpdateListener", "", "listener", "fpsProperty", "getNow", "handle", "internalTime", "load", "profile", "Lcom/almasb/fxgl/settings/UserProfile;", "onExit", "onPause", "onReset", "onResume", "performanceFPSProperty", "playtimeProperty", "Ljavafx/beans/property/ReadOnlyLongProperty;", "removeUpdateListener", "reset", "runAtInterval", "Lcom/almasb/fxgl/time/TimerAction;", "action", "Ljava/lang/Runnable;", "interval", "Ljavafx/util/Duration;", "runAtIntervalWhile", "whileCondition", "Ljavafx/beans/property/ReadOnlyBooleanProperty;", "runOnceAfter", "delay", "save", "start", "stop", "tickEnd", "tickProperty", "tickStart", "Companion", "fxgl"})
public final class FXGLMasterTimer
extends AnimationTimer
implements MasterTimer {
    private final Logger log = FXGL.Companion.getLogger(this.getClass());
    private final ArrayList<UpdateEventListener> listeners;
    private final UpdateEvent updateEvent;
    private final CopyOnWriteArrayList<TimerActionImpl> timerActions;
    private final ReadOnlyLongWrapper tick;
    private ReadOnlyLongWrapper playtime;
    private long now;
    private double tpf;
    private final FPSCounter fpsCounter;
    private final FPSCounter fpsPerformanceCounter;
    private long previousInternalTime;
    private final SimpleIntegerProperty fps;
    private final SimpleIntegerProperty performanceFPS;
    private long startNanos;
    private long realTPF;
    private static final long TPF_NANOS = 16666666L;
    public static final Companion Companion = new Companion(null);

    @Override
    public void onPause() {
        this.stop();
    }

    @Override
    public void onResume() {
        this.start();
    }

    @Override
    public void onReset() {
        this.reset();
    }

    @Override
    public void onExit() {
    }

    @Override
    public void addUpdateListener(@NotNull UpdateEventListener listener2) {
        Intrinsics.checkParameterIsNotNull((Object)listener2, (String)"listener");
        this.listeners.add(listener2);
    }

    @Override
    public void removeUpdateListener(@NotNull UpdateEventListener listener2) {
        Intrinsics.checkParameterIsNotNull((Object)listener2, (String)"listener");
        this.listeners.remove(listener2);
    }

    /*
     * WARNING - void declaration
     */
    public void handle(long internalTime) {
        this.tickStart(internalTime);
        Iterable $receiver$iv22 = this.timerActions;
        for (Object element$iv : $receiver$iv22) {
            TimerActionImpl action2 = (TimerActionImpl)element$iv;
            action2.update(this.now);
        }
        this.timerActions.removeIf(handle.2.INSTANCE);
        this.updateEvent.setTick(this.getTick());
        this.updateEvent.setTPF(this.tpf);
        int $receiver$iv22 = 0;
        int n = ((Collection)this.listeners).size() - 1;
        if ($receiver$iv22 <= n) {
            while (true) {
                void i;
                this.listeners.get((int)i).onUpdateEvent(this.updateEvent);
                if (i == n) break;
                ++i;
            }
        }
        this.tickEnd();
    }

    @Override
    public ReadOnlyLongProperty tickProperty() {
        return this.tick.getReadOnlyProperty();
    }

    @Override
    public ReadOnlyLongProperty playtimeProperty() {
        return this.playtime.getReadOnlyProperty();
    }

    public void start() {
        this.log.debug(start.1.INSTANCE);
        super.start();
    }

    public void stop() {
        this.log.debug(stop.1.INSTANCE);
        super.stop();
    }

    @Override
    public void reset() {
        this.log.debug("Resetting ticks and clearing all actions");
        this.tick.set(0L);
        this.now = 0L;
        this.timerActions.clear();
    }

    @Override
    public long getNow() {
        return this.now;
    }

    @Override
    public double tpf() {
        return this.tpf;
    }

    @NotNull
    public SimpleIntegerProperty fpsProperty() {
        return this.fps;
    }

    @NotNull
    public SimpleIntegerProperty performanceFPSProperty() {
        return this.performanceFPS;
    }

    private final void tickStart(long internalTime) {
        this.tick.set(this.tick.get() + (long)1);
        this.startNanos = System.nanoTime();
        this.realTPF = internalTime - this.previousInternalTime;
        if (this.realTPF > Companion.tpfNanos()) {
            this.realTPF = Companion.tpfNanos();
        }
        this.now += this.realTPF;
        ReadOnlyLongWrapper readOnlyLongWrapper = this.playtime;
        readOnlyLongWrapper.setValue((Number)(readOnlyLongWrapper.getValue() + this.realTPF));
        this.previousInternalTime = internalTime;
        this.tpf = (double)this.realTPF / 1.0E9;
    }

    private final void tickEnd() {
        this.performanceFPS.set(Math.round(this.fpsPerformanceCounter.count(Companion.secondsToNanos(1.0) / (System.nanoTime() - this.startNanos))));
        this.fps.set(Math.round(this.fpsCounter.count(Companion.secondsToNanos(1.0) / this.realTPF)));
    }

    @Override
    @NotNull
    public TimerAction runAtInterval(@NotNull Runnable action2, @NotNull Duration interval) {
        Intrinsics.checkParameterIsNotNull((Object)action2, (String)"action");
        Intrinsics.checkParameterIsNotNull((Object)interval, (String)"interval");
        TimerActionImpl act = new TimerActionImpl(this.getNow(), interval, action2, TimerActionImpl.TimerType.INDEFINITE);
        this.timerActions.add(act);
        return act;
    }

    @Override
    @NotNull
    public TimerAction runAtIntervalWhile(@NotNull Runnable action2, @NotNull Duration interval, @NotNull ReadOnlyBooleanProperty whileCondition) {
        Intrinsics.checkParameterIsNotNull((Object)action2, (String)"action");
        Intrinsics.checkParameterIsNotNull((Object)interval, (String)"interval");
        Intrinsics.checkParameterIsNotNull((Object)whileCondition, (String)"whileCondition");
        if (!whileCondition.get()) {
            throw (Throwable)new IllegalArgumentException("While condition is false");
        }
        TimerActionImpl act = new TimerActionImpl(this.getNow(), interval, action2, TimerActionImpl.TimerType.INDEFINITE);
        this.timerActions.add(act);
        whileCondition.addListener((ChangeListener)new ChangeListener<Boolean>(act){
            final /* synthetic */ TimerActionImpl $act;

            public final void changed(ObservableValue<? extends Boolean> obs, Boolean old, Boolean isTrue) {
                if (!isTrue.booleanValue()) {
                    this.$act.expire();
                }
            }
            {
                this.$act = timerActionImpl;
            }
        });
        return act;
    }

    @Override
    @NotNull
    public TimerAction runOnceAfter(@NotNull Runnable action2, @NotNull Duration delay) {
        Intrinsics.checkParameterIsNotNull((Object)action2, (String)"action");
        Intrinsics.checkParameterIsNotNull((Object)delay, (String)"delay");
        TimerActionImpl act = new TimerActionImpl(this.getNow(), delay, action2, TimerActionImpl.TimerType.ONCE);
        this.timerActions.add(act);
        return act;
    }

    @Override
    public void save(@NotNull UserProfile profile) {
        Intrinsics.checkParameterIsNotNull((Object)profile, (String)"profile");
        this.log.debug("Saving data to profile");
        Bundle bundle = new Bundle("timer");
        Serializable serializable = this.playtime.getValue();
        Intrinsics.checkExpressionValueIsNotNull((Object)serializable, (String)"playtime.value");
        bundle.put("playtime", serializable);
        bundle.log();
        profile.putBundle(bundle);
    }

    @Override
    public void load(@NotNull UserProfile profile) {
        Intrinsics.checkParameterIsNotNull((Object)profile, (String)"profile");
        this.log.debug("Loading data from profile");
        Bundle bundle = profile.getBundle("timer");
        bundle.log();
        this.playtime.setValue((Number)bundle.get("playtime"));
    }

    @Inject
    private FXGLMasterTimer() {
        this.log.debug("Service [MasterTimer] initialized");
        this.listeners = new ArrayList();
        this.updateEvent = new UpdateEvent(0L, 0.0);
        this.timerActions = new CopyOnWriteArrayList();
        this.tick = new ReadOnlyLongWrapper(0L);
        this.playtime = new ReadOnlyLongWrapper(0L);
        this.fpsCounter = new FPSCounter();
        this.fpsPerformanceCounter = new FPSCounter();
        this.fps = new SimpleIntegerProperty();
        this.performanceFPS = new SimpleIntegerProperty();
        this.startNanos = -1L;
        this.realTPF = -1L;
    }

    static {
        TPF_NANOS = 16666666L;
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fJ\u0006\u0010\r\u001a\u00020\u0004J\u0006\u0010\u000e\u001a\u00020\tR\u0014\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000f"}, d2={"Lcom/almasb/fxgl/service/impl/timer/FXGLMasterTimer$Companion;", "", "()V", "TPF_NANOS", "", "getTPF_NANOS", "()J", "secondsToNanos", "seconds", "", "toNanos", "duration", "Ljavafx/util/Duration;", "tpfNanos", "tpfSeconds", "fxgl"})
    public static final class Companion {
        public final double tpfSeconds() {
            return 0.016666666666666666;
        }

        private final long getTPF_NANOS() {
            return TPF_NANOS;
        }

        public final long tpfNanos() {
            return this.getTPF_NANOS();
        }

        public final long secondsToNanos(double seconds) {
            return (long)(seconds * (double)1000000000L);
        }

        public final long toNanos(@NotNull Duration duration) {
            Intrinsics.checkParameterIsNotNull((Object)duration, (String)"duration");
            return this.secondsToNanos(duration.toSeconds());
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

