/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.ai.goap;

import com.almasb.fxgl.ai.goap.GoapAction;
import com.almasb.fxgl.ai.goap.State;
import com.almasb.fxgl.ecs.Entity;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0017B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J4\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0002J2\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u0013\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\rJ\u0018\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\rH\u0002\u00a8\u0006\u0018"}, d2={"Lcom/almasb/fxgl/ai/goap/GoapPlanner;", "", "()V", "buildGraph", "", "parent", "Lcom/almasb/fxgl/ai/goap/GoapPlanner$Node;", "leaves", "", "usableActions", "", "Lcom/almasb/fxgl/ai/goap/GoapAction;", "goal", "Lcom/almasb/fxgl/ai/goap/State;", "plan", "Ljava/util/Queue;", "agent", "Lcom/almasb/fxgl/ecs/Entity;", "availableActions", "worldState", "populateState", "currentState", "stateChange", "Node", "fxgl"})
public final class GoapPlanner {
    public static final GoapPlanner INSTANCE;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Queue<GoapAction> plan(@NotNull Entity agent, @NotNull Set<? extends GoapAction> availableActions, @NotNull State worldState, @NotNull State goal) {
        Object v0;
        void $receiver$iv$iv;
        Object element$iv2;
        Intrinsics.checkParameterIsNotNull((Object)agent, (String)"agent");
        Intrinsics.checkParameterIsNotNull(availableActions, (String)"availableActions");
        Intrinsics.checkParameterIsNotNull((Object)worldState, (String)"worldState");
        Intrinsics.checkParameterIsNotNull((Object)goal, (String)"goal");
        Iterable $receiver$iv = availableActions;
        for (Object element$iv2 : $receiver$iv) {
            GoapAction it = (GoapAction)element$iv2;
            it.reset();
        }
        Iterable $receiver$iv2 = availableActions;
        element$iv2 = $receiver$iv2;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            GoapAction it = (GoapAction)element$iv$iv;
            if (!it.checkProceduralPrecondition(agent)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Node start2 = new Node(null, 0.0f, worldState, null);
        ArrayList leaves = new ArrayList();
        Set usableActions = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        boolean success = this.buildGraph(start2, leaves, usableActions, goal);
        if (!success) {
            return new ArrayDeque();
        }
        Iterable $receiver$iv3 = leaves;
        Iterator iterator$iv = $receiver$iv3.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object minElem$iv = iterator$iv.next();
            Node it = (Node)minElem$iv;
            Comparable minValue$iv = Float.valueOf(it.getRunningCost());
            while (iterator$iv.hasNext()) {
                Object e$iv = iterator$iv.next();
                Node it2 = (Node)e$iv;
                Comparable v$iv = Float.valueOf(it2.getRunningCost());
                if (minValue$iv.compareTo(v$iv) <= 0) continue;
                minElem$iv = e$iv;
                minValue$iv = v$iv;
            }
            v0 = minElem$iv;
        }
        Node cheapest = v0;
        ArrayList<GoapAction> result = new ArrayList<GoapAction>();
        for (Node n = cheapest; n != null; n = n.getParent()) {
            if (n.getAction() == null) continue;
            GoapAction goapAction = n.getAction();
            if (goapAction == null) {
                Intrinsics.throwNpe();
            }
            result.add(goapAction);
        }
        return new ArrayDeque(CollectionsKt.reversed((Iterable)result));
    }

    private final boolean buildGraph(Node parent, List<Node> leaves, Set<? extends GoapAction> usableActions, State goal) {
        boolean foundOne = false;
        for (GoapAction goapAction : usableActions) {
            if (!goapAction.getPreconditions().isIn(parent.getState())) continue;
            State currentState = this.populateState(parent.getState(), goapAction.getEffects());
            Node node = new Node(parent, parent.getRunningCost() + goapAction.getCost(), currentState, goapAction);
            if (goal.isIn(currentState)) {
                leaves.add(node);
                foundOne = true;
                continue;
            }
            Set subset = SetsKt.minus(usableActions, (Object)goapAction);
            boolean found = this.buildGraph(node, leaves, subset, goal);
            if (!found) continue;
            foundOne = true;
        }
        return foundOne;
    }

    private final State populateState(State currentState, State stateChange) {
        State newState = new State(currentState);
        newState.update(stateChange);
        return newState;
    }

    private GoapPlanner() {
        INSTANCE = this;
    }

    static {
        new GoapPlanner();
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0012\b\u0002\u0018\u00002\u00020\u0001B)\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tR\u001c\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001c\u0010\u0002\u001a\u0004\u0018\u00010\u0000X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001a"}, d2={"Lcom/almasb/fxgl/ai/goap/GoapPlanner$Node;", "", "parent", "runningCost", "", "state", "Lcom/almasb/fxgl/ai/goap/State;", "action", "Lcom/almasb/fxgl/ai/goap/GoapAction;", "(Lcom/almasb/fxgl/ai/goap/GoapPlanner$Node;FLcom/almasb/fxgl/ai/goap/State;Lcom/almasb/fxgl/ai/goap/GoapAction;)V", "getAction", "()Lcom/almasb/fxgl/ai/goap/GoapAction;", "setAction", "(Lcom/almasb/fxgl/ai/goap/GoapAction;)V", "getParent", "()Lcom/almasb/fxgl/ai/goap/GoapPlanner$Node;", "setParent", "(Lcom/almasb/fxgl/ai/goap/GoapPlanner$Node;)V", "getRunningCost", "()F", "setRunningCost", "(F)V", "getState", "()Lcom/almasb/fxgl/ai/goap/State;", "setState", "(Lcom/almasb/fxgl/ai/goap/State;)V", "fxgl"})
    private static final class Node {
        @Nullable
        private Node parent;
        private float runningCost;
        @NotNull
        private State state;
        @Nullable
        private GoapAction action;

        @Nullable
        public final Node getParent() {
            return this.parent;
        }

        public final void setParent(@Nullable Node node) {
            this.parent = node;
        }

        public final float getRunningCost() {
            return this.runningCost;
        }

        public final void setRunningCost(float f) {
            this.runningCost = f;
        }

        @NotNull
        public final State getState() {
            return this.state;
        }

        public final void setState(@NotNull State state) {
            Intrinsics.checkParameterIsNotNull((Object)state, (String)"<set-?>");
            this.state = state;
        }

        @Nullable
        public final GoapAction getAction() {
            return this.action;
        }

        public final void setAction(@Nullable GoapAction goapAction) {
            this.action = goapAction;
        }

        public Node(@Nullable Node parent, float runningCost, @NotNull State state, @Nullable GoapAction action2) {
            Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
            this.parent = parent;
            this.runningCost = runningCost;
            this.state = state;
            this.action = action2;
        }
    }
}

