/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.app;

import com.almasb.fxgl.app.ApplicationModule;
import com.almasb.fxgl.app.FXGL;
import com.almasb.fxgl.app.FXGLEvent;
import com.almasb.fxgl.app.GameApplication;
import com.almasb.fxgl.app.UpdaterTask;
import com.almasb.fxgl.core.concurrent.Async;
import com.almasb.fxgl.core.logging.FXGLLogger;
import com.almasb.fxgl.core.logging.Logger;
import com.almasb.fxgl.gameplay.AchievementManager;
import com.almasb.fxgl.scene.PreloadingScene;
import com.almasb.fxgl.service.AssetLoader;
import com.almasb.fxgl.service.AudioPlayer;
import com.almasb.fxgl.service.Display;
import com.almasb.fxgl.service.EventBus;
import com.almasb.fxgl.service.ExceptionHandler;
import com.almasb.fxgl.service.Executor;
import com.almasb.fxgl.service.Input;
import com.almasb.fxgl.service.MasterTimer;
import com.almasb.fxgl.service.Net;
import com.almasb.fxgl.service.NotificationService;
import com.almasb.fxgl.service.QTE;
import com.almasb.fxgl.service.QuestService;
import com.almasb.fxgl.service.UIFactory;
import com.almasb.fxgl.service.listener.FXGLListener;
import com.almasb.fxgl.settings.GameSettings;
import com.almasb.fxgl.settings.ReadOnlyGameSettings;
import com.almasb.fxgl.util.Version;
import com.google.inject.Module;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.geometry.Rectangle2D;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.layout.Pane;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;

public abstract class FXGLApplication
extends Application {
    protected static Logger log = FXGLLogger.getSystemLogger();
    private Stage primaryStage;
    private ReadOnlyGameSettings settings;
    private List<FXGLListener> systemListeners = new ArrayList<FXGLListener>();

    void injectStage(Stage stage) {
        this.primaryStage = stage;
    }

    public final Stage getPrimaryStage() {
        return this.primaryStage;
    }

    void injectSettings(ReadOnlyGameSettings settings) {
        this.settings = settings;
    }

    public final ReadOnlyGameSettings getSettings() {
        return this.settings;
    }

    public final void addFXGLListener(FXGLListener listener2) {
        this.systemListeners.add(listener2);
    }

    public final void removeFXGLListener(FXGLListener listener2) {
        this.systemListeners.remove(listener2);
    }

    void runTask(Class<? extends Runnable> type) {
        log.debug("Running task: " + type.getSimpleName());
        FXGL.getInstance(type).run();
    }

    public final void init() throws Exception {
        Version.print();
    }

    public final void start(Stage primaryStage) throws Exception {
        this.primaryStage = primaryStage;
        this.showPreloadingStage();
        primaryStage.setScene(new Scene((Parent)new Pane()));
        this.startFXGL();
    }

    private void startFXGL() {
        new Thread(() -> {
            try {
                this.configureFXGL();
                this.runUpdaterAndWait();
                this.configureApp();
            }
            catch (Exception e) {
                log.fatal("Exception during system configuration:");
                log.fatal(FXGLLogger.errorTraceAsString((Throwable)e));
                log.fatal("System will now exit");
                log.close();
                System.exit(-1);
            }
            Platform.runLater(() -> ((Stage)this.primaryStage).show());
        }, "FXGL Launcher Thread").start();
    }

    private void runUpdaterAndWait() {
        Async.startFX(() -> this.runTask(UpdaterTask.class)).await();
    }

    public final void stop() {
    }

    private void showPreloadingStage() {
        Stage preloadingStage = new Stage(StageStyle.UNDECORATED);
        preloadingStage.initOwner((Window)this.primaryStage);
        preloadingStage.setScene((Scene)new PreloadingScene());
        preloadingStage.show();
        this.primaryStage.setOnShowing(e -> {
            preloadingStage.close();
            this.primaryStage.setOnShowing(null);
        });
    }

    private void configureFXGL() {
        long start2 = System.nanoTime();
        this.initSystemProperties();
        this.initUserProperties();
        this.initAppSettings();
        FXGL.configure(new ApplicationModule((GameApplication)this), new Module[0]);
        log = FXGLLogger.get(FXGLApplication.class);
        log.debug("FXGL configuration complete");
        log.infof("FXGL configuration took:  %.3f sec", new Object[]{(double)(System.nanoTime() - start2) / 1.0E9});
        log.debug("Logging game settings\n" + this.settings.toString());
    }

    abstract void configureApp();

    protected final void pause() {
        log.debug("Pausing main loop");
        this.systemListeners.forEach(FXGLListener::onPause);
        this.getEventBus().fireEvent(FXGLEvent.pause());
    }

    protected final void resume() {
        log.debug("Resuming main loop");
        this.systemListeners.forEach(FXGLListener::onResume);
        this.getEventBus().fireEvent(FXGLEvent.resume());
    }

    protected final void reset() {
        log.debug("Resetting FXGL application");
        this.systemListeners.forEach(FXGLListener::onReset);
        this.getEventBus().fireEvent(FXGLEvent.reset());
        System.gc();
    }

    protected final void exit() {
        log.debug("Exiting FXGL application");
        this.systemListeners.forEach(FXGLListener::onExit);
        this.getEventBus().fireEvent(FXGLEvent.exit());
        FXGL.destroy();
        log.debug("Closing FXGL logger and exiting JavaFX");
        log.close();
        Platform.exit();
    }

    private void initSystemProperties() {
        ResourceBundle props = ResourceBundle.getBundle("com.almasb.fxgl.app.system");
        props.keySet().forEach(key -> {
            Object value = props.getObject((String)key);
            FXGL.setProperty(key, value);
        });
    }

    private void initUserProperties() {
        try (InputStream is2 = ((Object)((Object)this)).getClass().getResource("/assets/properties/system.properties").openStream();){
            PropertyResourceBundle props = new PropertyResourceBundle(is2);
            props.keySet().forEach(key -> {
                Object value = props.getObject((String)key);
                FXGL.setProperty(key, value);
            });
        }
        catch (NullPointerException is2) {
        }
        catch (IOException e) {
            log.warning("Loading user properties failed: " + e);
        }
    }

    private void initAppSettings() {
        GameSettings localSettings = new GameSettings();
        this.initSettings(localSettings);
        this.settings = localSettings.toReadOnly();
    }

    protected abstract void initSettings(GameSettings var1);

    public final int getWidth() {
        return this.getSettings().getWidth();
    }

    public final int getHeight() {
        return this.getSettings().getHeight();
    }

    public final Rectangle2D getAppBounds() {
        return new Rectangle2D(0.0, 0.0, (double)this.getWidth(), (double)this.getHeight());
    }

    public final long getTick() {
        return this.getMasterTimer().getTick();
    }

    public final long getNow() {
        return this.getMasterTimer().getNow();
    }

    public final EventBus getEventBus() {
        return FXGL.getEventBus();
    }

    public final Display getDisplay() {
        return FXGL.getDisplay();
    }

    public final Input getInput() {
        return FXGL.getInput();
    }

    public final AudioPlayer getAudioPlayer() {
        return FXGL.getAudioPlayer();
    }

    public final AssetLoader getAssetLoader() {
        return FXGL.getAssetLoader();
    }

    public final MasterTimer getMasterTimer() {
        return FXGL.getMasterTimer();
    }

    public final Executor getExecutor() {
        return FXGL.getExecutor();
    }

    public final NotificationService getNotificationService() {
        return FXGL.getNotificationService();
    }

    public final AchievementManager getAchievementManager() {
        return FXGL.getAchievementManager();
    }

    public final QTE getQTE() {
        return FXGL.getQTE();
    }

    public final Net getNet() {
        return FXGL.getNet();
    }

    public final ExceptionHandler getExceptionHandler() {
        return FXGL.getExceptionHandler();
    }

    public final UIFactory getUIFactory() {
        return FXGL.getUIFactory();
    }

    public final QuestService getQuestService() {
        return FXGL.getQuestManager();
    }
}

