/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.app;

import com.almasb.fxgl.app.ApplicationState;
import com.almasb.fxgl.app.FXGL;
import com.almasb.fxgl.app.GameApplication;
import com.almasb.fxgl.app.InitEventHandlersTask;
import com.almasb.fxgl.app.MenuEventHandler;
import com.almasb.fxgl.asset.FXGLAssets;
import com.almasb.fxgl.core.logging.Logger;
import com.almasb.fxgl.gameplay.AchievementEvent;
import com.almasb.fxgl.gameplay.NotificationEvent;
import com.almasb.fxgl.saving.LoadEvent;
import com.almasb.fxgl.saving.SaveEvent;
import com.almasb.fxgl.scene.DisplayEvent;
import com.almasb.fxgl.scene.menu.MenuEventListener;
import com.almasb.fxgl.service.EventBus;
import com.almasb.fxgl.service.MasterTimer;
import com.almasb.fxgl.service.ServiceType;
import com.almasb.fxgl.service.listener.AchievementListener;
import com.almasb.fxgl.service.listener.FXGLListener;
import com.almasb.fxgl.service.listener.NotificationListener;
import com.almasb.fxgl.service.listener.UserProfileSavable;
import com.almasb.fxgl.time.UpdateEvent;
import com.almasb.fxgl.time.UpdateEventListener;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javafx.animation.AnimationTimer;
import javafx.event.EventHandler;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.effect.BlendMode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\b\u001a\u00020\tH\u0002J\b\u0010\n\u001a\u00020\tH\u0002J\b\u0010\u000b\u001a\u00020\tH\u0002J\b\u0010\f\u001a\u00020\tH\u0002J\b\u0010\r\u001a\u00020\tH\u0016J\b\u0010\u000e\u001a\u00020\tH\u0002J\b\u0010\u000f\u001a\u00020\tH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/almasb/fxgl/app/InitEventHandlersTask;", "Ljava/lang/Runnable;", "app", "Lcom/almasb/fxgl/app/GameApplication;", "(Lcom/almasb/fxgl/app/GameApplication;)V", "log", "Lcom/almasb/fxgl/core/logging/Logger;", "kotlin.jvm.PlatformType", "displayEvents", "", "gameSceneEvents", "gameWorldEvents", "postUpdateEvents", "run", "scanForServiceListeners", "updateEvents", "fxgl"})
public final class InitEventHandlersTask
implements Runnable {
    private final Logger log;
    private final GameApplication app;

    @Override
    public void run() {
        EventBus bus = this.app.getEventBus();
        this.updateEvents();
        this.postUpdateEvents();
        this.scanForServiceListeners();
        this.gameWorldEvents();
        this.gameSceneEvents();
        this.displayEvents();
        bus.scanForHandlers((Object)this.app);
        if (this.app.getSettings().isMenuEnabled()) {
            MenuEventListener menuEventListener = this.app.getMenuListener();
            if (menuEventListener == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.almasb.fxgl.app.MenuEventHandler");
            }
            ((MenuEventHandler)menuEventListener).generateDefaultProfile$fxgl();
        }
    }

    private final void updateEvents() {
        Font fpsFont = FXGLAssets.UI_MONO_FONT.newFont(20.0);
        this.app.getMasterTimer().addUpdateListener(this.app.getInput());
        this.app.getMasterTimer().addUpdateListener(this.app.getAudioPlayer());
        this.app.getMasterTimer().addUpdateListener(this.app.gameWorld);
        this.app.getMasterTimer().addUpdateListener(new UpdateEventListener(this, fpsFont){
            final /* synthetic */ InitEventHandlersTask this$0;
            final /* synthetic */ Font $fpsFont;

            public final void onUpdateEvent(UpdateEvent event) {
                InitEventHandlersTask.access$getApp$p(this.this$0).onUpdate(event.tpf());
                if (InitEventHandlersTask.access$getApp$p(this.this$0).getSettings().isProfilingEnabled()) {
                    GraphicsContext g = InitEventHandlersTask.access$getApp$p((InitEventHandlersTask)this.this$0).gameScene.getGraphicsContext();
                    g.setGlobalBlendMode(BlendMode.SRC_OVER);
                    g.setGlobalAlpha(1.0);
                    g.setFont(this.$fpsFont);
                    g.setFill((Paint)Color.RED);
                    g.fillText(InitEventHandlersTask.access$getApp$p((InitEventHandlersTask)this.this$0).profiler.getInfo(), 0.0, (double)InitEventHandlersTask.access$getApp$p(this.this$0).getHeight() - 120.0);
                }
            }
            {
                this.this$0 = initEventHandlersTask;
                this.$fpsFont = font;
            }
        });
    }

    private final void postUpdateEvents() {
        AnimationTimer postUpdateTimer2 = new AnimationTimer(this){
            final /* synthetic */ InitEventHandlersTask this$0;

            public void handle(long now) {
                InitEventHandlersTask.access$getApp$p(this.this$0).onPostUpdate(InitEventHandlersTask.access$getApp$p(this.this$0).getMasterTimer().tpf());
            }
            {
                this.this$0 = $outer;
            }
        };
        this.app.addFXGLListener(new FXGLListener(this, postUpdateTimer2){
            final /* synthetic */ InitEventHandlersTask this$0;
            final /* synthetic */ postUpdateEvents.postUpdateTimer.1 $postUpdateTimer;

            public void onPause() {
                this.$postUpdateTimer.stop();
                InitEventHandlersTask.access$getApp$p(this.this$0).setState(ApplicationState.PAUSED);
            }

            public void onResume() {
                this.$postUpdateTimer.start();
                InitEventHandlersTask.access$getApp$p(this.this$0).setState(ApplicationState.PLAYING);
            }

            public void onReset() {
                InitEventHandlersTask.access$getApp$p(this.this$0).getGameWorld().reset();
            }

            public void onExit() {
            }
            {
                this.this$0 = $outer;
                this.$postUpdateTimer = $captured_local_variable$1;
            }
        });
    }

    private final void scanForServiceListeners() {
        Object instance;
        Object it;
        Object element$iv$iv;
        Class clazz;
        Class it2;
        Collection collection;
        Object item$iv$iv;
        Object $receiver$iv$iv;
        this.log.debug("scanForServiceListeners");
        EventBus bus = this.app.getEventBus();
        List<ServiceType<?>> services = FXGL.Companion.getServices();
        Iterable $receiver$iv = services;
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        Iterator iterator = $receiver$iv$iv.iterator();
        while (iterator.hasNext()) {
            item$iv$iv = iterator.next();
            ServiceType serviceType = (ServiceType)item$iv$iv;
            collection = destination$iv$iv;
            clazz = it2.service();
            collection.add(clazz);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList();
        iterator = $receiver$iv$iv.iterator();
        while (iterator.hasNext()) {
            element$iv$iv = iterator.next();
            it2 = (Class)element$iv$iv;
            if (!ArraysKt.contains((Object[])it2.getInterfaces(), FXGLListener.class)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        for (Object element$iv : $receiver$iv) {
            it = (Class)element$iv;
            this.log.debug("FXGLListener: " + it);
            Iterator iterator2 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)iterator2, (String)"it");
            Object t = FXGL.Companion.getInstance(iterator2);
            if (t == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.almasb.fxgl.service.listener.FXGLListener");
            }
            this.app.addFXGLListener((FXGLListener)t);
        }
        $receiver$iv = services;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        it = $receiver$iv$iv.iterator();
        while (it.hasNext()) {
            item$iv$iv = it.next();
            ServiceType $i$f$forEach = (ServiceType)item$iv$iv;
            collection = destination$iv$iv;
            clazz = it2.service();
            collection.add(clazz);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList();
        it = $receiver$iv$iv.iterator();
        while (it.hasNext()) {
            element$iv$iv = it.next();
            it2 = (Class)element$iv$iv;
            if (!ArraysKt.contains((Object[])it2.getInterfaces(), UserProfileSavable.class)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        for (Object element$iv : $receiver$iv) {
            it = (Class)element$iv;
            this.log.debug("UserProfileSavable: " + it);
            Iterator iterator3 = it;
            Intrinsics.checkExpressionValueIsNotNull(iterator3, (String)"it");
            Object t = FXGL.Companion.getInstance(iterator3);
            if (t == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.almasb.fxgl.service.listener.UserProfileSavable");
            }
            instance = (UserProfileSavable)t;
            bus.addEventHandler(SaveEvent.ANY, (EventHandler)new EventHandler<SaveEvent>((UserProfileSavable)instance){
                final /* synthetic */ UserProfileSavable $instance;

                public final void handle(SaveEvent it) {
                    this.$instance.save(it.getProfile());
                }
                {
                    this.$instance = userProfileSavable;
                }
            });
            bus.addEventHandler(LoadEvent.ANY, (EventHandler)new EventHandler<LoadEvent>((UserProfileSavable)instance){
                final /* synthetic */ UserProfileSavable $instance;

                public final void handle(LoadEvent it) {
                    if (!(this.$instance instanceof MasterTimer) || !Intrinsics.areEqual((Object)it.getEventType(), LoadEvent.RESTORE_SETTINGS)) {
                        this.$instance.load(it.getProfile());
                    }
                }
                {
                    this.$instance = userProfileSavable;
                }
            });
        }
        $receiver$iv = services;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        it = $receiver$iv$iv.iterator();
        while (it.hasNext()) {
            item$iv$iv = it.next();
            ServiceType $i$a$6$forEach = (ServiceType)item$iv$iv;
            collection = destination$iv$iv;
            clazz = it2.service();
            collection.add(clazz);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList();
        it = $receiver$iv$iv.iterator();
        while (it.hasNext()) {
            element$iv$iv = it.next();
            it2 = (Class)element$iv$iv;
            if (!ArraysKt.contains((Object[])it2.getInterfaces(), NotificationListener.class)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        for (Object element$iv : $receiver$iv) {
            it = (Class)element$iv;
            this.log.debug("NotificationListener: " + it);
            Iterator iterator4 = it;
            Intrinsics.checkExpressionValueIsNotNull(iterator4, (String)"it");
            Object t = FXGL.Companion.getInstance(iterator4);
            if (t == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.almasb.fxgl.service.listener.NotificationListener");
            }
            instance = (NotificationListener)t;
            bus.addEventHandler(NotificationEvent.ANY, (EventHandler)new EventHandler<NotificationEvent>((NotificationListener)instance){
                final /* synthetic */ NotificationListener $instance;

                public final void handle(NotificationEvent it) {
                    this.$instance.onNotificationEvent(it);
                }
                {
                    this.$instance = notificationListener;
                }
            });
        }
        $receiver$iv = services;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        it = $receiver$iv$iv.iterator();
        while (it.hasNext()) {
            item$iv$iv = it.next();
            ServiceType $i$a$9$forEach = (ServiceType)item$iv$iv;
            collection = destination$iv$iv;
            clazz = it2.service();
            collection.add(clazz);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList();
        it = $receiver$iv$iv.iterator();
        while (it.hasNext()) {
            element$iv$iv = it.next();
            it2 = (Class)element$iv$iv;
            if (!ArraysKt.contains((Object[])it2.getInterfaces(), AchievementListener.class)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        for (Object element$iv : $receiver$iv) {
            it = (Class)element$iv;
            this.log.debug("AchievementListener: " + it);
            Object object = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"it");
            Object t = FXGL.Companion.getInstance(object);
            if (t == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.almasb.fxgl.service.listener.AchievementListener");
            }
            instance = (AchievementListener)t;
            bus.addEventHandler(AchievementEvent.ANY, (EventHandler)new EventHandler<AchievementEvent>((AchievementListener)instance){
                final /* synthetic */ AchievementListener $instance;

                public final void handle(AchievementEvent it) {
                    this.$instance.onAchievementEvent(it);
                }
                {
                    this.$instance = achievementListener;
                }
            });
        }
    }

    private final void gameWorldEvents() {
        this.app.getGameWorld().addWorldListener(this.app.getPhysicsWorld());
        this.app.getGameWorld().addWorldListener(this.app.getGameScene());
    }

    private final void gameSceneEvents() {
        this.app.getGameScene().addEventHandler(MouseEvent.ANY, (EventHandler)new EventHandler<MouseEvent>(this){
            final /* synthetic */ InitEventHandlersTask this$0;

            public final void handle(MouseEvent it) {
                InitEventHandlersTask.access$getApp$p(this.this$0).getInput().onMouseEvent(it, InitEventHandlersTask.access$getApp$p(this.this$0).getGameScene().getViewport(), InitEventHandlersTask.access$getApp$p(this.this$0).getDisplay().getScaleRatio());
            }
            {
                this.this$0 = initEventHandlersTask;
            }
        });
        this.app.getGameScene().addEventHandler(KeyEvent.ANY, (EventHandler)new EventHandler<KeyEvent>(this){
            final /* synthetic */ InitEventHandlersTask this$0;

            public final void handle(KeyEvent it) {
                InitEventHandlersTask.access$getApp$p(this.this$0).getInput().onKeyEvent(it);
            }
            {
                this.this$0 = initEventHandlersTask;
            }
        });
    }

    private final void displayEvents() {
        EventBus bus = this.app.getEventBus();
        bus.addEventHandler(DisplayEvent.CLOSE_REQUEST, (EventHandler)new EventHandler<DisplayEvent>(this){
            final /* synthetic */ InitEventHandlersTask this$0;

            public final void handle(DisplayEvent e) {
                InitEventHandlersTask.access$getApp$p(this.this$0).exit();
            }
            {
                this.this$0 = initEventHandlersTask;
            }
        });
        bus.addEventHandler(DisplayEvent.DIALOG_OPENED, (EventHandler)new EventHandler<DisplayEvent>(this){
            final /* synthetic */ InitEventHandlersTask this$0;

            public final void handle(DisplayEvent e) {
                if (InitEventHandlersTask.access$getApp$p(this.this$0).getState() == ApplicationState.INTRO || InitEventHandlersTask.access$getApp$p(this.this$0).getState() == ApplicationState.LOADING) {
                    return;
                }
                if (!InitEventHandlersTask.access$getApp$p(this.this$0).isMenuOpen()) {
                    InitEventHandlersTask.access$getApp$p(this.this$0).pause();
                }
                InitEventHandlersTask.access$getApp$p(this.this$0).getInput().onReset();
            }
            {
                this.this$0 = initEventHandlersTask;
            }
        });
        bus.addEventHandler(DisplayEvent.DIALOG_CLOSED, (EventHandler)new EventHandler<DisplayEvent>(this){
            final /* synthetic */ InitEventHandlersTask this$0;

            public final void handle(DisplayEvent e) {
                if (InitEventHandlersTask.access$getApp$p(this.this$0).getState() == ApplicationState.INTRO || InitEventHandlersTask.access$getApp$p(this.this$0).getState() == ApplicationState.LOADING) {
                    return;
                }
                if (!InitEventHandlersTask.access$getApp$p(this.this$0).isMenuOpen()) {
                    InitEventHandlersTask.access$getApp$p(this.this$0).resume();
                }
            }
            {
                this.this$0 = initEventHandlersTask;
            }
        });
    }

    @Inject
    public InitEventHandlersTask(@NotNull GameApplication app) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)app), (String)"app");
        this.app = app;
        this.log = FXGL.Companion.getLogger(this.getClass());
    }

    @NotNull
    public static final /* synthetic */ GameApplication access$getApp$p(InitEventHandlersTask $this) {
        return $this.app;
    }
}

