/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.app;

import com.almasb.fxgl.app.ApplicationState;
import com.almasb.fxgl.app.FXGL;
import com.almasb.fxgl.app.FXGLEvent;
import com.almasb.fxgl.app.GameApplication;
import com.almasb.fxgl.app.MenuEventHandler;
import com.almasb.fxgl.core.logging.Logger;
import com.almasb.fxgl.io.IOTask;
import com.almasb.fxgl.io.UIDialogHandler;
import com.almasb.fxgl.net.Client;
import com.almasb.fxgl.net.Server;
import com.almasb.fxgl.saving.DataFile;
import com.almasb.fxgl.saving.LoadEvent;
import com.almasb.fxgl.saving.SaveEvent;
import com.almasb.fxgl.saving.SaveFile;
import com.almasb.fxgl.saving.SaveLoadManager;
import com.almasb.fxgl.scene.ProgressDialog;
import com.almasb.fxgl.scene.menu.MenuEventListener;
import com.almasb.fxgl.scene.menu.ProfileSelectedEvent;
import com.almasb.fxgl.service.EventBus;
import com.almasb.fxgl.service.impl.display.DialogPane;
import com.almasb.fxgl.settings.UserProfile;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import javafx.beans.property.ReadOnlyStringProperty;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ChoiceBox;
import javafx.scene.input.KeyEvent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u0012\u001a\u00020\nJ\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\r\u0010\u0017\u001a\u00020\u0014H\u0000\u00a2\u0006\u0002\b\u0018J\b\u0010\u0019\u001a\u00020\u0011H\u0016J\u0010\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u0003H\u0016J\u0006\u0010\u001c\u001a\u00020\bJ\u000e\u0010\u001d\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\nJ\b\u0010\u001f\u001a\u00020\u0014H\u0016J\u0010\u0010 \u001a\u00020\u00142\u0006\u0010!\u001a\u00020\"H\u0016J\b\u0010#\u001a\u00020\u0014H\u0016J\b\u0010$\u001a\u00020\u0014H\u0016J\u0010\u0010%\u001a\u00020\u00142\u0006\u0010!\u001a\u00020\"H\u0016J\b\u0010&\u001a\u00020\u0014H\u0016J\u0010\u0010'\u001a\u00020\u00142\u0006\u0010(\u001a\u00020\bH\u0002J\b\u0010)\u001a\u00020\u0014H\u0016J\b\u0010*\u001a\u00020\u0014H\u0016J\b\u0010+\u001a\u00020\u0014H\u0016J\b\u0010,\u001a\u00020\u0014H\u0016J\b\u0010-\u001a\u00020.H\u0016J\b\u0010/\u001a\u00020\u0014H\u0016J\u0006\u00100\u001a\u00020\u0014J\b\u00101\u001a\u00020\u0014H\u0002J\u0006\u00102\u001a\u00020\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lcom/almasb/fxgl/app/MenuEventHandler;", "Lcom/almasb/fxgl/scene/menu/MenuEventListener;", "Ljavafx/event/EventHandler;", "Ljavafx/scene/input/KeyEvent;", "app", "Lcom/almasb/fxgl/app/GameApplication;", "(Lcom/almasb/fxgl/app/GameApplication;)V", "canSwitchGameMenu", "", "defaultProfile", "Lcom/almasb/fxgl/settings/UserProfile;", "log", "Lcom/almasb/fxgl/core/logging/Logger;", "kotlin.jvm.PlatformType", "profileName", "Ljavafx/beans/property/ReadOnlyStringWrapper;", "saveLoadManager", "Lcom/almasb/fxgl/saving/SaveLoadManager;", "createProfile", "doSave", "", "saveFileName", "", "generateDefaultProfile", "generateDefaultProfile$fxgl", "getSaveLoadManager", "handle", "event", "isProfileSelected", "loadFromProfile", "profile", "onContinue", "onDelete", "saveFile", "Lcom/almasb/fxgl/saving/SaveFile;", "onExit", "onExitToMainMenu", "onLoad", "onLogout", "onMenuKey", "pressed", "onMultiplayer", "onNewGame", "onResume", "onSave", "profileNameProperty", "Ljavafx/beans/property/ReadOnlyStringProperty;", "restoreDefaultSettings", "saveProfile", "showMultiplayerDialog", "showProfileDialog", "fxgl"})
public final class MenuEventHandler
implements MenuEventListener,
EventHandler<KeyEvent> {
    private final Logger log;
    private SaveLoadManager saveLoadManager;
    private UserProfile defaultProfile;
    private final ReadOnlyStringWrapper profileName;
    private boolean canSwitchGameMenu;
    private final GameApplication app;

    @Override
    @NotNull
    public SaveLoadManager getSaveLoadManager() {
        SaveLoadManager saveLoadManager = this.saveLoadManager;
        if (saveLoadManager == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"saveLoadManager");
        }
        return saveLoadManager;
    }

    public final boolean isProfileSelected() {
        CharSequence charSequence = this.profileName.getValue();
        return charSequence.length() > 0;
    }

    public final void generateDefaultProfile$fxgl() {
        this.log.debug("generateDefaultProfile()");
        this.defaultProfile = this.createProfile();
    }

    @Override
    public void onNewGame() {
        this.app.startNewGame();
    }

    @Override
    public void onContinue() {
        SaveLoadManager saveLoadManager = this.saveLoadManager;
        if (saveLoadManager == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"saveLoadManager");
        }
        saveLoadManager.loadLastModifiedSaveFileTask().then((Function1)new Function1<SaveFile, IOTask<DataFile>>(this){
            final /* synthetic */ MenuEventHandler this$0;

            public final IOTask<DataFile> invoke(SaveFile it) {
                return MenuEventHandler.access$getSaveLoadManager$p(this.this$0).loadTask(it);
            }
            {
                this.this$0 = menuEventHandler;
                super(1);
            }
        }).onSuccessKt((Function1)new Function1<DataFile, Unit>(this){
            final /* synthetic */ MenuEventHandler this$0;

            public final void invoke(DataFile it) {
                MenuEventHandler.access$getApp$p(this.this$0).startLoadedGame(it);
            }
            {
                this.this$0 = menuEventHandler;
                super(1);
            }
        }).executeAsyncWithDialogFX((UIDialogHandler)new ProgressDialog("Loading..."));
    }

    @Override
    public void onResume() {
        this.app.resume();
    }

    private final void doSave(String saveFileName) {
        DataFile dataFile = this.app.saveState();
        LocalDateTime localDateTime = LocalDateTime.now();
        Intrinsics.checkExpressionValueIsNotNull((Object)localDateTime, (String)"LocalDateTime.now()");
        SaveFile saveFile = new SaveFile(saveFileName, localDateTime);
        SaveLoadManager saveLoadManager = this.saveLoadManager;
        if (saveLoadManager == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"saveLoadManager");
        }
        saveLoadManager.saveTask(dataFile, saveFile).executeAsyncWithDialogFX((UIDialogHandler)new ProgressDialog("Saving data: " + saveFileName));
    }

    @Override
    public void onSave() {
        this.app.getDisplay().showInputBoxWithCancel("Enter save file name", DialogPane.ALPHANUM, new Consumer<String>(this){
            final /* synthetic */ MenuEventHandler this$0;

            public final void accept(String saveFileName) {
                CharSequence charSequence = saveFileName;
                if (charSequence.length() == 0) {
                    return;
                }
                if (MenuEventHandler.access$getSaveLoadManager$p(this.this$0).saveFileExists(saveFileName)) {
                    MenuEventHandler.access$getApp$p(this.this$0).getDisplay().showConfirmationBox("Overwrite save [" + saveFileName + "]?", new Consumer<Boolean>(this, saveFileName){
                        final /* synthetic */ onSave.1 this$0;
                        final /* synthetic */ String $saveFileName;

                        public final void accept(Boolean yes) {
                            Boolean bl = yes;
                            Intrinsics.checkExpressionValueIsNotNull((Object)bl, (String)"yes");
                            if (bl.booleanValue()) {
                                MenuEventHandler menuEventHandler = this.this$0.this$0;
                                String string = this.$saveFileName;
                                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"saveFileName");
                                MenuEventHandler.access$doSave(menuEventHandler, string);
                            }
                        }
                        {
                            this.this$0 = var1_1;
                            this.$saveFileName = string;
                        }
                    });
                } else {
                    String string = saveFileName;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"saveFileName");
                    MenuEventHandler.access$doSave(this.this$0, string);
                }
            }
            {
                this.this$0 = menuEventHandler;
            }
        });
    }

    @Override
    public void onLoad(@NotNull SaveFile saveFile) {
        Intrinsics.checkParameterIsNotNull((Object)saveFile, (String)"saveFile");
        this.app.getDisplay().showConfirmationBox("Load save [" + saveFile.getName() + "]?" + "\n" + "Unsaved progress will be lost!", new Consumer<Boolean>(this, saveFile){
            final /* synthetic */ MenuEventHandler this$0;
            final /* synthetic */ SaveFile $saveFile;

            public final void accept(Boolean yes) {
                Boolean bl = yes;
                Intrinsics.checkExpressionValueIsNotNull((Object)bl, (String)"yes");
                if (bl.booleanValue()) {
                    MenuEventHandler.access$getSaveLoadManager$p(this.this$0).loadTask(this.$saveFile).onSuccessKt((Function1)new Function1<DataFile, Unit>(this){
                        final /* synthetic */ onLoad.1 this$0;

                        public final void invoke(DataFile it) {
                            MenuEventHandler.access$getApp$p(this.this$0.this$0).startLoadedGame(it);
                        }
                        {
                            this.this$0 = var1_1;
                            super(1);
                        }
                    }).executeAsyncWithDialogFX((UIDialogHandler)new ProgressDialog("Loading: " + this.$saveFile.getName()));
                }
            }
            {
                this.this$0 = menuEventHandler;
                this.$saveFile = saveFile;
            }
        });
    }

    @Override
    public void onDelete(@NotNull SaveFile saveFile) {
        Intrinsics.checkParameterIsNotNull((Object)saveFile, (String)"saveFile");
        this.app.getDisplay().showConfirmationBox("Delete save [" + saveFile.getName() + "]?", new Consumer<Boolean>(this, saveFile){
            final /* synthetic */ MenuEventHandler this$0;
            final /* synthetic */ SaveFile $saveFile;

            public final void accept(Boolean yes) {
                Boolean bl = yes;
                Intrinsics.checkExpressionValueIsNotNull((Object)bl, (String)"yes");
                if (bl.booleanValue()) {
                    MenuEventHandler.access$getSaveLoadManager$p(this.this$0).deleteSaveFileTask(this.$saveFile).executeAsyncWithDialogFX((UIDialogHandler)new ProgressDialog("Deleting: " + this.$saveFile.getName()));
                }
            }
            {
                this.this$0 = menuEventHandler;
                this.$saveFile = saveFile;
            }
        });
    }

    @Override
    public void onLogout() {
        this.app.getDisplay().showConfirmationBox("Log out?", new Consumer<Boolean>(this){
            final /* synthetic */ MenuEventHandler this$0;

            public final void accept(Boolean yes) {
                Boolean bl = yes;
                Intrinsics.checkExpressionValueIsNotNull((Object)bl, (String)"yes");
                if (bl.booleanValue()) {
                    this.this$0.saveProfile();
                    this.this$0.showProfileDialog();
                }
            }
            {
                this.this$0 = menuEventHandler;
            }
        });
    }

    @Override
    public void onMultiplayer() {
        this.showMultiplayerDialog();
    }

    @Override
    public void onExit() {
        this.app.getDisplay().showConfirmationBox("Exit the game?", new Consumer<Boolean>(this){
            final /* synthetic */ MenuEventHandler this$0;

            public final void accept(Boolean yes) {
                Boolean bl = yes;
                Intrinsics.checkExpressionValueIsNotNull((Object)bl, (String)"yes");
                if (bl.booleanValue()) {
                    MenuEventHandler.access$getApp$p(this.this$0).exit();
                }
            }
            {
                this.this$0 = menuEventHandler;
            }
        });
    }

    @Override
    public void onExitToMainMenu() {
        this.app.getDisplay().showConfirmationBox("Exit to Main Menu?\nUnsaved progress will be lost!", new Consumer<Boolean>(this){
            final /* synthetic */ MenuEventHandler this$0;

            public final void accept(Boolean yes) {
                Boolean bl = yes;
                Intrinsics.checkExpressionValueIsNotNull((Object)bl, (String)"yes");
                if (bl.booleanValue()) {
                    MenuEventHandler.access$getApp$p(this.this$0).pause();
                    MenuEventHandler.access$getApp$p(this.this$0).reset();
                    MenuEventHandler.access$getApp$p(this.this$0).setState(ApplicationState.MAIN_MENU);
                }
            }
            {
                this.this$0 = menuEventHandler;
            }
        });
    }

    private final void onMenuKey(boolean pressed) {
        if (!pressed) {
            this.canSwitchGameMenu = true;
            return;
        }
        if (this.canSwitchGameMenu) {
            if (this.app.getState() == ApplicationState.GAME_MENU) {
                this.canSwitchGameMenu = false;
                this.app.resume();
            } else if (this.app.getState() == ApplicationState.PLAYING) {
                this.canSwitchGameMenu = false;
                this.app.pause();
                this.app.setState(ApplicationState.GAME_MENU);
            } else {
                this.log.warning("Menu key pressed in unknown state: " + (Object)((Object)this.app.getState()));
            }
        }
    }

    public void handle(@NotNull KeyEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        if (Intrinsics.areEqual((Object)event.getCode(), (Object)FXGL.Companion.getSettings().getMenuKey())) {
            this.onMenuKey(Intrinsics.areEqual((Object)event.getEventType(), (Object)KeyEvent.KEY_PRESSED));
        }
    }

    @Override
    @NotNull
    public ReadOnlyStringProperty profileNameProperty() {
        ReadOnlyStringProperty readOnlyStringProperty = this.profileName.getReadOnlyProperty();
        Intrinsics.checkExpressionValueIsNotNull((Object)readOnlyStringProperty, (String)"profileName.readOnlyProperty");
        return readOnlyStringProperty;
    }

    @NotNull
    public final UserProfile createProfile() {
        this.log.debug("Creating default profile");
        UserProfile profile = new UserProfile(this.app.getSettings().getTitle(), this.app.getSettings().getVersion());
        this.app.getEventBus().fireEvent(new SaveEvent(profile));
        return profile;
    }

    public final boolean loadFromProfile(@NotNull UserProfile profile) {
        Intrinsics.checkParameterIsNotNull((Object)profile, (String)"profile");
        if (!profile.isCompatible(this.app.getSettings().getTitle(), this.app.getSettings().getVersion())) {
            return false;
        }
        this.app.getEventBus().fireEvent(new LoadEvent(LoadEvent.LOAD_PROFILE, profile));
        return true;
    }

    @Override
    public void restoreDefaultSettings() {
        this.log.debug("restoreDefaultSettings()");
        EventBus eventBus = this.app.getEventBus();
        UserProfile userProfile = this.defaultProfile;
        if (userProfile == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"defaultProfile");
        }
        eventBus.fireEvent(new LoadEvent(LoadEvent.RESTORE_SETTINGS, userProfile));
    }

    public final void saveProfile() {
        CharSequence charSequence = this.profileName.get();
        if (!(charSequence.length() == 0)) {
            SaveLoadManager saveLoadManager = this.saveLoadManager;
            if (saveLoadManager == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"saveLoadManager");
            }
            saveLoadManager.saveProfileTask(this.createProfile()).onFailureKt((Function1)new Function1<Throwable, Unit>(this){
                final /* synthetic */ MenuEventHandler this$0;

                public final void invoke(@NotNull Throwable error) {
                    Intrinsics.checkParameterIsNotNull((Object)error, (String)"error");
                    MenuEventHandler.access$getLog$p(this.this$0).warning("Failed to save profile: " + MenuEventHandler.access$getProfileName$p(this.this$0).getValue() + " - " + error);
                }
                {
                    this.this$0 = menuEventHandler;
                    super(1);
                }
            }).execute();
        }
    }

    private final void showMultiplayerDialog() {
        Button btnHost = FXGL.Companion.getUIFactory().newButton("Host");
        btnHost.setOnAction((EventHandler)new EventHandler<ActionEvent>(this){
            final /* synthetic */ MenuEventHandler this$0;

            public final void handle(ActionEvent it) {
                FXGL.Companion.getNet().hostMultiplayerTask().onSuccessKt((Function1)new Function1<Server, Unit>(this){
                    final /* synthetic */ showMultiplayerDialog.1 this$0;

                    public final void invoke(Server it) {
                        this.this$0.this$0.onNewGame();
                    }
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }
                }).onFailureKt((Function1)new Function1<Throwable, Unit>(this){
                    final /* synthetic */ showMultiplayerDialog.1 this$0;

                    public final void invoke(@NotNull Throwable it) {
                        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                        MenuEventHandler.access$getApp$p(this.this$0.this$0).getDisplay().showErrorBox(it);
                    }
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }
                }).executeAsyncWithDialogFX((UIDialogHandler)new ProgressDialog("Hosting Game"));
            }
            {
                this.this$0 = menuEventHandler;
            }
        });
        Button btnConnect = FXGL.Companion.getUIFactory().newButton("Connect...");
        btnConnect.setOnAction((EventHandler)new EventHandler<ActionEvent>(this){
            final /* synthetic */ MenuEventHandler this$0;

            public final void handle(ActionEvent it) {
                MenuEventHandler.access$getApp$p(this.this$0).getDisplay().showInputBox("Enter Server IP", new Consumer<String>(this){
                    final /* synthetic */ showMultiplayerDialog.2 this$0;

                    public final void accept(String it) {
                        FXGL.Companion.getNet().connectMultiplayerTask(it).onSuccessKt((Function1)new Function1<Client, Unit>(this){
                            final /* synthetic */ showMultiplayerDialog.1 this$0;

                            public final void invoke(Client it) {
                                this.this$0.this$0.this$0.onNewGame();
                            }
                            {
                                this.this$0 = var1_1;
                                super(1);
                            }
                        }).executeAsyncWithDialogFX((UIDialogHandler)new ProgressDialog("Connecting to Game"));
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }
            {
                this.this$0 = menuEventHandler;
            }
        });
        this.app.getDisplay().showBox("Multiplayer Options", (Node)FXGL.Companion.getUIFactory().newText(""), btnHost, btnConnect);
    }

    public final void showProfileDialog() {
        ChoiceBox profilesBox = FXGL.Companion.getUIFactory().newChoiceBox(FXCollections.observableArrayList());
        Button btnNew = FXGL.Companion.getUIFactory().newButton("NEW");
        Button btnSelect = FXGL.Companion.getUIFactory().newButton("SELECT");
        btnSelect.disableProperty().bind((ObservableValue)profilesBox.valueProperty().isNull());
        Button btnDelete = FXGL.Companion.getUIFactory().newButton("DELETE");
        btnDelete.disableProperty().bind((ObservableValue)profilesBox.valueProperty().isNull());
        btnNew.setOnAction((EventHandler)new EventHandler<ActionEvent>(this){
            final /* synthetic */ MenuEventHandler this$0;

            public final void handle(ActionEvent it) {
                MenuEventHandler.access$getApp$p(this.this$0).getDisplay().showInputBox("New Profile", DialogPane.ALPHANUM, new Consumer<String>(this){
                    final /* synthetic */ showProfileDialog.1 this$0;

                    public final void accept(String name) {
                        MenuEventHandler.access$getProfileName$p(this.this$0.this$0).set(name);
                        MenuEventHandler.access$setSaveLoadManager$p(this.this$0.this$0, new SaveLoadManager(name));
                        MenuEventHandler.access$getApp$p(this.this$0.this$0).getEventBus().fireEvent(new ProfileSelectedEvent(name, false));
                        this.this$0.this$0.saveProfile();
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }
            {
                this.this$0 = menuEventHandler;
            }
        });
        btnSelect.setOnAction((EventHandler)new EventHandler<ActionEvent>(this, profilesBox){
            final /* synthetic */ MenuEventHandler this$0;
            final /* synthetic */ ChoiceBox $profilesBox;

            public final void handle(ActionEvent it) {
                String name = (String)this.$profilesBox.getValue();
                MenuEventHandler.access$setSaveLoadManager$p(this.this$0, new SaveLoadManager(name));
                MenuEventHandler.access$getSaveLoadManager$p(this.this$0).loadProfileTask().onSuccessKt((Function1)new Function1<UserProfile, Unit>(this, name){
                    final /* synthetic */ showProfileDialog.2 this$0;
                    final /* synthetic */ String $name;

                    public final void invoke(UserProfile profile) {
                        MenuEventHandler menuEventHandler = this.this$0.this$0;
                        UserProfile userProfile = profile;
                        Intrinsics.checkExpressionValueIsNotNull((Object)userProfile, (String)"profile");
                        boolean ok = menuEventHandler.loadFromProfile(userProfile);
                        if (!ok) {
                            MenuEventHandler.access$getApp$p(this.this$0.this$0).getDisplay().showErrorBox("Profile is corrupted: " + this.$name, new Runnable(this){
                                final /* synthetic */ showProfileDialog.1 this$0;

                                public final void run() {
                                    this.this$0.this$0.this$0.showProfileDialog();
                                }
                                {
                                    this.this$0 = var1_1;
                                }
                            });
                        } else {
                            MenuEventHandler.access$getProfileName$p(this.this$0.this$0).set(this.$name);
                            MenuEventHandler.access$getSaveLoadManager$p(this.this$0.this$0).loadLastModifiedSaveFileTask().onSuccessKt((Function1)new Function1<SaveFile, Unit>(this){
                                final /* synthetic */ showProfileDialog.1 this$0;

                                public final void invoke(SaveFile file) {
                                    MenuEventHandler.access$getApp$p(this.this$0.this$0.this$0).getEventBus().fireEvent(new ProfileSelectedEvent(this.this$0.$name, true));
                                }
                                {
                                    this.this$0 = var1_1;
                                    super(1);
                                }
                            }).onFailureKt((Function1)new Function1<Throwable, Unit>(this){
                                final /* synthetic */ showProfileDialog.1 this$0;

                                public final void invoke(@NotNull Throwable error) {
                                    Intrinsics.checkParameterIsNotNull((Object)error, (String)"error");
                                    MenuEventHandler.access$getApp$p(this.this$0.this$0.this$0).getEventBus().fireEvent(new ProfileSelectedEvent(this.this$0.$name, false));
                                }
                                {
                                    this.this$0 = var1_1;
                                    super(1);
                                }
                            }).executeAsyncWithDialogFX((UIDialogHandler)new ProgressDialog("Loading last save file"));
                        }
                    }
                    {
                        this.this$0 = var1_1;
                        this.$name = string;
                        super(1);
                    }
                }).onFailureKt((Function1)new Function1<Throwable, Unit>(this, name){
                    final /* synthetic */ showProfileDialog.2 this$0;
                    final /* synthetic */ String $name;

                    public final void invoke(@NotNull Throwable error) {
                        Intrinsics.checkParameterIsNotNull((Object)error, (String)"error");
                        MenuEventHandler.access$getApp$p(this.this$0.this$0).getDisplay().showErrorBox("Profile is corrupted: " + this.$name + "\n" + "Error: " + error, new Runnable(this){
                            final /* synthetic */ showProfileDialog.2 this$0;

                            public final void run() {
                                this.this$0.this$0.this$0.showProfileDialog();
                            }
                            {
                                this.this$0 = var1_1;
                            }
                        });
                    }
                    {
                        this.this$0 = var1_1;
                        this.$name = string;
                        super(1);
                    }
                }).executeAsyncWithDialogFX((UIDialogHandler)new ProgressDialog("Loading Profile: " + name));
            }
            {
                this.this$0 = menuEventHandler;
                this.$profilesBox = choiceBox;
            }
        });
        btnDelete.setOnAction((EventHandler)new EventHandler<ActionEvent>(this, profilesBox){
            final /* synthetic */ MenuEventHandler this$0;
            final /* synthetic */ ChoiceBox $profilesBox;

            public final void handle(ActionEvent it) {
                String name = (String)this.$profilesBox.getValue();
                SaveLoadManager.deleteProfileTask(name).onSuccessKt((Function1)new Function1<Void, Unit>(this){
                    final /* synthetic */ showProfileDialog.3 this$0;

                    public final void invoke(Void it) {
                        this.this$0.this$0.showProfileDialog();
                    }
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }
                }).onFailureKt((Function1)new Function1<Throwable, Unit>(this){
                    final /* synthetic */ showProfileDialog.3 this$0;

                    public final void invoke(@NotNull Throwable error) {
                        Intrinsics.checkParameterIsNotNull((Object)error, (String)"error");
                        MenuEventHandler.access$getApp$p(this.this$0.this$0).getDisplay().showErrorBox(String.valueOf(error), new Runnable(this){
                            final /* synthetic */ showProfileDialog.2 this$0;

                            public final void run() {
                                this.this$0.this$0.this$0.showProfileDialog();
                            }
                            {
                                this.this$0 = var1_1;
                            }
                        });
                    }
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }
                }).executeAsyncWithDialogFX((UIDialogHandler)new ProgressDialog("Deleting profile: " + name));
            }
            {
                this.this$0 = menuEventHandler;
                this.$profilesBox = choiceBox;
            }
        });
        SaveLoadManager.loadProfileNamesTask().onSuccessKt((Function1)new Function1<List<String>, Unit>(this, profilesBox, btnSelect, btnNew, btnDelete){
            final /* synthetic */ MenuEventHandler this$0;
            final /* synthetic */ ChoiceBox $profilesBox;
            final /* synthetic */ Button $btnSelect;
            final /* synthetic */ Button $btnNew;
            final /* synthetic */ Button $btnDelete;

            public final void invoke(List<String> names) {
                ObservableList observableList = this.$profilesBox.getItems();
                List<String> list = names;
                Intrinsics.checkExpressionValueIsNotNull(list, (String)"names");
                observableList.addAll((Collection)list);
                if (!this.$profilesBox.getItems().isEmpty()) {
                    this.$profilesBox.getSelectionModel().selectFirst();
                }
                MenuEventHandler.access$getApp$p(this.this$0).getDisplay().showBox("Select profile or create new", (Node)this.$profilesBox, this.$btnSelect, this.$btnNew, this.$btnDelete);
            }
            {
                this.this$0 = menuEventHandler;
                this.$profilesBox = choiceBox;
                this.$btnSelect = button;
                this.$btnNew = button2;
                this.$btnDelete = button3;
                super(1);
            }
        }).onFailureKt((Function1)new Function1<Throwable, Unit>(this, profilesBox, btnSelect, btnNew, btnDelete){
            final /* synthetic */ MenuEventHandler this$0;
            final /* synthetic */ ChoiceBox $profilesBox;
            final /* synthetic */ Button $btnSelect;
            final /* synthetic */ Button $btnNew;
            final /* synthetic */ Button $btnDelete;

            public final void invoke(@NotNull Throwable error) {
                Intrinsics.checkParameterIsNotNull((Object)error, (String)"error");
                MenuEventHandler.access$getLog$p(this.this$0).warning(String.valueOf(error));
                MenuEventHandler.access$getApp$p(this.this$0).getDisplay().showBox("Select profile or create new", (Node)this.$profilesBox, this.$btnSelect, this.$btnNew, this.$btnDelete);
            }
            {
                this.this$0 = menuEventHandler;
                this.$profilesBox = choiceBox;
                this.$btnSelect = button;
                this.$btnNew = button2;
                this.$btnDelete = button3;
                super(1);
            }
        }).executeAsyncWithDialogFX((UIDialogHandler)new ProgressDialog("Loading profiles"));
    }

    public MenuEventHandler(@NotNull GameApplication app) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)app), (String)"app");
        this.app = app;
        this.log = FXGL.Companion.getLogger(this.getClass());
        this.profileName = new ReadOnlyStringWrapper("");
        this.app.getEventBus().addEventHandler(FXGLEvent.EXIT, (EventHandler)new EventHandler<FXGLEvent>(){

            public final void handle(FXGLEvent it) {
                this.saveProfile();
            }
        });
        this.canSwitchGameMenu = true;
    }

    @NotNull
    public static final /* synthetic */ SaveLoadManager access$getSaveLoadManager$p(MenuEventHandler $this) {
        SaveLoadManager saveLoadManager = $this.saveLoadManager;
        if (saveLoadManager == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"saveLoadManager");
        }
        return saveLoadManager;
    }

    public static final /* synthetic */ void access$setSaveLoadManager$p(MenuEventHandler $this, @NotNull SaveLoadManager saveLoadManager) {
        $this.saveLoadManager = saveLoadManager;
    }

    @NotNull
    public static final /* synthetic */ GameApplication access$getApp$p(MenuEventHandler $this) {
        return $this.app;
    }

    public static final /* synthetic */ void access$doSave(MenuEventHandler $this, @NotNull String saveFileName) {
        $this.doSave(saveFileName);
    }

    public static final /* synthetic */ Logger access$getLog$p(MenuEventHandler $this) {
        return $this.log;
    }

    @NotNull
    public static final /* synthetic */ ReadOnlyStringWrapper access$getProfileName$p(MenuEventHandler $this) {
        return $this.profileName;
    }
}

