/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.app;

import com.almasb.fxgl.app.FXGL;
import com.almasb.fxgl.app.GameApplication;
import com.almasb.fxgl.app.SystemActions;
import com.almasb.fxgl.core.logging.Logger;
import com.almasb.fxgl.entity.GameWorld;
import com.almasb.fxgl.io.FXGLIO;
import com.almasb.fxgl.physics.PhysicsWorld;
import com.almasb.fxgl.service.ExceptionHandler;
import com.almasb.fxgl.service.Executor;
import com.almasb.fxgl.service.Input;
import com.google.inject.Inject;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/almasb/fxgl/app/PreInitTask;", "Ljava/lang/Runnable;", "app", "Lcom/almasb/fxgl/app/GameApplication;", "(Lcom/almasb/fxgl/app/GameApplication;)V", "log", "Lcom/almasb/fxgl/core/logging/Logger;", "kotlin.jvm.PlatformType", "run", "", "fxgl"})
public final class PreInitTask
implements Runnable {
    private final Logger log;
    private final GameApplication app;

    @Override
    public void run() {
        ExceptionHandler exceptionHandler = this.app.getExceptionHandler();
        Intrinsics.checkExpressionValueIsNotNull((Object)exceptionHandler, (String)"app.exceptionHandler");
        FXGLIO.INSTANCE.setDefaultExceptionHandler((Consumer)exceptionHandler);
        Executor executor = this.app.getExecutor();
        Intrinsics.checkExpressionValueIsNotNull((Object)executor, (String)"app.executor");
        FXGLIO.INSTANCE.setDefaultExecutor((java.util.concurrent.Executor)executor);
        this.log.debug("Injecting gameWorld & physicsWorld");
        this.app.gameWorld = FXGL.Companion.getInstance(GameWorld.class);
        this.app.physicsWorld = FXGL.Companion.getInstance(PhysicsWorld.class);
        this.app.initAchievements();
        Input input = this.app.getInput();
        Intrinsics.checkExpressionValueIsNotNull((Object)input, (String)"app.input");
        SystemActions.INSTANCE.bind(input);
        this.app.initInput();
        this.app.getInput().scanForUserActions((Object)this.app);
        this.app.preInit();
    }

    @Inject
    public PreInitTask(@NotNull GameApplication app) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)app), (String)"app");
        this.app = app;
        this.log = FXGL.Companion.getLogger(this.getClass());
    }
}

