/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.effect;

import com.almasb.fxgl.effect.ParticleEmitter;
import java.util.Random;
import javafx.geometry.Point2D;
import javafx.scene.effect.BlendMode;
import javafx.scene.paint.Color;
import javafx.util.Duration;

public final class ParticleEmitters {
    private static final Random random = new Random();

    private static double rand() {
        return random.nextDouble();
    }

    private static double rand(double min, double max) {
        return ParticleEmitters.rand() * (max - min) + min;
    }

    public static ParticleEmitter newFireEmitter() {
        ParticleEmitter emitter = new ParticleEmitter();
        emitter.setNumParticles(15);
        emitter.setEmissionRate(0.5);
        emitter.setColorFunction(() -> Color.rgb((int)230, (int)75, (int)40));
        emitter.setSize(9.0, 12.0);
        emitter.setVelocityFunction((i, x, y) -> new Point2D(ParticleEmitters.rand(-0.5, 0.5) * 0.25, ParticleEmitters.rand() * -1.0));
        emitter.setSpawnPointFunction((i, x, y) -> new Point2D(x.doubleValue(), y.doubleValue()).add(new Point2D((double)i.intValue() * (ParticleEmitters.rand() - 0.5), ParticleEmitters.rand() - 1.0)));
        emitter.setScaleFunction((i, x, y) -> new Point2D(ParticleEmitters.rand(-0.01, 0.01) * 10.0, ParticleEmitters.rand() * -0.1));
        emitter.setExpireFunction((i, x, y) -> Duration.seconds((double)1.0));
        emitter.setBlendFunction((i, x, y) -> i < emitter.getNumParticles() / 2 ? BlendMode.ADD : BlendMode.COLOR_DODGE);
        return emitter;
    }

    public static ParticleEmitter newExplosionEmitter() {
        ParticleEmitter emitter = new ParticleEmitter();
        emitter.setNumParticles(100);
        emitter.setEmissionRate(0.0166);
        emitter.setSize(5.0, 20.0);
        emitter.setSpawnPointFunction((i, x, y) -> new Point2D(x.doubleValue(), y.doubleValue()));
        emitter.setVelocityFunction((i, x, y) -> new Point2D(Math.cos(i.intValue()), Math.sin(i.intValue())).multiply(0.75));
        emitter.setScaleFunction((i, x, y) -> new Point2D(ParticleEmitters.rand() * -0.1, ParticleEmitters.rand() * -0.1));
        emitter.setExpireFunction((i, x, y) -> Duration.seconds((double)0.5));
        emitter.setColorFunction(() -> Color.rgb((int)((int)ParticleEmitters.rand(200.0, 255.0)), (int)30, (int)20));
        emitter.setBlendFunction((i, x, y) -> i < emitter.getNumParticles() / 2 ? BlendMode.ADD : BlendMode.COLOR_BURN);
        return emitter;
    }

    public static ParticleEmitter newImplosionEmitter() {
        ParticleEmitter emitter = new ParticleEmitter();
        emitter.setNumParticles(100);
        emitter.setEmissionRate(0.0166);
        emitter.setSize(5.0, 20.0);
        emitter.setSpawnPointFunction((i, x, y) -> {
            Point2D vector = new Point2D(Math.cos(i.intValue()), Math.sin(i.intValue()));
            return new Point2D(x.doubleValue(), y.doubleValue()).add(vector.multiply(25.0));
        });
        emitter.setVelocityFunction((i, x, y) -> {
            Point2D vector = new Point2D(Math.cos(i.intValue()), Math.sin(i.intValue()));
            Point2D newPos = new Point2D(x.doubleValue(), y.doubleValue()).add(vector.multiply(25.0));
            return newPos.subtract(new Point2D(x.doubleValue(), y.doubleValue())).multiply(-0.05);
        });
        emitter.setScaleFunction((i, x, y) -> new Point2D(ParticleEmitters.rand() * -0.1, ParticleEmitters.rand() * -0.1));
        emitter.setExpireFunction((i, x, y) -> Duration.seconds((double)0.5));
        emitter.setColorFunction(() -> Color.rgb((int)((int)ParticleEmitters.rand(200.0, 255.0)), (int)30, (int)20));
        emitter.setBlendFunction((i, x, y) -> i < emitter.getNumParticles() / 2 ? BlendMode.ADD : BlendMode.COLOR_DODGE);
        return emitter;
    }

    public static ParticleEmitter newSparkEmitter() {
        ParticleEmitter emitter = new ParticleEmitter();
        emitter.setNumParticles(30);
        emitter.setEmissionRate(0.0083);
        emitter.setSize(1.0, 2.0);
        emitter.setSpawnPointFunction((i, x, y) -> new Point2D(x.doubleValue(), y.doubleValue()));
        emitter.setVelocityFunction((i, x, y) -> new Point2D(ParticleEmitters.rand(-1.0, 1.0), ParticleEmitters.rand(-6.0, -5.0)).multiply(0.1));
        emitter.setGravityFunction(() -> new Point2D(0.0, ParticleEmitters.rand(0.01, 0.015)));
        emitter.setExpireFunction((i, x, y) -> Duration.seconds((double)2.0));
        emitter.setColorFunction(() -> Color.rgb((int)30, (int)35, (int)((int)ParticleEmitters.rand(200.0, 255.0))));
        return emitter;
    }

    public static ParticleEmitter newSmokeEmitter() {
        ParticleEmitter emitter = new ParticleEmitter();
        emitter.setNumParticles(5);
        emitter.setEmissionRate(1.0);
        emitter.setSize(9.0, 10.0);
        emitter.setSpawnPointFunction((i, x, y) -> new Point2D(x.doubleValue(), y.doubleValue()).add(ParticleEmitters.rand(-1.0, 1.0), 0.0));
        emitter.setVelocityFunction((i, x, y) -> new Point2D(ParticleEmitters.rand() * 0.1, 0.0));
        emitter.setGravityFunction(() -> new Point2D(0.0, ParticleEmitters.rand() * -0.03));
        emitter.setExpireFunction((i, x, y) -> Duration.seconds((double)ParticleEmitters.rand(1.0, 3.0)));
        emitter.setColorFunction(() -> Color.rgb((int)230, (int)230, (int)230));
        emitter.setScaleFunction((i, x, y) -> new Point2D(-0.01, -0.05));
        return emitter;
    }

    public static ParticleEmitter newRainEmitter(int width) {
        ParticleEmitter emitter = new ParticleEmitter();
        emitter.setNumParticles(5);
        emitter.setEmissionRate(1.0);
        emitter.setSize(6.0, 7.0);
        emitter.setSpawnPointFunction((i, x, y) -> new Point2D(ParticleEmitters.rand() * (double)width + x, -25.0 + y));
        emitter.setVelocityFunction((i, x, y) -> new Point2D(0.0, ParticleEmitters.rand() * 15.0));
        emitter.setGravityFunction(() -> new Point2D(0.0, ParticleEmitters.rand() * 0.03));
        emitter.setExpireFunction((i, x, y) -> Duration.seconds((double)ParticleEmitters.rand(1.0, 3.0)));
        emitter.setScaleFunction((i, x, y) -> new Point2D(-0.02, 0.0));
        emitter.setBlendFunction((i, x, y) -> BlendMode.SRC_OVER);
        return emitter;
    }
}

