/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.entity;

import com.almasb.fxgl.app.FXGL;
import com.almasb.fxgl.core.math.Vec2;
import com.almasb.fxgl.ecs.Component;
import com.almasb.fxgl.ecs.Control;
import com.almasb.fxgl.ecs.Entity;
import com.almasb.fxgl.entity.GameEntity;
import com.almasb.fxgl.entity.GameWorld;
import com.almasb.fxgl.entity.RenderLayer;
import com.almasb.fxgl.entity.SpawnData;
import com.almasb.fxgl.entity.animation.AnimationBuilder;
import com.almasb.fxgl.entity.component.BoundingBoxComponent;
import com.almasb.fxgl.entity.component.PositionComponent;
import com.almasb.fxgl.entity.component.RotationComponent;
import com.almasb.fxgl.entity.component.TypeComponent;
import com.almasb.fxgl.entity.component.ViewComponent;
import com.almasb.fxgl.parser.tiled.Layer;
import com.almasb.fxgl.parser.tiled.TiledMap;
import com.almasb.fxgl.parser.tiled.Tileset;
import com.almasb.fxgl.physics.BoundingShape;
import com.almasb.fxgl.physics.HitBox;
import com.almasb.fxgl.physics.PhysicsComponent;
import java.util.List;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.image.WritableImage;

public final class Entities {
    private Entities() {
    }

    public static PositionComponent getPosition(Entity e) {
        return (PositionComponent)e.getComponentUnsafe(PositionComponent.class);
    }

    public static RotationComponent getRotation(Entity e) {
        return (RotationComponent)e.getComponentUnsafe(RotationComponent.class);
    }

    public static BoundingBoxComponent getBBox(Entity e) {
        return (BoundingBoxComponent)e.getComponentUnsafe(BoundingBoxComponent.class);
    }

    public static PhysicsComponent getPhysics(Entity e) {
        return (PhysicsComponent)e.getComponentUnsafe(PhysicsComponent.class);
    }

    public static ViewComponent getView(Entity e) {
        return (ViewComponent)e.getComponentUnsafe(ViewComponent.class);
    }

    public static TypeComponent getType(Entity e) {
        return (TypeComponent)e.getComponentUnsafe(TypeComponent.class);
    }

    public static Entity makeScreenBounds(double thickness) {
        double w = FXGL.getSettings().getWidth();
        double h = FXGL.getSettings().getHeight();
        Entity bounds = new Entity();
        bounds.addComponent((Component)new PositionComponent(0.0, 0.0));
        bounds.addComponent((Component)new RotationComponent(0.0));
        bounds.addComponent((Component)new BoundingBoxComponent(new HitBox("LEFT", new Point2D(-thickness, 0.0), BoundingShape.box(thickness, h)), new HitBox("RIGHT", new Point2D(w, 0.0), BoundingShape.box(thickness, h)), new HitBox("TOP", new Point2D(0.0, -thickness), BoundingShape.box(w, thickness)), new HitBox("BOT", new Point2D(0.0, h), BoundingShape.box(w, thickness))));
        bounds.addComponent((Component)new PhysicsComponent());
        return bounds;
    }

    public static GameEntityBuilder builder() {
        return new GameEntityBuilder();
    }

    public static AnimationBuilder animationBuilder() {
        return new AnimationBuilder();
    }

    private static Tileset findTileset(int gid, List<Tileset> tilesets) {
        return tilesets.stream().filter(tileset -> gid >= tileset.getFirstgid() && gid < tileset.getFirstgid() + tileset.getTilecount()).findAny().orElseThrow(() -> new IllegalArgumentException("Tileset for gid=" + gid + " not found"));
    }

    public static class GameEntityBuilder {
        private GameEntity entity = new GameEntity();

        public GameEntityBuilder from(SpawnData data) {
            this.at(data.getX(), data.getY());
            return this;
        }

        public GameEntityBuilder type(Enum<?> type) {
            this.entity.getTypeComponent().setValue(type);
            return this;
        }

        public GameEntityBuilder at(double x, double y) {
            this.entity.getPositionComponent().setValue(x, y);
            return this;
        }

        public GameEntityBuilder at(Point2D position2) {
            return this.at(position2.getX(), position2.getY());
        }

        public GameEntityBuilder at(Vec2 position2) {
            return this.at(position2.x, position2.y);
        }

        public GameEntityBuilder rotate(double angle) {
            this.entity.getRotationComponent().setValue(angle);
            return this;
        }

        public GameEntityBuilder bbox(HitBox box) {
            this.entity.getBoundingBoxComponent().addHitBox(box);
            return this;
        }

        public GameEntityBuilder viewFromNode(Node view) {
            this.entity.getViewComponent().setView(view);
            return this;
        }

        public GameEntityBuilder viewFromNodeWithBBox(Node view) {
            this.entity.getViewComponent().setView(view, true);
            return this;
        }

        public GameEntityBuilder viewFromTexture(String textureName) {
            this.entity.getViewComponent().setTexture(textureName);
            return this;
        }

        public GameEntityBuilder viewFromTextureWithBBox(String textureName) {
            this.entity.getViewComponent().setTexture(textureName, true);
            return this;
        }

        public GameEntityBuilder renderLayer(RenderLayer layer) {
            this.entity.getViewComponent().setRenderLayer(layer);
            return this;
        }

        public GameEntityBuilder viewFromTiles(TiledMap map, String layerName) {
            return this.viewFromTiles(map, layerName, RenderLayer.TOP);
        }

        public GameEntityBuilder viewFromTiles(TiledMap map, String layerName, RenderLayer renderLayer) {
            this.entity.getViewComponent().setView(this.tilesToView(map, layerName), false);
            this.entity.getViewComponent().setRenderLayer(renderLayer);
            return this;
        }

        private Node tilesToView(TiledMap map, String layerName) {
            Layer layer = map.getLayerByName(layerName);
            WritableImage buffer = new WritableImage(layer.getWidth() * map.getTilewidth(), layer.getHeight() * map.getTileheight());
            for (int i = 0; i < layer.getData().size(); ++i) {
                int gid = layer.getData().get(i);
                if (gid == 0) continue;
                Tileset tileset = Entities.findTileset(gid, map.getTilesets());
                int tilex = (gid -= tileset.getFirstgid()) % tileset.getColumns();
                int tiley = gid / tileset.getColumns();
                int x = i % layer.getWidth();
                int y = i / layer.getWidth();
                int w = tileset.getTilewidth();
                int h = tileset.getTileheight();
                String imageName = tileset.getImage();
                imageName = imageName.substring(imageName.lastIndexOf("/") + 1);
                Image sourceImage = FXGL.getAssetLoader().loadTexture(imageName).getImage();
                buffer.getPixelWriter().setPixels(x * w, y * h, w, h, sourceImage.getPixelReader(), tilex * w, tiley * h);
            }
            return new ImageView((Image)buffer);
        }

        public GameEntityBuilder with(Component ... components) {
            for (Component c : components) {
                this.entity.addComponent(c);
            }
            return this;
        }

        public GameEntityBuilder with(Control ... controls) {
            for (Control c : controls) {
                this.entity.addControl(c);
            }
            return this;
        }

        public GameEntity build() {
            return this.entity;
        }

        public GameEntity buildAndAttach(GameWorld world) {
            world.addEntity(this.entity);
            return this.entity;
        }
    }
}

