/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.entity;

import com.almasb.fxgl.core.math.Vec2;
import com.almasb.fxgl.ecs.Component;
import com.almasb.fxgl.ecs.Entity;
import com.almasb.fxgl.entity.EntityView;
import com.almasb.fxgl.entity.RenderLayer;
import com.almasb.fxgl.entity.component.BoundingBoxComponent;
import com.almasb.fxgl.entity.component.PositionComponent;
import com.almasb.fxgl.entity.component.RotationComponent;
import com.almasb.fxgl.entity.component.TypeComponent;
import com.almasb.fxgl.entity.component.ViewComponent;
import com.almasb.fxgl.physics.HitBox;
import javafx.geometry.Point2D;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;

public class GameEntity
extends Entity {
    private TypeComponent type = new TypeComponent();
    private PositionComponent position = new PositionComponent();
    private RotationComponent rotation = new RotationComponent();
    private BoundingBoxComponent bbox = new BoundingBoxComponent(new HitBox[0]);
    private ViewComponent view = new ViewComponent();

    public GameEntity() {
        this.addComponent((Component)this.type);
        this.addComponent((Component)this.position);
        this.addComponent((Component)this.rotation);
        this.addComponent((Component)this.bbox);
        this.addComponent((Component)this.view);
    }

    public final TypeComponent getTypeComponent() {
        return this.type;
    }

    public final PositionComponent getPositionComponent() {
        return this.position;
    }

    public final RotationComponent getRotationComponent() {
        return this.rotation;
    }

    public final BoundingBoxComponent getBoundingBoxComponent() {
        return this.bbox;
    }

    public final ViewComponent getViewComponent() {
        return this.view;
    }

    public final Object getType() {
        return this.type.getValue();
    }

    public final boolean isType(Object type) {
        return this.type.isType(type);
    }

    public final Point2D getPosition() {
        return this.position.getValue();
    }

    public final void setPosition(Point2D position2) {
        this.position.setValue(position2);
    }

    public final double getX() {
        return this.position.getX();
    }

    public final double getY() {
        return this.position.getY();
    }

    public final void setX(double x) {
        this.position.setX(x);
    }

    public final void setY(double y) {
        this.position.setY(y);
    }

    public final void translate(Point2D vector) {
        this.position.translate(vector);
    }

    public final void translate(Vec2 vector) {
        this.position.translate(vector.x, vector.y);
    }

    public final void translate(double dx, double dy) {
        this.position.translate(dx, dy);
    }

    public final void translateX(double dx) {
        this.position.translateX(dx);
    }

    public final void translateY(double dy) {
        this.position.translateY(dy);
    }

    public final void translateTowards(Point2D point, double speed) {
        this.position.translateTowards(point, speed);
    }

    public final double distance(GameEntity other) {
        return this.position.distance(other.position);
    }

    public final double getRotation() {
        return this.rotation.getValue();
    }

    public final void setRotation(double angle) {
        this.rotation.setValue(angle);
    }

    public final void rotateBy(double angle) {
        this.rotation.rotateBy(angle);
    }

    public final void rotateToVector(Point2D vector) {
        this.rotation.rotateToVector(vector);
    }

    public final double getWidth() {
        return this.bbox.getWidth();
    }

    public final double getHeight() {
        return this.bbox.getHeight();
    }

    public final double getRightX() {
        return this.bbox.getMaxXWorld();
    }

    public final double getBottomY() {
        return this.bbox.getMaxYWorld();
    }

    public final Point2D getCenter() {
        return this.bbox.getCenterWorld();
    }

    public final boolean isColliding(GameEntity other) {
        return this.bbox.isCollidingWith(other.bbox);
    }

    public final boolean isWithin(Rectangle2D bounds) {
        return this.bbox.isWithin(bounds);
    }

    public final EntityView getView() {
        return this.view.getView();
    }

    public final void setView(Node view) {
        this.view.setView(view);
    }

    public final void setViewFromTexture(String textureName) {
        this.view.setTexture(textureName);
    }

    public final void setViewFromTextureWithBBox(String textureName) {
        this.view.setTexture(textureName, true);
    }

    public final void setViewWithBBox(Node view) {
        this.view.setView(view, true);
    }

    public final RenderLayer getRenderLayer() {
        return this.view.getRenderLayer();
    }

    public final void setRenderLayer(RenderLayer layer) {
        this.view.setRenderLayer(layer);
    }

    public final void setScaleX(double scaleX) {
        this.view.getView().setScaleX(scaleX);
    }

    public final void setScaleY(double scaleY) {
        this.view.getView().setScaleY(scaleY);
    }

    public String toString() {
        return "GameEntity(" + (Object)((Object)this.type) + "," + (Object)((Object)this.position) + "," + (Object)((Object)this.rotation) + ")";
    }
}

