/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.entity.control;

import com.almasb.fxgl.app.FXGL;
import com.almasb.fxgl.ecs.AbstractControl;
import com.almasb.fxgl.ecs.Entity;
import com.almasb.fxgl.ecs.component.Required;
import com.almasb.fxgl.entity.component.PositionComponent;
import com.almasb.fxgl.time.LocalTimer;
import javafx.util.Duration;

@Required(value=PositionComponent.class)
public class LiftControl
extends AbstractControl {
    private LocalTimer timer;
    private Duration duration;
    private double distance;
    private boolean goingUp;
    private double speed;
    private PositionComponent position;

    public LiftControl(Duration duration, double distance, boolean goingUp) {
        this.duration = duration;
        this.distance = distance;
        this.goingUp = goingUp;
    }

    public void onAdded(Entity entity) {
        this.position = (PositionComponent)entity.getComponentUnsafe(PositionComponent.class);
        this.timer = FXGL.newLocalTimer();
        this.speed = this.distance / this.duration.toSeconds();
    }

    public void onUpdate(Entity entity, double tpf) {
        if (this.timer.elapsed(this.duration)) {
            this.goingUp = !this.goingUp;
            this.timer.capture();
        }
        this.position.translateY(this.goingUp ? -this.speed * tpf : this.speed * tpf);
    }
}

