/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.gameplay;

import com.almasb.fxgl.app.FXGL;
import com.almasb.fxgl.gameplay.Notification;
import java.util.Arrays;
import javafx.animation.Transition;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.control.Button;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.paint.Color;
import javafx.util.Duration;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\tJ\u0006\u0010\f\u001a\u00020\rJ\u0006\u0010\u000e\u001a\u00020\rR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/almasb/fxgl/gameplay/NotificationView;", "Ljavafx/scene/control/Button;", "notification", "Lcom/almasb/fxgl/gameplay/Notification;", "bgColor", "Ljavafx/scene/paint/Color;", "in", "Ljavafx/animation/Transition;", "out", "(Lcom/almasb/fxgl/gameplay/Notification;Ljavafx/scene/paint/Color;Ljavafx/animation/Transition;Ljavafx/animation/Transition;)V", "getNotification", "()Lcom/almasb/fxgl/gameplay/Notification;", "hide", "", "show", "fxgl"})
public final class NotificationView
extends Button {
    @NotNull
    private final Notification notification;
    private final Transition in;
    private final Transition out;

    public final void show() {
        this.in.play();
    }

    public final void hide() {
        this.out.play();
    }

    @NotNull
    public final Notification getNotification() {
        return this.notification;
    }

    public NotificationView(@NotNull Notification notification, @NotNull Color bgColor, @NotNull Transition in, @NotNull Transition out) {
        Intrinsics.checkParameterIsNotNull((Object)notification, (String)"notification");
        Intrinsics.checkParameterIsNotNull((Object)bgColor, (String)"bgColor");
        Intrinsics.checkParameterIsNotNull((Object)in, (String)"in");
        Intrinsics.checkParameterIsNotNull((Object)out, (String)"out");
        super(notification.getMessage());
        this.notification = notification;
        this.in = in;
        this.out = out;
        this.getStyleClass().setAll((Object[])new String[]{"fxgl_button"});
        this.setAlignment(Pos.CENTER);
        this.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

            public final void handle(KeyEvent e) {
                if (Intrinsics.areEqual((Object)e.getCode(), (Object)KeyCode.ENTER)) {
                    this.fire();
                }
            }
        });
        this.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public final void handle(ActionEvent e) {
                this.hide();
            }
        });
        this.setFont(FXGL.Companion.getUIFactory().newFont(12.0));
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        String string = "rgb(%d,%d,%d);";
        Object[] objectArray = new Object[]{(int)(bgColor.getRed() * (double)255), (int)(bgColor.getGreen() * (double)255), (int)(bgColor.getBlue() * (double)255)};
        StringBuilder stringBuilder = new StringBuilder().append("-fx-background-color: ");
        NotificationView notificationView = this;
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(format, *args)");
        String string3 = string2;
        notificationView.setStyle(stringBuilder.append(string3).toString());
        this.in.setOnFinished((EventHandler)new EventHandler<ActionEvent>(){

            public final void handle(ActionEvent e) {
                FXGL.Companion.getMasterTimer().runOnceAfter(new Runnable(){

                    @Override
                    public final void run() {
                        this.hide();
                    }
                }, Duration.seconds((double)3.0));
            }
        });
    }
}

