/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.parser.text;

import com.almasb.fxgl.annotation.SpawnSymbol;
import com.almasb.fxgl.app.FXGL;
import com.almasb.fxgl.core.logging.Logger;
import com.almasb.fxgl.core.reflect.ReflectionUtils;
import com.almasb.fxgl.ecs.Entity;
import com.almasb.fxgl.entity.EntitySpawner;
import com.almasb.fxgl.entity.SpawnData;
import com.almasb.fxgl.entity.TextEntityFactory;
import com.almasb.fxgl.gameplay.Level;
import com.almasb.fxgl.parser.LevelParser;
import com.almasb.fxgl.service.AssetLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007B\r\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0016\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u0011J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/almasb/fxgl/parser/text/TextLevelParser;", "Lcom/almasb/fxgl/parser/LevelParser;", "emptyChar", "", "blockWidth", "", "blockHeight", "(CII)V", "entityFactory", "Lcom/almasb/fxgl/entity/TextEntityFactory;", "(Lcom/almasb/fxgl/entity/TextEntityFactory;)V", "getEmptyChar", "()C", "getEntityFactory", "()Lcom/almasb/fxgl/entity/TextEntityFactory;", "producers", "Ljava/util/HashMap;", "Lcom/almasb/fxgl/entity/EntitySpawner;", "addEntityProducer", "", "character", "producer", "parse", "Lcom/almasb/fxgl/gameplay/Level;", "levelFileName", "", "Companion", "fxgl"})
public final class TextLevelParser
implements LevelParser {
    private final HashMap<Character, EntitySpawner> producers;
    private final char emptyChar;
    @NotNull
    private final TextEntityFactory entityFactory;
    private static final Logger log;
    public static final Companion Companion;

    public final char getEmptyChar() {
        return this.emptyChar;
    }

    public final void addEntityProducer(char character, @NotNull EntitySpawner producer) {
        Intrinsics.checkParameterIsNotNull((Object)producer, (String)"producer");
        this.producers.put(Character.valueOf(character), producer);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Level parse(@NotNull String levelFileName) {
        Intrinsics.checkParameterIsNotNull((Object)levelFileName, (String)"levelFileName");
        AssetLoader assetLoader = FXGL.Companion.getAssetLoader();
        List<String> lines = assetLoader.loadText(levelFileName);
        ArrayList<Entity> entities = new ArrayList<Entity>();
        int maxWidth = 0;
        int n = 0;
        int n2 = ((Collection)lines).size() - 1;
        if (n <= n2) {
            while (true) {
                int n3;
                void i;
                String line;
                if ((line = lines.get((int)i)).length() > maxWidth) {
                    maxWidth = line.length();
                }
                IntRange intRange = RangesKt.until((int)0, (int)line.length());
                int n4 = intRange.getFirst();
                if (n4 <= (n3 = intRange.getLast())) {
                    while (true) {
                        void j;
                        char c;
                        EntitySpawner producer;
                        if ((producer = this.producers.get(Character.valueOf(c = line.charAt((int)j)))) != null) {
                            Entity e = producer.spawn(new SpawnData((double)j * (double)this.entityFactory.blockWidth(), (double)i * (double)this.entityFactory.blockHeight()));
                            entities.add(e);
                        } else if (c != this.emptyChar) {
                            TextLevelParser.Companion.getLog().warning("No producer found for character: " + c);
                        }
                        if (j == n3) break;
                        ++j;
                    }
                }
                if (i == n2) break;
                ++i;
            }
        }
        return new Level(maxWidth * this.entityFactory.blockWidth(), lines.size() * this.entityFactory.blockHeight(), (List<? extends Entity>)entities);
    }

    @NotNull
    public final TextEntityFactory getEntityFactory() {
        return this.entityFactory;
    }

    public TextLevelParser(@NotNull TextEntityFactory entityFactory) {
        Intrinsics.checkParameterIsNotNull((Object)entityFactory, (String)"entityFactory");
        this.entityFactory = entityFactory;
        this.producers = new HashMap();
        this.emptyChar = this.entityFactory.emptyChar();
        Map $receiver$iv = ReflectionUtils.findMethodsMapToFunctions((Object)this.entityFactory, SpawnSymbol.class, EntitySpawner.class);
        Map map = $receiver$iv;
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry it = element$iv = iterator.next();
            this.producers.put(Character.valueOf(((SpawnSymbol)it.getKey()).value()), (EntitySpawner)it.getValue());
        }
    }

    public TextLevelParser(final char emptyChar, final int blockWidth, final int blockHeight) {
        this(new TextEntityFactory(){

            @Override
            public char emptyChar() {
                return emptyChar;
            }

            @Override
            public int blockWidth() {
                return blockWidth;
            }

            @Override
            public int blockHeight() {
                return blockHeight;
            }
        });
    }

    static {
        Companion = new Companion(null);
        log = FXGL.Companion.getLogger("FXGL.TextLevelParser");
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/almasb/fxgl/parser/text/TextLevelParser$Companion;", "", "()V", "log", "Lcom/almasb/fxgl/core/logging/Logger;", "kotlin.jvm.PlatformType", "getLog", "()Lcom/almasb/fxgl/core/logging/Logger;", "fxgl"})
    public static final class Companion {
        private final Logger getLog() {
            return log;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

