/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.saving;

import com.almasb.fxgl.app.FXGL;
import com.almasb.fxgl.core.logging.Logger;
import com.almasb.fxgl.io.FS;
import com.almasb.fxgl.io.FileExtension;
import com.almasb.fxgl.io.IOTask;
import com.almasb.fxgl.io.UIDialogHandler;
import com.almasb.fxgl.saving.DataFile;
import com.almasb.fxgl.saving.SaveFile;
import com.almasb.fxgl.scene.ProgressDialog;
import com.almasb.fxgl.settings.UserProfile;
import java.io.FileNotFoundException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;

public final class SaveLoadManager {
    private static final Logger log = FXGL.getLogger("FXGL.SaveLoadManager");
    private static final String PROFILE_FILE_NAME = FXGL.getString("fs.profilename");
    private static final String PROFILES_DIR = FXGL.getString("fs.profiledir");
    private static final String SAVE_DIR = FXGL.getString("fs.savedir");
    private static final String SAVE_FILE_EXT = FXGL.getString("fs.savefile.ext");
    private static final String DATA_FILE_EXT = FXGL.getString("fs.datafile.ext");
    private final String profileName;
    private ObservableList<SaveFile> saveFiles = FXCollections.observableArrayList();

    public SaveLoadManager(String profileName) {
        this.profileName = profileName;
    }

    public ObservableList<SaveFile> saveFiles() {
        return FXCollections.unmodifiableObservableList(this.saveFiles);
    }

    public void querySaveFiles() {
        log.debug("Querying save files");
        this.loadSaveFilesTask().onSuccess(files -> {
            this.saveFiles.setAll((Collection)files);
            Collections.sort(this.saveFiles, SaveFile.RECENT_FIRST);
        }).executeAsyncWithDialogFX((UIDialogHandler)new ProgressDialog("Loading save files"));
    }

    private String profileDir() {
        return "./" + PROFILES_DIR + this.profileName + "/";
    }

    private String saveDir() {
        return this.profileDir() + SAVE_DIR;
    }

    public IOTask<Void> saveTask(DataFile dataFile, SaveFile saveFile) {
        log.debug(() -> "Saving data: " + saveFile.getName());
        return FS.writeDataTask((Serializable)saveFile, (String)(this.saveDir() + saveFile.getName() + SAVE_FILE_EXT)).then(n -> FS.writeDataTask((Serializable)dataFile, (String)(this.saveDir() + saveFile.getName() + DATA_FILE_EXT))).then(n -> IOTask.ofVoid((String)"updateSaves", () -> Platform.runLater(() -> {
            this.saveFiles.add((Object)saveFile);
            Collections.sort(this.saveFiles, SaveFile.RECENT_FIRST);
        })));
    }

    public IOTask<Void> saveProfileTask(UserProfile profile) {
        log.debug(() -> "Saving profile: " + this.profileName);
        return FS.writeDataTask((Serializable)profile, (String)(this.profileDir() + PROFILE_FILE_NAME)).then(n -> new IOTask<Void>("checkSavesDir(" + this.saveDir() + ")"){

            protected Void onExecute() throws Exception {
                Path dir = Paths.get(SaveLoadManager.this.saveDir(), new String[0]);
                if (!Files.exists(dir, new LinkOption[0])) {
                    log.debug(() -> "Creating non-existent saves dir");
                    Files.createDirectory(dir, new FileAttribute[0]);
                    Path readmeFile = Paths.get(SaveLoadManager.this.saveDir() + "Readme.txt", new String[0]);
                    Files.write(readmeFile, Collections.singletonList("This directory contains save files."), new OpenOption[0]);
                }
                return null;
            }
        });
    }

    public IOTask<DataFile> loadTask(SaveFile saveFile) {
        log.debug(() -> "Loading data: " + saveFile.getName());
        return FS.readDataTask((String)(this.saveDir() + saveFile.getName() + DATA_FILE_EXT));
    }

    public IOTask<UserProfile> loadProfileTask() {
        log.debug(() -> "Loading profile: " + this.profileName);
        return FS.readDataTask((String)(this.profileDir() + PROFILE_FILE_NAME));
    }

    public IOTask<Void> deleteSaveFileTask(SaveFile saveFile) {
        log.debug(() -> "Deleting save file: " + saveFile.getName());
        return FS.deleteFileTask((String)(this.saveDir() + saveFile.getName() + SAVE_FILE_EXT)).then(n -> FS.deleteFileTask((String)(this.saveDir() + saveFile.getName() + DATA_FILE_EXT))).then(n -> IOTask.ofVoid((String)"updateSaves", () -> Platform.runLater(() -> this.saveFiles.remove((Object)saveFile))));
    }

    public boolean saveFileExists(String saveFileName) {
        log.debug(() -> "Checking if save file exists: " + saveFileName);
        try {
            return Files.exists(Paths.get(this.saveDir() + saveFileName + SAVE_FILE_EXT, new String[0]), new LinkOption[0]);
        }
        catch (Exception e) {
            log.warning("Failed to check if file exists: " + e);
            return false;
        }
    }

    public static IOTask<List<String>> loadProfileNamesTask() {
        log.debug(() -> "Loading profile names");
        return FS.loadDirectoryNamesTask((String)("./" + PROFILES_DIR), (boolean)false);
    }

    public static IOTask<Void> deleteProfileTask(String profileName) {
        log.debug(() -> "Deleting profile: " + profileName);
        return FS.deleteDirectoryTask((String)("./" + PROFILES_DIR + profileName));
    }

    public IOTask<List<SaveFile>> loadSaveFilesTask() {
        log.debug(() -> "Loading save files");
        return FS.loadFileNamesTask((String)this.saveDir(), (boolean)true, Collections.singletonList(new FileExtension(SAVE_FILE_EXT))).then(fileNames -> IOTask.of((String)"readSaveFiles", () -> fileNames.stream().map(name -> (SaveFile)FS.readDataTask((String)(this.saveDir() + name)).execute()).filter(file -> file != null).collect(Collectors.toList())));
    }

    public IOTask<SaveFile> loadLastModifiedSaveFileTask() {
        log.debug(() -> "Loading last modified save file");
        return this.loadSaveFilesTask().then(files -> IOTask.of((String)"findLastSave", () -> {
            if (files.isEmpty()) {
                throw new FileNotFoundException("No save files found");
            }
            return files.stream().sorted(SaveFile.RECENT_FIRST).findFirst().get();
        }));
    }

    static {
        log.debug(() -> "Checking profiles dir: " + PROFILES_DIR);
        try {
            Path dir = Paths.get("./" + PROFILES_DIR, new String[0]);
            if (!Files.exists(dir, new LinkOption[0])) {
                log.debug(() -> "Creating non-existent profiles dir");
                Files.createDirectories(dir, new FileAttribute[0]);
                Path readmeFile = Paths.get("./" + PROFILES_DIR + "Readme.txt", new String[0]);
                Files.write(readmeFile, Collections.singletonList("This directory contains user profiles."), new OpenOption[0]);
            }
        }
        catch (Exception e) {
            log.warning(() -> "Failed to create profiles dir: " + e);
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }
}

