/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.service;

import com.almasb.fxgl.input.InputMapping;
import com.almasb.fxgl.input.InputModifier;
import com.almasb.fxgl.input.Trigger;
import com.almasb.fxgl.input.UserAction;
import com.almasb.fxgl.scene.Viewport;
import com.almasb.fxgl.service.listener.FXGLListener;
import com.almasb.fxgl.service.listener.UserProfileSavable;
import com.almasb.fxgl.time.UpdateEventListener;
import java.util.Map;
import javafx.geometry.Point2D;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;

public interface Input
extends UserProfileSavable,
UpdateEventListener,
FXGLListener {
    @Override
    default public void onPause() {
        this.clearAll();
    }

    @Override
    default public void onResume() {
        this.clearAll();
    }

    @Override
    default public void onReset() {
        this.clearAll();
    }

    @Override
    default public void onExit() {
    }

    public void onKeyEvent(KeyEvent var1);

    public void onMouseEvent(MouseEvent var1, Viewport var2, double var3);

    public void setRegisterInput(boolean var1);

    public boolean isRegisterInput();

    public void setProcessInput(boolean var1);

    public boolean isProcessInput();

    public boolean isHeld(KeyCode var1);

    public boolean isHeld(MouseButton var1);

    public Map<UserAction, Trigger> getBindings();

    default public void addAction(UserAction action2, KeyCode key) {
        this.addAction(action2, key, InputModifier.NONE);
    }

    public void addAction(UserAction var1, KeyCode var2, InputModifier var3);

    default public boolean rebind(UserAction action2, KeyCode key) {
        return this.rebind(action2, key, InputModifier.NONE);
    }

    public boolean rebind(UserAction var1, KeyCode var2, InputModifier var3);

    default public void addAction(UserAction action2, MouseButton button) {
        this.addAction(action2, button, InputModifier.NONE);
    }

    public void addAction(UserAction var1, MouseButton var2, InputModifier var3);

    default public boolean rebind(UserAction action2, MouseButton button) {
        return this.rebind(action2, button, InputModifier.NONE);
    }

    public boolean rebind(UserAction var1, MouseButton var2, InputModifier var3);

    public void addInputMapping(InputMapping var1);

    public void scanForUserActions(Object var1);

    public void clearAll();

    default public void mockKeyPress(KeyCode key) {
        this.mockKeyPress(key, InputModifier.NONE);
    }

    public void mockKeyPress(KeyCode var1, InputModifier var2);

    default public void mockKeyRelease(KeyCode key) {
        this.mockKeyRelease(key, InputModifier.NONE);
    }

    public void mockKeyRelease(KeyCode var1, InputModifier var2);

    default public void mockButtonPress(MouseButton button) {
        this.mockButtonPress(button, InputModifier.NONE);
    }

    default public void mockButtonPress(MouseButton button, InputModifier modifier) {
        this.mockButtonPress(button, this.getMouseXWorld(), this.getMouseYWorld(), modifier);
    }

    default public void mockButtonPress(MouseButton button, double gameX, double gameY) {
        this.mockButtonPress(button, gameX, gameY, InputModifier.NONE);
    }

    public void mockButtonPress(MouseButton var1, double var2, double var4, InputModifier var6);

    default public void mockButtonRelease(MouseButton button) {
        this.mockButtonRelease(button, InputModifier.NONE);
    }

    default public void mockButtonRelease(MouseButton button, InputModifier modifier) {
        this.mockButtonRelease(button, this.getMouseXWorld(), this.getMouseYWorld(), modifier);
    }

    default public void mockButtonRelease(MouseButton button, double gameX, double gameY) {
        this.mockButtonRelease(button, gameX, gameY, InputModifier.NONE);
    }

    public void mockButtonRelease(MouseButton var1, double var2, double var4, InputModifier var6);

    public Point2D getMousePositionWorld();

    default public double getMouseXWorld() {
        return this.getMousePositionWorld().getX();
    }

    default public double getMouseYWorld() {
        return this.getMousePositionWorld().getY();
    }

    public Point2D getMousePositionUI();

    default public double getMouseXUI() {
        return this.getMousePositionUI().getX();
    }

    default public double getMouseYUI() {
        return this.getMousePositionUI().getY();
    }

    default public Point2D getVectorToMouse(Point2D gamePosition) {
        return this.getMousePositionWorld().subtract(gamePosition);
    }

    default public Point2D getVectorFromMouse(Point2D gamePosition) {
        return this.getVectorToMouse(gamePosition).multiply(-1.0);
    }
}

