/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.service;

import com.almasb.fxgl.app.FXGL;
import javafx.animation.FadeTransition;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.Spinner;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javafx.util.Duration;

public interface UIFactory {
    public Font newFont(double var1);

    default public Text newText(String message) {
        return this.newText(message, Color.WHITE, 18.0);
    }

    default public Text newText(String message, double fontSize) {
        return this.newText(message, Color.WHITE, fontSize);
    }

    default public Text newText(String message, Color textColor, double fontSize) {
        Text text = new Text(message);
        text.setFill((Paint)textColor);
        text.setFont(this.newFont(fontSize));
        return text;
    }

    default public void centerTextX(Text text, double minX, double maxX) {
        text.setTranslateX((minX + maxX) / 2.0 - text.getLayoutBounds().getWidth() / 2.0);
    }

    default public void centerTextY(Text text, double minY, double maxY) {
        text.setTranslateY((minY + maxY) / 2.0 - text.getLayoutBounds().getHeight() / 2.0);
    }

    default public void centerText(Text text) {
        this.centerText(text, FXGL.getAppWidth() / 2, FXGL.getAppHeight() / 2);
    }

    default public void centerText(Text text, double x, double y) {
        text.setTranslateX(x - text.getLayoutBounds().getWidth() / 2.0);
        text.setTranslateY(y - text.getLayoutBounds().getHeight() / 2.0);
    }

    default public void centerTextBind(Text text) {
        this.centerTextBind(text, FXGL.getAppWidth() / 2, FXGL.getAppHeight() / 2);
    }

    default public void centerTextBind(Text text, double x, double y) {
        text.layoutBoundsProperty().addListener((o, old, bounds) -> {
            text.setTranslateX(x - bounds.getWidth() / 2.0);
            text.setTranslateY(y - bounds.getHeight() / 2.0);
        });
    }

    public Button newButton(String var1);

    public <T> ChoiceBox<T> newChoiceBox(ObservableList<T> var1);

    public <T> ChoiceBox<T> newChoiceBox();

    public CheckBox newCheckBox();

    public <T> Spinner<T> newSpinner(ObservableList<T> var1);

    default public FadeTransition fadeIn(Node node, Duration duration) {
        return this.fadeIn(node, duration, () -> {});
    }

    default public FadeTransition fadeIn(Node node, Duration duration, Runnable onFinishedAction) {
        FadeTransition ft = new FadeTransition(duration, node);
        ft.setFromValue(0.0);
        ft.setToValue(1.0);
        ft.setOnFinished(e -> onFinishedAction.run());
        ft.play();
        return ft;
    }

    default public FadeTransition fadeOut(Node node, Duration duration) {
        return this.fadeOut(node, duration, () -> {});
    }

    default public FadeTransition fadeOut(Node node, Duration duration, Runnable onFinishedAction) {
        FadeTransition ft = new FadeTransition(duration, node);
        ft.setFromValue(1.0);
        ft.setToValue(0.0);
        ft.setOnFinished(e -> onFinishedAction.run());
        ft.play();
        return ft;
    }

    default public FadeTransition fadeInOut(Node node, Duration duration) {
        return this.fadeInOut(node, duration, () -> {});
    }

    default public FadeTransition fadeInOut(Node node, Duration duration, Runnable onFinishedAction) {
        FadeTransition ft = new FadeTransition(duration, node);
        ft.setFromValue(0.0);
        ft.setToValue(1.0);
        ft.setCycleCount(2);
        ft.setAutoReverse(true);
        ft.setOnFinished(e -> onFinishedAction.run());
        ft.play();
        return ft;
    }

    default public FadeTransition fadeOutIn(Node node, Duration duration) {
        return this.fadeOutIn(node, duration, () -> {});
    }

    default public FadeTransition fadeOutIn(Node node, Duration duration, Runnable onFinishedAction) {
        FadeTransition ft = new FadeTransition(duration, node);
        ft.setFromValue(1.0);
        ft.setToValue(0.0);
        ft.setCycleCount(2);
        ft.setAutoReverse(true);
        ft.setOnFinished(e -> onFinishedAction.run());
        ft.play();
        return ft;
    }
}

