/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.service.impl.audio;

import com.almasb.fxgl.app.FXGL;
import com.almasb.fxgl.audio.Music;
import com.almasb.fxgl.audio.Sound;
import com.almasb.fxgl.core.logging.Logger;
import com.almasb.fxgl.io.serialization.Bundle;
import com.almasb.fxgl.service.AudioPlayer;
import com.almasb.fxgl.service.impl.audio.FXGLAudioPlayer;
import com.almasb.fxgl.settings.UserProfile;
import com.almasb.fxgl.time.UpdateEvent;
import com.google.inject.Inject;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.ObservableValue;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\u0018\u00002\u00020\u0001B\u0007\b\u0003\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u000fH\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0012H\u0016J\u0010\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u0005H\u0016J\u0010\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u0005H\u0016J\u0010\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u0007H\u0016J\b\u0010\u001e\u001a\u00020\u0012H\u0016J\u0010\u0010\u001f\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u0005H\u0016J\u0010\u0010 \u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010!\u001a\u00020\u0012H\u0016J\b\u0010\"\u001a\u00020\u0012H\u0016J\u0010\u0010#\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u0005H\u0016J\u0010\u0010$\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u0007H\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/almasb/fxgl/service/impl/audio/FXGLAudioPlayer;", "Lcom/almasb/fxgl/service/AudioPlayer;", "()V", "activeMusic", "Ljava/util/ArrayList;", "Lcom/almasb/fxgl/audio/Music;", "activeSounds", "Lcom/almasb/fxgl/audio/Sound;", "globalMusicVolume", "Ljavafx/beans/property/SimpleDoubleProperty;", "globalSoundVolume", "log", "Lcom/almasb/fxgl/core/logging/Logger;", "kotlin.jvm.PlatformType", "globalMusicVolumeProperty", "Ljavafx/beans/property/DoubleProperty;", "globalSoundVolumeProperty", "load", "", "profile", "Lcom/almasb/fxgl/settings/UserProfile;", "onUpdateEvent", "event", "Lcom/almasb/fxgl/time/UpdateEvent;", "pauseAllMusic", "pauseMusic", "music", "playMusic", "playSound", "sound", "resumeAllMusic", "resumeMusic", "save", "stopAllMusic", "stopAllSounds", "stopMusic", "stopSound", "fxgl"})
public final class FXGLAudioPlayer
implements AudioPlayer {
    private final Logger log = FXGL.Companion.getLogger(this.getClass());
    private final ArrayList<Sound> activeSounds;
    private final ArrayList<Music> activeMusic;
    private final SimpleDoubleProperty globalMusicVolume;
    private final SimpleDoubleProperty globalSoundVolume;

    /*
     * WARNING - void declaration
     */
    @Override
    public void onUpdateEvent(@NotNull UpdateEvent event) {
        void $receiver$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)((Object)event), (String)"event");
        Iterable $receiver$iv = this.activeMusic;
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            Music it = (Music)element$iv$iv;
            if (!it.reachedEnd$fxgl()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        for (Object element$iv : $receiver$iv) {
            Music it = (Music)element$iv;
            this.log.debug("Stopping music: " + it);
            it.stop$fxgl();
        }
        this.activeSounds.removeIf(onUpdateEvent.3.INSTANCE);
        this.activeMusic.removeIf(onUpdateEvent.4.INSTANCE);
    }

    @Override
    @NotNull
    public DoubleProperty globalMusicVolumeProperty() {
        return (DoubleProperty)this.globalMusicVolume;
    }

    @Override
    @NotNull
    public DoubleProperty globalSoundVolumeProperty() {
        return (DoubleProperty)this.globalSoundVolume;
    }

    @Override
    public void playSound(@NotNull Sound sound) {
        Intrinsics.checkParameterIsNotNull((Object)sound, (String)"sound");
        if (!this.activeSounds.contains(sound)) {
            this.activeSounds.add(sound);
        }
        sound.getClip$fxgl().volumeProperty().bind((ObservableValue)this.globalSoundVolumeProperty());
        sound.getClip$fxgl().play();
    }

    @Override
    public void stopSound(@NotNull Sound sound) {
        Intrinsics.checkParameterIsNotNull((Object)sound, (String)"sound");
        this.activeSounds.remove(sound);
        sound.getClip$fxgl().stop();
    }

    @Override
    public void stopAllSounds() {
        this.log.debug("Stopping all sounds");
        Iterator<Sound> it = this.activeSounds.iterator();
        while (it.hasNext()) {
            it.next().getClip$fxgl().stop();
            it.remove();
        }
    }

    @Override
    public void playMusic(@NotNull Music music) {
        Intrinsics.checkParameterIsNotNull((Object)music, (String)"music");
        this.log.debug("Playing music " + music);
        if (this.activeMusic.contains(music)) {
            throw (Throwable)new IllegalArgumentException("Attempted to play " + music + ", which is already playing / paused");
        }
        this.activeMusic.add(music);
        music.bindVolume$fxgl((DoubleProperty)this.globalMusicVolume);
        music.start$fxgl();
    }

    @Override
    public void pauseMusic(@NotNull Music music) {
        Intrinsics.checkParameterIsNotNull((Object)music, (String)"music");
        this.log.debug("Pausing music " + music);
        if (this.activeMusic.contains(music)) {
            music.pause$fxgl();
        } else {
            this.log.warning("Attempted to pause " + music + " that is not managed by audio player. Managed music: " + this.activeMusic);
        }
    }

    @Override
    public void resumeMusic(@NotNull Music music) {
        Intrinsics.checkParameterIsNotNull((Object)music, (String)"music");
        this.log.debug("Resuming music " + music);
        if (this.activeMusic.contains(music)) {
            music.resume$fxgl();
        } else {
            this.log.warning("Attempted to resume " + music + " that is not managed by audio player. Managed music: " + this.activeMusic);
        }
    }

    @Override
    public void stopMusic(@NotNull Music music) {
        Intrinsics.checkParameterIsNotNull((Object)music, (String)"music");
        this.log.debug("Stopping music " + music);
        if (this.activeMusic.contains(music)) {
            music.stop$fxgl();
            this.activeMusic.remove(music);
        } else {
            this.log.warning("Attempted to stop " + music + " that is not managed by audio player. Managed music: " + this.activeMusic);
        }
    }

    @Override
    public void pauseAllMusic() {
        this.log.debug("Pausing all music");
        Iterable $receiver$iv = this.activeMusic;
        for (Object element$iv : $receiver$iv) {
            Music it = (Music)element$iv;
            it.pause$fxgl();
        }
    }

    @Override
    public void resumeAllMusic() {
        this.log.debug("Resuming all music");
        Iterable $receiver$iv = this.activeMusic;
        for (Object element$iv : $receiver$iv) {
            Music it = (Music)element$iv;
            it.resume$fxgl();
        }
    }

    @Override
    public void stopAllMusic() {
        this.log.debug("Stopping all music. Active music size: " + this.activeMusic.size());
        Iterable $receiver$iv = this.activeMusic;
        for (Object element$iv : $receiver$iv) {
            Music it = (Music)element$iv;
            it.stop$fxgl();
        }
    }

    @Override
    public void save(@NotNull UserProfile profile) {
        Intrinsics.checkParameterIsNotNull((Object)profile, (String)"profile");
        this.log.debug("Saving data to profile");
        Bundle bundle = new Bundle("audio");
        bundle.put("musicVolume", (Serializable)Double.valueOf(this.getGlobalMusicVolume()));
        bundle.put("soundVolume", (Serializable)Double.valueOf(this.getGlobalSoundVolume()));
        bundle.log();
        profile.putBundle(bundle);
    }

    @Override
    public void load(@NotNull UserProfile profile) {
        Intrinsics.checkParameterIsNotNull((Object)profile, (String)"profile");
        this.log.debug("Loading data from profile");
        Bundle bundle = profile.getBundle("audio");
        bundle.log();
        this.setGlobalMusicVolume(((Number)bundle.get("musicVolume")).doubleValue());
        this.setGlobalSoundVolume(((Number)bundle.get("soundVolume")).doubleValue());
    }

    @Inject
    private FXGLAudioPlayer() {
        this.log.debug("Service [AudioPlayer] initialized");
        this.activeSounds = new ArrayList();
        this.activeMusic = new ArrayList();
        this.globalMusicVolume = new SimpleDoubleProperty(0.5);
        this.globalSoundVolume = new SimpleDoubleProperty(0.5);
    }
}

